/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.SurfacePolygon;
import java.awt.Color;
import java.util.ArrayList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceQuadrilateral
extends SurfacePolygon {
    public SurfaceQuadrilateral(Sector sector, Color color, Color color2) {
        super(SurfaceQuadrilateral.makePositions(sector), color, color2);
    }

    public SurfaceQuadrilateral(Sector sector) {
        super(SurfaceQuadrilateral.makePositions(sector), null, null);
    }

    private static Iterable<LatLon> makePositions(Sector sector) {
        if (sector == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.SectorIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(5);
        arrayList.add(0, new LatLon(sector.getMinLatitude(), sector.getMinLongitude()));
        arrayList.add(1, new LatLon(sector.getMinLatitude(), sector.getMaxLongitude()));
        arrayList.add(2, new LatLon(sector.getMaxLatitude(), sector.getMaxLongitude()));
        arrayList.add(3, new LatLon(sector.getMaxLatitude(), sector.getMinLongitude()));
        arrayList.add(4, new LatLon(sector.getMinLatitude(), sector.getMinLongitude()));
        return arrayList;
    }
}

