/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.ElevationModel;
import gov.nasa.worldwind.Globe;
import gov.nasa.worldwind.PickSupport;
import gov.nasa.worldwind.PickedObject;
import gov.nasa.worldwind.SectorGeometry;
import gov.nasa.worldwind.SectorGeometryList;
import gov.nasa.worldwind.Tessellator;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import java.awt.Color;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EllipsoidRectangularTessellator
extends WWObjectImpl
implements Tessellator {
    private static final int DEFAULT_DENSITY = 24;
    private static final double DEFAULT_LOG10_RESOLUTION_TARGET = 1.3;
    private static final int DEFAULT_MAX_LEVEL = 12;
    private static final int DEFAULT_NUM_LAT_SUBDIVISIONS = 5;
    private static final int DEFAULT_NUM_LON_SUBDIVISIONS = 10;
    private final ArrayList<RectTile> topLevels;
    private SectorGeometryList currentTiles = new SectorGeometryList();
    private Frustum currentFrustum;
    private int currentLevel;
    private int maxLevel = 12;
    private Sector sector;
    private int density = 24;

    public EllipsoidRectangularTessellator(Globe globe) {
        this.topLevels = this.createTopLevelTiles(globe, 5, 10);
    }

    public Sector getSector() {
        return this.sector;
    }

    private ArrayList<RectTile> createTopLevelTiles(Globe globe, int n, int n2) {
        ArrayList<RectTile> arrayList = new ArrayList<RectTile>(n * n2);
        double d = 180.0 / (double)n;
        double d2 = 360.0 / (double)n2;
        Angle angle = Angle.NEG90;
        for (int i = 0; i < 5; ++i) {
            Angle angle2 = angle.addDegrees(d);
            if (angle2.getDegrees() + 1.0 > 90.0) {
                angle2 = Angle.POS90;
            }
            Angle angle3 = Angle.NEG180;
            for (int j = 0; j < 10; ++j) {
                Angle angle4 = angle3.addDegrees(d2);
                if (angle4.getDegrees() + 1.0 > 180.0) {
                    angle4 = Angle.POS180;
                }
                arrayList.add(new RectTile(globe, 0, this.density, new Sector(angle, angle2, angle3, angle4)));
                angle3 = angle4;
            }
            angle = angle2;
        }
        return arrayList;
    }

    @Override
    public SectorGeometryList tessellate(DrawContext drawContext) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getView() == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ViewIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        this.currentTiles.clear();
        this.currentLevel = 0;
        this.sector = null;
        this.currentFrustum = drawContext.getView().getFrustumInModelCoordinates();
        for (SectorGeometry sectorGeometry : this.topLevels) {
            this.selectVisibleTiles(drawContext, (RectTile)sectorGeometry);
        }
        drawContext.setVisibleSector(this.getSector());
        for (SectorGeometry sectorGeometry : this.currentTiles) {
            ((RectTile)sectorGeometry).makeVerts(drawContext);
        }
        return this.currentTiles;
    }

    private void selectVisibleTiles(DrawContext drawContext, RectTile rectTile) {
        if (!rectTile.getExtent().intersects(this.currentFrustum)) {
            return;
        }
        if (this.currentLevel < this.maxLevel && EllipsoidRectangularTessellator.needToSplit(drawContext, rectTile)) {
            RectTile[] rectTileArray;
            ++this.currentLevel;
            for (RectTile rectTile2 : rectTileArray = rectTile.split()) {
                this.selectVisibleTiles(drawContext, rectTile2);
            }
            --this.currentLevel;
            return;
        }
        this.sector = rectTile.getSector().union(this.sector);
        this.currentTiles.add(rectTile);
    }

    private static boolean needToSplit(DrawContext drawContext, RectTile rectTile) {
        Point[] pointArray = rectTile.sector.computeCornerPoints(drawContext.getGlobe());
        Point point = rectTile.sector.computeCenterPoint(drawContext.getGlobe());
        View view = drawContext.getView();
        double d = view.getEyePoint().distanceTo(pointArray[0]);
        double d2 = view.getEyePoint().distanceTo(pointArray[1]);
        double d3 = view.getEyePoint().distanceTo(pointArray[2]);
        double d4 = view.getEyePoint().distanceTo(pointArray[3]);
        double d5 = view.getEyePoint().distanceTo(point);
        double d6 = d;
        if (d2 < d6) {
            d6 = d2;
        }
        if (d3 < d6) {
            d6 = d3;
        }
        if (d4 < d6) {
            d6 = d4;
        }
        if (d5 < d6) {
            d6 = d5;
        }
        double d7 = Math.log10(d6);
        boolean bl = rectTile.log10CellSize <= d7 - 1.3;
        return !bl;
    }

    public static void main(String[] stringArray) {
        int n = 5;
        DoubleBuffer doubleBuffer = RectTile.getParameterization(n);
        IntBuffer intBuffer = RectTile.getIndices(n);
        doubleBuffer.rewind();
        intBuffer.rewind();
        for (int i = 0; i < intBuffer.limit(); ++i) {
            int n2 = intBuffer.get(i);
            System.out.println(n2 + ": " + doubleBuffer.get(2 * n2) + ", " + doubleBuffer.get(2 * n2 + 1));
        }
    }

    private static class RectTile
    implements SectorGeometry {
        private static final HashMap<Integer, DoubleBuffer> parameterizations = new HashMap();
        private static final HashMap<Integer, IntBuffer> indexLists = new HashMap();
        private final Globe globe;
        private final int level;
        private final Sector sector;
        private final Cylinder extent;
        private final int density;
        private final double log10CellSize;
        private long byteSize;
        private RenderInfo ri;
        private PickSupport pickSupport = new PickSupport();
        private int minColorCode = 0;
        private int maxColorCode = 0;

        public RectTile(Globe globe, int n, int n2, Sector sector) {
            this.globe = globe;
            this.level = n;
            this.density = n2;
            this.sector = sector;
            this.extent = Sector.computeBoundingCylinder(globe, 1.0, this.getSector());
            double d = sector.getDeltaLatRadians() * globe.getRadius() / (double)n2;
            this.log10CellSize = Math.log10(d);
        }

        public Sector getSector() {
            return this.sector;
        }

        public Extent getExtent() {
            return this.extent;
        }

        public long getSizeInBytes() {
            return this.byteSize;
        }

        private RectTile[] split() {
            Sector[] sectorArray = this.sector.subdivide();
            RectTile[] rectTileArray = new RectTile[]{new RectTile(this.globe, this.level + 1, this.density, sectorArray[0]), new RectTile(this.globe, this.level + 1, this.density, sectorArray[1]), new RectTile(this.globe, this.level + 1, this.density, sectorArray[2]), new RectTile(this.globe, this.level + 1, this.density, sectorArray[3])};
            return rectTileArray;
        }

        private void makeVerts(DrawContext drawContext) {
            int n = drawContext.getGlobe().getElevationModel().getTargetResolution(drawContext, this.sector, this.density);
            if (this.ri != null && this.ri.resolution >= n) {
                return;
            }
            CacheKey cacheKey = new CacheKey(this, n, drawContext.getVerticalExaggeration(), this.density);
            this.ri = (RenderInfo)WorldWind.memoryCache().getObject(cacheKey);
            if (this.ri != null) {
                return;
            }
            this.ri = this.buildVerts(drawContext, this.density, n, true);
            if (this.ri != null && this.ri.resolution >= 0) {
                this.byteSize = this.ri.getSizeInBytes();
                WorldWind.memoryCache().add(this.ri.resolution, this.ri, this.byteSize);
            }
        }

        private RenderInfo buildVerts(DrawContext drawContext, int n, int n2, boolean bl) {
            int n3 = (n + 3) * (n + 3);
            DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(n3 * 3);
            Globe globe = drawContext.getGlobe();
            ElevationModel.Elevations elevations = globe.getElevationModel().getElevations(this.sector, n2);
            double d = this.sector.getMinLatitude().radians;
            double d2 = this.sector.getMaxLatitude().radians;
            double d3 = (d2 - d) / (double)n;
            double d4 = this.sector.getMinLongitude().radians;
            double d5 = this.sector.getMaxLongitude().radians;
            double d6 = (d5 - d4) / (double)n;
            int n4 = 0;
            double d7 = d;
            double d8 = drawContext.getVerticalExaggeration();
            double d9 = bl ? globe.getMinElevation() * d8 : 0.0;
            double d10 = globe.getEquatorialRadius();
            double d11 = globe.getEccentricitySquared();
            LatLon latLon = this.sector.getCentroid();
            Point point = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0);
            for (int i = 0; i <= n + 2; ++i) {
                double d12 = Math.cos(d7);
                double d13 = Math.sin(d7);
                double d14 = d10 / Math.sqrt(1.0 - d11 * d13 * d13);
                double d15 = d4;
                for (int j = 0; j <= n + 2; ++j) {
                    double d16 = d8 * elevations.getElevation(d7, d15);
                    if (i == 0 || i >= n + 2 || j == 0 || j >= n + 2) {
                        d16 -= d9 >= 0.0 ? d9 : -d9;
                    }
                    double d17 = (d14 + d16) * d12 * Math.sin(d15) - point.getX();
                    double d18 = (d14 * (1.0 - d11) + d16) * d13 - point.getY();
                    double d19 = (d14 + d16) * d12 * Math.cos(d15) - point.getZ();
                    doubleBuffer.put(n4++, d17).put(n4++, d18).put(n4++, d19);
                    if (j > n) {
                        d15 = d5;
                        continue;
                    }
                    if (j == 0) continue;
                    d15 += d6;
                }
                if (i > n) {
                    d7 = d2;
                    continue;
                }
                if (i == 0) continue;
                d7 += d3;
            }
            return new RenderInfo(n, doubleBuffer, RectTile.getParameterization(n), point, elevations.getResolution());
        }

        public void renderMultiTexture(DrawContext drawContext, int n) {
            if (drawContext == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            if (n < 1) {
                String string = WorldWind.retrieveErrMsg("generic.NumTextureUnitsLessThanOne");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            this.render(drawContext, n);
        }

        public void render(DrawContext drawContext) {
            if (drawContext == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            this.render(drawContext, 1);
        }

        private long render(DrawContext drawContext, int n) {
            if (this.ri == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RenderInfoIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalStateException(string);
            }
            drawContext.getView().pushReferenceCenter(drawContext, this.ri.referenceCenter);
            GL gL = drawContext.getGL();
            gL.glPushClientAttrib(2);
            gL.glEnableClientState(32884);
            gL.glVertexPointer(3, 5130, 0, this.ri.vertices.rewind());
            for (int i = 0; i < n; ++i) {
                gL.glClientActiveTexture(33984 + i);
                gL.glEnableClientState(32888);
                gL.glTexCoordPointer(2, 5130, 0, this.ri.texCoords.rewind());
            }
            gL.glDrawElements(5, this.ri.indices.limit(), 5125, this.ri.indices.rewind());
            gL.glPopClientAttrib();
            drawContext.getView().popReferenceCenter(drawContext);
            return this.ri.indices.limit() - 2;
        }

        public void renderWireframe(DrawContext drawContext, boolean bl, boolean bl2) {
            if (drawContext == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            if (this.ri == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RenderInfoIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalStateException(string);
            }
            IntBuffer intBuffer = RectTile.getIndices(this.ri.density);
            intBuffer.rewind();
            drawContext.getView().pushReferenceCenter(drawContext, this.ri.referenceCenter);
            GL gL = drawContext.getGL();
            gL.glPushAttrib(270601);
            gL.glEnable(3042);
            gL.glBlendFunc(770, 1);
            gL.glDisable(2929);
            gL.glEnable(2884);
            gL.glCullFace(1029);
            gL.glDisable(3553);
            gL.glColor4d(1.0, 1.0, 1.0, 0.2);
            gL.glPolygonMode(1028, 6913);
            if (bl) {
                gL.glPushClientAttrib(2);
                gL.glEnableClientState(32884);
                gL.glVertexPointer(3, 5130, 0, this.ri.vertices);
                gL.glDrawElements(5, intBuffer.limit(), 5125, intBuffer);
                gL.glPopClientAttrib();
            }
            drawContext.getView().popReferenceCenter(drawContext);
            if (bl2) {
                this.renderPatchBoundary(drawContext, gL);
            }
            gL.glPopAttrib();
        }

        private void renderPatchBoundary(DrawContext drawContext, GL gL) {
            gL.glColor4d(1.0, 0.0, 0.0, 1.0);
            Point[] pointArray = this.sector.computeCornerPoints(drawContext.getGlobe());
            gL.glBegin(7);
            gL.glVertex3d(pointArray[0].x(), pointArray[0].y(), pointArray[0].z());
            gL.glVertex3d(pointArray[1].x(), pointArray[1].y(), pointArray[1].z());
            gL.glVertex3d(pointArray[2].x(), pointArray[2].y(), pointArray[2].z());
            gL.glVertex3d(pointArray[3].x(), pointArray[3].y(), pointArray[3].z());
            gL.glEnd();
        }

        public void renderBoundingVolume(DrawContext drawContext) {
            ((Cylinder)this.getExtent()).render(drawContext);
        }

        public void pick(DrawContext drawContext, java.awt.Point point) {
            if (this.ri == null) {
                return;
            }
            this.renderTrianglesWithUniqueColors(drawContext, this.ri);
            int n = this.pickSupport.getTopColor(drawContext, point);
            if (n < this.minColorCode || n > this.maxColorCode) {
                return;
            }
            double d = 1.0E-5f;
            int n2 = n - this.minColorCode - 1;
            if (null != this.ri.indices && n2 < this.ri.indices.capacity() - 2) {
                double d2 = this.ri.referenceCenter.getX();
                double d3 = this.ri.referenceCenter.getY();
                double d4 = this.ri.referenceCenter.getZ();
                int n3 = 3 * this.ri.indices.get(n2);
                Point point2 = new Point(this.ri.vertices.get(n3++) + d2, this.ri.vertices.get(n3++) + d3, this.ri.vertices.get(n3) + d4);
                n3 = 3 * this.ri.indices.get(n2 + 1);
                Point point3 = new Point(this.ri.vertices.get(n3++) + d2, this.ri.vertices.get(n3++) + d3, this.ri.vertices.get(n3) + d4);
                n3 = 3 * this.ri.indices.get(n2 + 2);
                Point point4 = new Point(this.ri.vertices.get(n3++) + d2, this.ri.vertices.get(n3++) + d3, this.ri.vertices.get(n3) + d4);
                Point point5 = point3.subtract(point2);
                Point point6 = point4.subtract(point2);
                Point point7 = point5.cross(point6);
                Line line = drawContext.getView().computeRayFromScreenPoint(point.getX(), point.getY());
                Point point8 = line.getOrigin().subtract(point2);
                double d5 = -point7.dot(point8);
                double d6 = point7.dot(line.getDirection());
                if (Math.abs(d6) < d) {
                    return;
                }
                double d7 = d5 / d6;
                Point point9 = line.getOrigin().add(line.getDirection().multiply(d7));
                Position position = drawContext.getGlobe().computePositionFromPoint(point9);
                double d8 = drawContext.getGlobe().getElevation(position.getLatitude(), position.getLongitude());
                Position position2 = new Position(position.getLatitude(), position.getLongitude(), d8);
                PickedObject pickedObject = new PickedObject(n, position2, position.getLatitude(), position.getLongitude(), d8, true);
                drawContext.addPickedObject(pickedObject);
            }
        }

        private void renderTrianglesWithUniqueColors(DrawContext drawContext, RenderInfo renderInfo) {
            if (drawContext == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalStateException(string);
            }
            if (renderInfo.vertices == null) {
                return;
            }
            renderInfo.vertices.rewind();
            renderInfo.indices.rewind();
            GL gL = drawContext.getGL();
            if (null != renderInfo.referenceCenter) {
                drawContext.getView().pushReferenceCenter(drawContext, renderInfo.referenceCenter);
            }
            this.minColorCode = drawContext.getUniquePickColor().getRGB();
            int n = renderInfo.indices.capacity() - 2;
            gL.glBegin(4);
            for (int i = 0; i < n; ++i) {
                Color color = drawContext.getUniquePickColor();
                gL.glColor3ub((byte)(color.getRed() & 0xFF), (byte)(color.getGreen() & 0xFF), (byte)(color.getBlue() & 0xFF));
                int n2 = 3 * renderInfo.indices.get(i);
                gL.glVertex3d(renderInfo.vertices.get(n2), renderInfo.vertices.get(n2 + 1), renderInfo.vertices.get(n2 + 2));
                n2 = 3 * renderInfo.indices.get(i + 1);
                gL.glVertex3d(renderInfo.vertices.get(n2), renderInfo.vertices.get(n2 + 1), renderInfo.vertices.get(n2 + 2));
                n2 = 3 * renderInfo.indices.get(i + 2);
                gL.glVertex3d(renderInfo.vertices.get(n2), renderInfo.vertices.get(n2 + 1), renderInfo.vertices.get(n2 + 2));
            }
            gL.glEnd();
            this.maxColorCode = drawContext.getUniquePickColor().getRGB();
            if (null != renderInfo.referenceCenter) {
                drawContext.getView().popReferenceCenter(drawContext);
            }
        }

        public Point getSurfacePoint(Angle angle, Angle angle2, double d) {
            if (angle == null || angle2 == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.LatLonIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            if (!this.sector.contains(angle, angle2)) {
                return null;
            }
            if (this.ri == null) {
                return null;
            }
            double d2 = angle.getDegrees();
            double d3 = angle2.getDegrees();
            double d4 = this.sector.getMinLatitude().getDegrees();
            double d5 = this.sector.getMaxLatitude().getDegrees();
            double d6 = this.sector.getMinLongitude().getDegrees();
            double d7 = this.sector.getMaxLongitude().getDegrees();
            double d8 = (d3 - d6) / (d7 - d6);
            double d9 = (d2 - d4) / (d5 - d4);
            int n = (int)(d9 * (double)this.density);
            int n2 = (int)(d8 * (double)this.density);
            double d10 = RectTile.createPosition(n2, d8, this.ri.density);
            double d11 = RectTile.createPosition(n, d9, this.ri.density);
            Point point = RectTile.interpolate(n, n2, d10, d11, this.ri);
            point = point.add(this.ri.referenceCenter);
            if (d != 0.0) {
                point = RectTile.applyOffset(this.globe, point, d);
            }
            return point;
        }

        private static Point applyOffset(Globe globe, Point point, double d) {
            Point point2 = globe.computeSurfaceNormalAtPoint(point);
            point = Point.fromOriginAndDirection(d, point2, point);
            return point;
        }

        private static double createPosition(int n, double d, int n2) {
            double d2 = (double)n / (double)n2;
            double d3 = (double)(n + 1) / (double)n2;
            return (d - d2) / (d3 - d2);
        }

        private static Point interpolate(int n, int n2, double d, double d2, RenderInfo renderInfo) {
            int n3 = renderInfo.density + 3;
            int n4 = ++n * n3 + ++n2;
            int n5 = n3 * 3;
            Point point = new Point(renderInfo.vertices.get(n4 *= 3), renderInfo.vertices.get(n4 + 1), renderInfo.vertices.get(n4 + 2));
            Point point2 = new Point(renderInfo.vertices.get(n4 + 3), renderInfo.vertices.get(n4 + 4), renderInfo.vertices.get(n4 + 5));
            Point point3 = new Point(renderInfo.vertices.get(n4 += n5), renderInfo.vertices.get(n4 + 1), renderInfo.vertices.get(n4 + 2));
            Point point4 = new Point(renderInfo.vertices.get(n4 + 3), renderInfo.vertices.get(n4 + 4), renderInfo.vertices.get(n4 + 5));
            return RectTile.interpolate(point, point2, point4, point3, d, d2);
        }

        private static Point interpolate(Point point, Point point2, Point point3, Point point4, double d, double d2) {
            double d3 = d + d2;
            if (d3 == 1.0) {
                return new Point(point4.x() * d2 + point2.x() * d, point4.y() * d2 + point2.y() * d, point4.z() * d2 + point2.z() * d);
            }
            if (d3 > 1.0) {
                Point point5 = point4.subtract(point3).multiply(1.0 - d);
                Point point6 = point2.subtract(point3).multiply(1.0 - d2);
                return point3.add(point5).add(point6);
            }
            Point point7 = point2.subtract(point).multiply(d);
            Point point8 = point4.subtract(point).multiply(d2);
            return point.add(point7).add(point8);
        }

        public String toString() {
            return "level " + this.level + ", density " + this.density + ", sector " + this.sector;
        }

        protected static DoubleBuffer getParameterization(int n) {
            int n2;
            int n3;
            DoubleBuffer doubleBuffer;
            if (n < 1) {
                n = 1;
            }
            if ((doubleBuffer = parameterizations.get(n)) != null) {
                return doubleBuffer;
            }
            int n4 = (n + 3) * (n + 3);
            doubleBuffer = BufferUtil.newDoubleBuffer(2 * n4);
            double d = 1.0 / (double)n;
            int n5 = 2 * (n + 3);
            for (int i = 0; i < n; ++i) {
                double d2 = (double)i * d;
                doubleBuffer.put(n5++, 0.0);
                doubleBuffer.put(n5++, d2);
                for (n3 = 0; n3 < n; ++n3) {
                    doubleBuffer.put(n5++, (double)n3 * d);
                    doubleBuffer.put(n5++, d2);
                }
                doubleBuffer.put(n5++, 0.999999);
                doubleBuffer.put(n5++, d2);
                doubleBuffer.put(n5++, 0.999999);
                doubleBuffer.put(n5++, d2);
            }
            double d3 = 0.999999;
            doubleBuffer.put(n5++, 0.0);
            doubleBuffer.put(n5++, d3);
            for (n2 = 0; n2 < n; ++n2) {
                doubleBuffer.put(n5++, (double)n2 * d);
                doubleBuffer.put(n5++, d3);
            }
            doubleBuffer.put(n5++, 0.999999);
            doubleBuffer.put(n5++, d3);
            doubleBuffer.put(n5++, 0.999999);
            doubleBuffer.put(n5++, d3);
            n2 = n5 - 2 * (n + 3);
            for (n3 = 0; n3 < n + 3; ++n3) {
                doubleBuffer.put(n5++, doubleBuffer.get(n2++));
                doubleBuffer.put(n5++, doubleBuffer.get(n2++));
            }
            n5 = 0;
            n2 = 2 * (n + 3);
            for (n3 = 0; n3 < n + 3; ++n3) {
                doubleBuffer.put(n5++, doubleBuffer.get(n2++));
                doubleBuffer.put(n5++, doubleBuffer.get(n2++));
            }
            parameterizations.put(n, doubleBuffer);
            return doubleBuffer;
        }

        private static IntBuffer getIndices(int n) {
            IntBuffer intBuffer;
            if (n < 1) {
                n = 1;
            }
            if ((intBuffer = indexLists.get(n)) != null) {
                return intBuffer;
            }
            int n2 = n + 2;
            int n3 = 2 * n2 * n2 + 4 * n2 - 2;
            intBuffer = BufferUtil.newIntBuffer(n3);
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                int n5;
                intBuffer.put(n4);
                if (i > 0) {
                    intBuffer.put(++n4);
                    intBuffer.put(n4);
                }
                if (i % 2 == 0) {
                    intBuffer.put(++n4);
                    for (n5 = 0; n5 < n2; ++n5) {
                        intBuffer.put(n4 += n2);
                        intBuffer.put(++n4);
                    }
                    continue;
                }
                intBuffer.put(--n4);
                for (n5 = 0; n5 < n2; ++n5) {
                    intBuffer.put(n4 -= n2);
                    intBuffer.put(--n4);
                }
            }
            indexLists.put(n, intBuffer);
            return intBuffer;
        }
    }

    private static class CacheKey {
        private final Sector sector;
        private int resolution;
        private final double verticalExaggeration;
        private int density;

        private CacheKey(RectTile rectTile, int n, double d, int n2) {
            this.sector = rectTile.sector;
            this.resolution = n;
            this.verticalExaggeration = d;
            this.density = n2;
        }

        public String toString() {
            return "density " + this.density + " ve " + this.verticalExaggeration + " resolution " + this.resolution + " sector " + this.sector;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.density != cacheKey.density) {
                return false;
            }
            if (this.resolution != cacheKey.resolution) {
                return false;
            }
            if (Double.compare(cacheKey.verticalExaggeration, this.verticalExaggeration) != 0) {
                return false;
            }
            return !(this.sector != null ? !this.sector.equals(cacheKey.sector) : cacheKey.sector != null);
        }

        public int hashCode() {
            int n = this.sector != null ? this.sector.hashCode() : 0;
            n = 31 * n + this.resolution;
            long l = this.verticalExaggeration != 0.0 ? Double.doubleToLongBits(this.verticalExaggeration) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            n = 31 * n + this.density;
            return n;
        }
    }

    private static class RenderInfo {
        private final int density;
        private final Point referenceCenter;
        private final DoubleBuffer vertices;
        private final DoubleBuffer texCoords;
        private final IntBuffer indices;
        private final int resolution;

        private RenderInfo(int n, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, Point point, int n2) {
            this.density = n;
            this.vertices = doubleBuffer;
            this.texCoords = doubleBuffer2;
            this.referenceCenter = point;
            this.indices = RectTile.getIndices(this.density);
            this.resolution = n2;
        }

        private long getSizeInBytes() {
            return 16 + (this.vertices.limit() + this.texCoords.limit()) * 64;
        }
    }
}

