/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Layer;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import java.awt.Point;
import java.util.logging.Level;

public abstract class AbstractLayer
extends WWObjectImpl
implements Layer {
    private boolean enabled = true;
    private boolean pickable = true;
    private double opacity = 1.0;
    private double minActiveAltitude = Double.MIN_VALUE;
    private double maxActiveAltitude = Double.MAX_VALUE;

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPickEnabled() {
        return this.pickable;
    }

    public void setPickEnabled(boolean bl) {
        this.pickable = bl;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String getName() {
        return this.myName();
    }

    public void setName(String string) {
        this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
    }

    public String toString() {
        return this.myName();
    }

    private String myName() {
        String string = null;
        Object object = this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        if (null != object) {
            string = object.toString();
        }
        if (null == string) {
            string = this.toString();
        }
        return string;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        this.opacity = d;
    }

    public double getMinActiveAltitude() {
        return this.minActiveAltitude;
    }

    public void setMinActiveAltitude(double d) {
        this.minActiveAltitude = d;
    }

    public double getMaxActiveAltitude() {
        return this.maxActiveAltitude;
    }

    public void setMaxActiveAltitude(double d) {
        this.maxActiveAltitude = d;
    }

    public boolean isLayerInView(DrawContext drawContext) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        return true;
    }

    public boolean isLayerActive(DrawContext drawContext) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getView()) {
            String string = WorldWind.retrieveErrMsg("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        double d = drawContext.getView().getAltitude();
        return d >= this.minActiveAltitude && d <= this.maxActiveAltitude;
    }

    public void render(DrawContext drawContext) {
        if (!this.enabled) {
            return;
        }
        if (null == drawContext) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getGlobe()) {
            String string = WorldWind.retrieveErrMsg("layers.AbstractLayer.NoGlobeSpecifiedInDrawingContext");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getView()) {
            String string = WorldWind.retrieveErrMsg("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (!this.isLayerActive(drawContext)) {
            return;
        }
        if (!this.isLayerInView(drawContext)) {
            return;
        }
        this.doRender(drawContext);
    }

    public void pick(DrawContext drawContext, Point point) {
        if (!this.enabled) {
            return;
        }
        if (null == drawContext) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getGlobe()) {
            String string = WorldWind.retrieveErrMsg("layers.AbstractLayer.NoGlobeSpecifiedInDrawingContext");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getView()) {
            String string = WorldWind.retrieveErrMsg("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (!this.isLayerActive(drawContext)) {
            return;
        }
        if (!this.isLayerInView(drawContext)) {
            return;
        }
        this.doPick(drawContext, point);
    }

    protected void doPick(DrawContext drawContext, Point point) {
    }

    public void dispose() {
    }

    protected abstract void doRender(DrawContext var1);
}

