/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.AVListImpl;
import gov.nasa.worldwind.LevelSet;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.TiledImageLayer;
import java.util.GregorianCalendar;

public class LandsatI3
extends TiledImageLayer {
    public LandsatI3() {
        super(LandsatI3.makeLevels());
        this.setUseTransparentTextures(true);
    }

    private static LevelSet makeLevels() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.Level.TileWidthKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.Level.TileHeightKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.Level.CacheNameKey", "Earth/NASA LandSat I3");
        aVListImpl.setValue("gov.nasa.worldwind.Level.ServiceURLKey", "http://worldwind25.arc.nasa.gov/lstile/lstile.aspx");
        aVListImpl.setValue("gov.nasa.worldwind.Level.DatasetNameKey", "esat_worlddds");
        aVListImpl.setValue("gov.nasa.worldwind.Level.FormatSuffixKey", ".dds");
        aVListImpl.setValue("gov.nasa.worldwind.Level.NumLevels", 10);
        aVListImpl.setValue("gov.nasa.worldwind.Level.NumEmptyLevels", 4);
        aVListImpl.setValue("gov.nasa.worldwind.Level.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(36.0), Angle.fromDegrees(36.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        aVListImpl.setValue("gov.nasa.worldwind.Level.ExpiryTime", new GregorianCalendar(2007, 2, 22).getTimeInMillis());
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return WorldWind.retrieveErrMsg("layers.Earth.LandsatI3Layer.Name");
    }
}

