/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.AVListImpl;
import gov.nasa.worldwind.LevelSet;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.TiledImageLayer;

public class USGSUrbanAreaOrtho
extends TiledImageLayer {
    public USGSUrbanAreaOrtho() {
        super(USGSUrbanAreaOrtho.makeLevels());
        this.setMaxActiveAltitude(35000.0);
    }

    private static LevelSet makeLevels() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.Level.TileWidthKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.Level.TileHeightKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.Level.CacheNameKey", "Earth/USGS Urban Area Ortho");
        aVListImpl.setValue("gov.nasa.worldwind.Level.ServiceURLKey", "http://worldwind25.arc.nasa.gov/tile/tile.aspx");
        aVListImpl.setValue("gov.nasa.worldwind.Level.DatasetNameKey", "104dds");
        aVListImpl.setValue("gov.nasa.worldwind.Level.FormatSuffixKey", ".dds");
        aVListImpl.setValue("gov.nasa.worldwind.Level.NumLevels", 12);
        aVListImpl.setValue("gov.nasa.worldwind.Level.NumEmptyLevels", 2);
        Angle angle = Angle.fromDegrees(3.2);
        aVListImpl.setValue("gov.nasa.worldwind.Level.LevelZeroTileDelta", new LatLon(angle, angle));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", new Sector(Angle.fromDegrees(17.84), Angle.fromDegrees(71.55), Angle.fromDegrees(-168.67), Angle.fromDegrees(-65.15)));
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return WorldWind.retrieveErrMsg("layers.Earth.USGSUrbanAreaOrtho.Name");
    }
}

