/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.IconRenderer;
import gov.nasa.worldwind.Pedestal;
import gov.nasa.worldwind.WWIcon;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.layers.AbstractLayer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconLayer
extends AbstractLayer {
    private final Collection<WWIcon> icons = new ArrayList<WWIcon>();
    private Iterator<WWIcon> iconIterator;
    private IconRenderer iconRenderer = new IconRenderer();
    private Pedestal pedestal;

    public void setIcons(Iterator<WWIcon> iterator) {
        this.iconIterator = iterator;
    }

    public void addIcon(WWIcon wWIcon) {
        if (wWIcon == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.Icon");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.icons.add(wWIcon);
    }

    public void removeIcon(WWIcon wWIcon) {
        if (wWIcon == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.Icon");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.icons.remove(wWIcon);
    }

    public Collection<WWIcon> getIcons() {
        return this.icons;
    }

    @Override
    public void dispose() {
        this.iconRenderer.dispose();
    }

    public Pedestal getPedestal() {
        return this.pedestal;
    }

    public void setPedestal(Pedestal pedestal) {
        this.pedestal = pedestal;
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        if (this.iconIterator == null) {
            this.iconIterator = this.icons.iterator();
        }
        this.iconRenderer.setPedestal(this.pedestal);
        this.iconRenderer.pick(drawContext, this.iconIterator, point, this);
        this.iconIterator = null;
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        if (this.iconIterator == null) {
            this.iconIterator = this.icons.iterator();
        }
        this.iconRenderer.setPedestal(this.pedestal);
        this.iconRenderer.render(drawContext, this.iconIterator);
        this.iconIterator = null;
    }

    @Override
    public String toString() {
        return WorldWind.retrieveErrMsg("layers.IconLayer.Name");
    }
}

