/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.BasicMemoryCache;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Globe;
import gov.nasa.worldwind.IconRenderer;
import gov.nasa.worldwind.MemoryCache;
import gov.nasa.worldwind.Retriever;
import gov.nasa.worldwind.SurfaceTileRenderer;
import gov.nasa.worldwind.WWIO;
import gov.nasa.worldwind.WWIcon;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WWRuntimeException;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.formats.rpf.RpfDataSeries;
import gov.nasa.worldwind.formats.rpf.RpfFrameFileIndexSection;
import gov.nasa.worldwind.formats.rpf.RpfFrameFilenameUtil;
import gov.nasa.worldwind.formats.rpf.RpfFrameProperties;
import gov.nasa.worldwind.formats.rpf.RpfImageFile;
import gov.nasa.worldwind.formats.rpf.RpfTocFile;
import gov.nasa.worldwind.formats.rpf.RpfZone;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.TextureTile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpfLayer
extends AbstractLayer {
    public static final Angle DefaultDeltaLat = Angle.fromDegrees(0.05);
    public static final Angle DefaultDeltaLon = Angle.fromDegrees(0.075);
    private final RpfDataSeries dataSeries;
    private final MemoryCache memoryCache;
    private Angle deltaLat;
    private Angle deltaLon;
    private static final String RPF_OVERVIEW_EXTENSION = ".OVR";
    private final Map<FrameKey, FrameRecord> frameDirectory = new HashMap<FrameKey, FrameRecord>();
    private Sector sector = Sector.EMPTY_SECTOR;
    private int modCount = 0;
    private int lastModCount = 0;
    private final Queue<TextureTile> assemblyQueue = new LinkedList<TextureTile>();
    private final Queue<FrameRecord> assemblyRequestQueue = new LinkedList<FrameRecord>();
    private static final BlockingQueue<Disposable> disposalQueue = new LinkedBlockingQueue<Disposable>();
    private final SurfaceTileRenderer tileRenderer = new SurfaceTileRenderer();
    private final IconRenderer iconRenderer = new IconRenderer();
    private TextureTile coverageTile;
    private WWIcon coverageIcon;
    private int tileGridDrawThreshold = 30;
    private boolean drawCoverage = true;
    private boolean drawCoverageIcon = true;
    private final LinkedList<FrameRecord> downloadQueue = new LinkedList();
    private final LinkedList<FrameRecord> readQueue = new LinkedList();

    public RpfLayer(RpfDataSeries rpfDataSeries) {
        this(rpfDataSeries, DefaultDeltaLat, DefaultDeltaLon);
    }

    public RpfLayer(RpfDataSeries rpfDataSeries, Angle angle, Angle angle2) {
        this(rpfDataSeries, angle, angle2, null);
    }

    public RpfLayer(RpfDataSeries rpfDataSeries, Angle angle, Angle angle2, MemoryCache memoryCache) {
        if (rpfDataSeries == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RpfDataSeriesIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.dataSeries = rpfDataSeries;
        this.deltaLat = angle;
        this.deltaLon = angle2;
        if (memoryCache != null) {
            this.memoryCache = memoryCache;
        } else {
            this.memoryCache = new BasicMemoryCache();
            this.memoryCache.addCacheListener(new MemoryCache.CacheListener(){

                public void entryRemoved(Object object, Object object2) {
                    if (object2 == null || !(object2 instanceof TextureTile)) {
                        return;
                    }
                    TextureTile textureTile = (TextureTile)object2;
                    disposalQueue.offer(textureTile);
                }
            });
        }
        this.updateMemoryCache();
    }

    public static long estimateMemoryCacheCapacity(RpfDataSeries rpfDataSeries, Angle angle, Angle angle2) {
        RpfZone.ZoneValues zoneValues = RpfZone.Zone1.zoneValues(rpfDataSeries);
        long l = (long)Math.ceil(angle.divide(zoneValues.latitudinalFrameExtent));
        long l2 = (long)Math.ceil(angle2.divide(zoneValues.longitudinalFrameExtent));
        long l3 = l * l2 * 4L * 1024L * 1024L;
        return 32L * (long)Math.ceil((double)l3 / 32.0);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dataSeries.seriesCode);
        stringBuilder.append(": ");
        stringBuilder.append(this.dataSeries.dataSeries);
        return stringBuilder.toString();
    }

    public Angle getViewingDeltaLat() {
        return this.deltaLat;
    }

    public Angle getViewingDeltaLon() {
        return this.deltaLon;
    }

    public void setViewingDeltaLat(Angle angle) {
        this.deltaLat = angle;
        this.updateMemoryCache();
    }

    public void setViewingDeltaLon(Angle angle) {
        this.deltaLon = angle;
        this.updateMemoryCache();
    }

    private void updateMemoryCache() {
        long l = RpfLayer.estimateMemoryCacheCapacity(this.dataSeries, this.deltaLat, this.deltaLon);
        if (this.memoryCache.getCapacity() < l) {
            this.memoryCache.setCapacity(l);
        }
    }

    public int addAll(Collection<RpfTocFile> collection) {
        if (collection == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.CollectionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        int n = this.modCount;
        for (RpfTocFile rpfTocFile : collection) {
            if (rpfTocFile == null) continue;
            this.addContents(rpfTocFile);
        }
        return this.modCount - n;
    }

    public int addContents(RpfTocFile rpfTocFile) {
        if (rpfTocFile == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RpfTocFileIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        RpfFrameFileIndexSection rpfFrameFileIndexSection = rpfTocFile.getFrameFileIndexSection();
        if (rpfFrameFileIndexSection == null) {
            return 0;
        }
        ArrayList<RpfFrameFileIndexSection.RpfFrameFileIndexRecord> arrayList = rpfFrameFileIndexSection.getFrameFileIndexTable();
        if (arrayList == null) {
            return 0;
        }
        int n = this.modCount;
        for (RpfFrameFileIndexSection.RpfFrameFileIndexRecord rpfFrameFileIndexRecord : arrayList) {
            if (rpfFrameFileIndexRecord.getFrameFileName().toUpperCase().endsWith(RPF_OVERVIEW_EXTENSION)) continue;
            FrameRecord frameRecord = null;
            try {
                frameRecord = RpfLayer.createRecord(rpfTocFile, rpfFrameFileIndexRecord);
            }
            catch (Exception exception) {
                String string = WorldWind.retrieveErrMsg("layers.RpfLayer.ExceptionParsingFileName") + rpfFrameFileIndexRecord.getFrameFileName();
                WorldWind.logger().log(Level.FINE, string, exception);
            }
            if (frameRecord == null || this.dataSeries != frameRecord.properties.dataSeries) continue;
            this.addRecord(frameRecord);
        }
        return this.modCount - n;
    }

    private void addRecord(FrameRecord frameRecord) {
        FrameKey frameKey = RpfLayer.keyFor(frameRecord);
        this.frameDirectory.put(frameKey, frameRecord);
        ++this.modCount;
    }

    private static String cachePathFor(RpfFrameProperties rpfFrameProperties) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Earth").append(File.separatorChar);
        stringBuilder.append("RPF").append(File.separatorChar);
        stringBuilder.append(rpfFrameProperties.dataSeries.seriesCode).append(File.separatorChar);
        stringBuilder.append(rpfFrameProperties.zone.zoneCode).append(File.separatorChar);
        stringBuilder.append(RpfFrameFilenameUtil.filenameFor(rpfFrameProperties));
        return stringBuilder.toString();
    }

    private static String createAbsolutePath(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null || string.length() <= 0) continue;
            int n = 0;
            if (string.startsWith("./") || string.startsWith(".\\")) {
                n = 1;
            } else if (!string.startsWith("/") && !string.startsWith("\\")) {
                stringBuilder.append(File.separatorChar);
            }
            int n2 = string.endsWith("/") || string.endsWith("\\") ? string.length() - 1 : string.length();
            stringBuilder.append(string, n, n2);
        }
        if (stringBuilder.length() <= 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    private static FrameRecord createRecord(RpfTocFile rpfTocFile, RpfFrameFileIndexSection.RpfFrameFileIndexRecord rpfFrameFileIndexRecord) {
        RpfFrameProperties rpfFrameProperties = RpfFrameFilenameUtil.parseFilename(rpfFrameFileIndexRecord.getFrameFileName());
        Sector sector = RpfLayer.sectorFor(rpfFrameProperties);
        String string = RpfLayer.createAbsolutePath(rpfTocFile.getFile().getParentFile().getAbsolutePath(), rpfFrameFileIndexRecord.getPathname(), rpfFrameFileIndexRecord.getFrameFileName());
        String string2 = RpfLayer.cachePathFor(rpfFrameProperties);
        if (rpfFrameProperties == null || sector == null || string == null || string2 == null) {
            String string3 = WorldWind.retrieveErrMsg("layers.RpfLayer.BadFrameInput") + rpfFrameFileIndexRecord.getFrameFileName();
            WorldWind.logger().log(Level.FINE, string3);
            throw new WWRuntimeException(string3);
        }
        return new FrameRecord(rpfFrameProperties, sector, string, string2);
    }

    private static FrameKey keyFor(FrameRecord frameRecord) {
        return new FrameKey(frameRecord.properties.zone, frameRecord.properties.frameNumber);
    }

    public int removeAll(Collection<RpfTocFile> collection) {
        if (collection == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.CollectionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        int n = this.modCount;
        for (RpfTocFile rpfTocFile : collection) {
            if (rpfTocFile == null) continue;
            this.removeContents(rpfTocFile);
        }
        return n - this.modCount;
    }

    public int removeContents(RpfTocFile rpfTocFile) {
        if (rpfTocFile == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RpfTocFileIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        RpfFrameFileIndexSection rpfFrameFileIndexSection = rpfTocFile.getFrameFileIndexSection();
        if (rpfFrameFileIndexSection == null) {
            return 0;
        }
        ArrayList<RpfFrameFileIndexSection.RpfFrameFileIndexRecord> arrayList = rpfFrameFileIndexSection.getFrameFileIndexTable();
        if (arrayList == null) {
            return 0;
        }
        int n = this.modCount;
        for (RpfFrameFileIndexSection.RpfFrameFileIndexRecord rpfFrameFileIndexRecord : arrayList) {
            if (rpfFrameFileIndexRecord.getFrameFileName().toUpperCase().endsWith(RPF_OVERVIEW_EXTENSION)) continue;
            RpfFrameProperties rpfFrameProperties = null;
            try {
                rpfFrameProperties = RpfFrameFilenameUtil.parseFilename(rpfFrameFileIndexRecord.getFrameFileName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = WorldWind.retrieveErrMsg("layers.RpfLayer.ExceptionParsingFileName") + rpfFrameFileIndexRecord.getFrameFileName();
                WorldWind.logger().log(Level.FINE, string, illegalArgumentException);
            }
            if (rpfFrameProperties == null || this.dataSeries != rpfFrameProperties.dataSeries) continue;
            this.removeKey(new FrameKey(rpfFrameProperties.zone, rpfFrameProperties.frameNumber));
        }
        return n - this.modCount;
    }

    private boolean removeKey(FrameKey frameKey) {
        FrameRecord frameRecord = this.frameDirectory.remove(frameKey);
        --this.modCount;
        return frameRecord != null;
    }

    private static Sector sectorFor(RpfFrameProperties rpfFrameProperties) {
        if (rpfFrameProperties == null || rpfFrameProperties.zone == null || rpfFrameProperties.dataSeries == null) {
            return null;
        }
        RpfZone.ZoneValues zoneValues = rpfFrameProperties.zone.zoneValues(rpfFrameProperties.dataSeries);
        if (rpfFrameProperties.frameNumber < 0 || rpfFrameProperties.frameNumber > zoneValues.maximumFrameNumber - 1) {
            return null;
        }
        return zoneValues.frameExtent(rpfFrameProperties.frameNumber);
    }

    private void updateSector() {
        Sector sector = null;
        for (FrameRecord frameRecord : this.frameDirectory.values()) {
            if (frameRecord.sector == null) continue;
            sector = sector != null ? sector.union(frameRecord.sector) : frameRecord.sector;
        }
        this.sector = sector;
    }

    private void assembleFrameTiles(DrawContext drawContext, RpfDataSeries rpfDataSeries, Sector sector, Queue<TextureTile> queue, Queue<FrameRecord> queue2) {
        for (RpfZone rpfZone : RpfZone.values()) {
            RpfZone.ZoneValues zoneValues = rpfZone.zoneValues(rpfDataSeries);
            Sector sector2 = zoneValues.extent.intersection(sector);
            if (sector2 == null || !this.isSectorVisible(drawContext, sector2)) continue;
            this.assembleZoneTiles(drawContext, zoneValues, sector2, queue, queue2);
        }
    }

    private void assembleZoneTiles(DrawContext drawContext, RpfZone.ZoneValues zoneValues, Sector sector, Queue<TextureTile> queue, Queue<FrameRecord> queue2) {
        int n = zoneValues.frameRowFromLatitude(sector.getMinLatitude());
        int n2 = zoneValues.frameRowFromLatitude(sector.getMaxLatitude());
        int n3 = zoneValues.frameColumnFromLongitude(sector.getMinLongitude());
        int n4 = zoneValues.frameColumnFromLongitude(sector.getMaxLongitude());
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                int n5 = zoneValues.frameNumber(i, j);
                this.getOrRequestTile(drawContext, new FrameKey(zoneValues.zone, n5), queue, queue2);
            }
        }
    }

    private void getOrRequestTile(DrawContext drawContext, FrameKey frameKey, Queue<TextureTile> queue, Queue<FrameRecord> queue2) {
        TextureTile textureTile = this.getTile(frameKey);
        if (textureTile != null) {
            if (this.isSectorVisible(drawContext, textureTile.getSector())) {
                queue.offer(textureTile);
            }
        } else {
            FrameRecord frameRecord = this.frameDirectory.get(frameKey);
            if (frameRecord != null && this.isSectorVisible(drawContext, frameRecord.sector)) {
                queue2.offer(frameRecord);
            }
        }
    }

    private static Sector[] normalizeSector(Sector sector) {
        Angle angle;
        Angle angle2 = RpfLayer.clampAngle(sector.getMinLatitude(), Angle.NEG90, Angle.POS90);
        Angle angle3 = RpfLayer.clampAngle(sector.getMaxLatitude(), Angle.NEG90, Angle.POS90);
        if (angle3.degrees < angle2.degrees) {
            angle = angle2;
            angle2 = angle3;
            angle3 = angle;
        }
        angle = RpfLayer.normalizeAngle(sector.getMinLongitude(), Angle.NEG180, Angle.POS180);
        Angle angle4 = RpfLayer.normalizeAngle(sector.getMaxLongitude(), Angle.NEG180, Angle.POS180);
        if (angle4.degrees < angle.degrees) {
            return new Sector[]{new Sector(angle2, angle3, angle, Angle.POS180), new Sector(angle2, angle3, Angle.NEG180, angle4)};
        }
        return new Sector[]{new Sector(angle2, angle3, angle, angle4)};
    }

    private static Sector createViewSector(Angle angle, Angle angle2, Angle angle3, Angle angle4) {
        return new Sector(angle.subtract(angle3), angle.add(angle3), angle2.subtract(angle4), angle2.add(angle4));
    }

    private static Angle clampAngle(Angle angle, Angle angle2, Angle angle3) {
        return angle.degrees < angle2.degrees ? angle2 : (angle.degrees > angle3.degrees ? angle3 : angle);
    }

    private static Angle normalizeAngle(Angle angle, Angle angle2, Angle angle3) {
        Angle angle4 = angle3.subtract(angle2);
        return angle.degrees < angle2.degrees ? angle.add(angle4) : (angle.degrees > angle3.degrees ? angle.subtract(angle4) : angle);
    }

    private static TextureData createCoverageTextureData(Sector sector, Collection<FrameRecord> collection, int n, int n2, int n3, int n4) {
        IntBuffer intBuffer = BufferUtil.newIntBuffer(n * n2);
        for (int i = 0; i < n * n2; ++i) {
            intBuffer.put(i, n4);
        }
        intBuffer.rewind();
        Angle angle = sector.getMaxLatitude().subtract(sector.getMinLatitude());
        Angle angle2 = sector.getMaxLongitude().subtract(sector.getMinLongitude());
        for (FrameRecord frameRecord : collection) {
            int n5 = (int)Math.round((double)(n - 1) * frameRecord.sector.getMinLongitude().subtract(sector.getMinLongitude()).divide(angle2));
            int n6 = (int)Math.round((double)(n2 - 1) * frameRecord.sector.getMinLatitude().subtract(sector.getMinLatitude()).divide(angle));
            int n7 = (int)Math.round((double)(n - 1) * frameRecord.sector.getMaxLongitude().subtract(sector.getMinLongitude()).divide(angle2));
            int n8 = (int)Math.round((double)(n - 1) * frameRecord.sector.getMaxLatitude().subtract(sector.getMinLatitude()).divide(angle));
            for (int i = n6; i <= n8; ++i) {
                for (int j = n5; j <= n7; ++j) {
                    intBuffer.put(j + i * n, n3);
                }
            }
        }
        intBuffer.rewind();
        return new TextureData(6408, n, n2, 0, 6408, 32821, false, false, false, intBuffer, null);
    }

    @Override
    public void dispose() {
        if (this.tileRenderer != null) {
            disposalQueue.offer(this.tileRenderer);
        }
        if (this.iconRenderer != null) {
            disposalQueue.offer(this.iconRenderer);
        }
        if (this.coverageTile != null) {
            disposalQueue.offer(this.coverageTile);
        }
        this.coverageTile = null;
        RpfLayer.processDisposables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRender(DrawContext drawContext) {
        boolean bl;
        RpfLayer.processDisposables();
        if (!this.isSectorVisible(drawContext, this.sector)) {
            return;
        }
        if (this.modCount != this.lastModCount) {
            this.updateSector();
            this.updateCoverage();
            this.lastModCount = this.modCount;
        }
        GL gL = drawContext.getGL();
        if (this.drawCoverage && this.coverageTile != null) {
            int n = 24584;
            gL.glPushAttrib(n);
            try {
                gL.glEnable(3042);
                gL.glEnable(2884);
                gL.glBlendFunc(770, 771);
                gL.glCullFace(1029);
                gL.glPolygonMode(1028, 6914);
                this.tileRenderer.renderTile(drawContext, this.coverageTile);
            }
            finally {
                gL.glPopAttrib();
            }
        }
        this.assemblyQueue.clear();
        this.assemblyRequestQueue.clear();
        Position position = drawContext.getView().getPosition();
        Sector sector = RpfLayer.createViewSector(position.getLatitude(), position.getLongitude(), this.deltaLat, this.deltaLon);
        for (Sector sector2 : RpfLayer.normalizeSector(sector)) {
            this.assembleFrameTiles(drawContext, this.dataSeries, sector2, this.assemblyQueue, this.assemblyRequestQueue);
        }
        Object object = null;
        for (TextureTile textureTile : this.assemblyQueue) {
            object = object != null ? ((Sector)object).union(textureTile.getSector()) : textureTile.getSector();
        }
        boolean bl2 = bl = this.tileGridDrawThreshold <= RpfLayer.pixelSizeOfSector(drawContext, sector) || object != null && this.tileGridDrawThreshold <= RpfLayer.pixelSizeOfSector(drawContext, (Sector)object);
        if (bl) {
            this.requestAllFrames(this.readQueue, this.assemblyRequestQueue);
            int n = 8200;
            gL.glPushAttrib(n);
            try {
                gL.glEnable(2884);
                gL.glCullFace(1029);
                gL.glPolygonMode(1028, 6914);
                this.tileRenderer.renderTiles(drawContext, this.assemblyQueue);
            }
            finally {
                gL.glPopAttrib();
            }
        } else if (this.drawCoverageIcon && this.coverageIcon != null) {
            LatLon latLon = object != null ? ((Sector)object).getCentroid() : this.sector.getCentroid();
            this.coverageIcon.setPosition(new Position(latLon.getLatitude(), latLon.getLongitude(), 0.0));
            this.iconRenderer.render(drawContext, this.coverageIcon, null);
        }
        this.sendRequests(this.assemblyRequestQueue.size());
    }

    public WWIcon getCoverageIcon() {
        return this.coverageIcon;
    }

    public int getTileGridDrawThreshold() {
        return this.tileGridDrawThreshold;
    }

    private static void initializeFrameTexture(Texture texture) {
        texture.setTexParameteri(10241, 9729);
        texture.setTexParameteri(10240, 9729);
        texture.setTexParameteri(10242, 33071);
        texture.setTexParameteri(10243, 33071);
    }

    private static void initializeOtherTexture(Texture texture) {
        texture.setTexParameteri(10241, 9728);
        texture.setTexParameteri(10240, 9728);
        texture.setTexParameteri(10242, 33071);
        texture.setTexParameteri(10243, 33071);
    }

    public boolean isDrawCoverage() {
        return this.drawCoverage;
    }

    public boolean isDrawCoverageIcon() {
        return this.drawCoverageIcon;
    }

    private boolean isSectorVisible(DrawContext drawContext, Sector sector) {
        if (drawContext.getVisibleSector() != null && !sector.intersects(drawContext.getVisibleSector())) {
            return false;
        }
        Cylinder cylinder = Sector.computeBoundingCylinder(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), sector);
        return cylinder.intersects(drawContext.getView().getFrustumInModelCoordinates());
    }

    private static int pixelSizeOfSector(DrawContext drawContext, Sector sector) {
        LatLon latLon = sector.getCentroid();
        Globe globe = drawContext.getGlobe();
        Point point = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0);
        Point point2 = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), 0.0);
        Point point3 = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), 0.0);
        double d = point.distanceTo(drawContext.getView().getEyePoint());
        double d2 = point2.distanceTo(point3);
        double d3 = drawContext.getView().computePixelSizeAtDistance(d);
        return (int)Math.round(d2 / d3);
    }

    private static void processDisposables() {
        Disposable disposable;
        while ((disposable = (Disposable)disposalQueue.poll()) != null) {
            disposable.dispose();
        }
    }

    private static int rgbaInt(int n, int n2, int n3, int n4) {
        n = (int)((double)n * ((double)n4 / 255.0));
        n2 = (int)((double)n2 * ((double)n4 / 255.0));
        n3 = (int)((double)n3 * ((double)n4 / 255.0));
        return ((0xFF & n) << 24) + ((0xFF & n2) << 16) + ((0xFF & n3) << 8) + (0xFF & n4);
    }

    public void setCoverageIcon(WWIcon wWIcon) {
        if (wWIcon == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.Icon");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.coverageIcon = wWIcon;
    }

    public void setDrawCoverage(boolean bl) {
        this.drawCoverage = bl;
    }

    public void setDrawCoverageIcon(boolean bl) {
        this.drawCoverageIcon = bl;
    }

    public void setTileGridDrawThreshold(int n) {
        if (n <= 0) {
            String string = WorldWind.retrieveErrMsg("generic.ValueOutOfRange") + String.valueOf(n);
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.tileGridDrawThreshold = n;
    }

    private void updateCoverage() {
        if (this.coverageTile != null) {
            disposalQueue.offer(this.coverageTile);
        }
        TextureData textureData = RpfLayer.createCoverageTextureData(this.sector, this.frameDirectory.values(), 1024, 1024, RpfLayer.rgbaInt(255, 0, 0, 102), RpfLayer.rgbaInt(0, 0, 0, 0));
        this.coverageTile = new TextureTile(this.sector){

            public void initializeTexture(DrawContext drawContext) {
                if (this.getTexture() == null) {
                    Texture texture = TextureIO.newTexture(this.getTextureData());
                    RpfLayer.initializeOtherTexture(texture);
                    this.setTexture(texture);
                }
            }
        };
        this.coverageTile.setTextureData(textureData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextureTile getTile(FrameKey frameKey) {
        MemoryCache memoryCache = this.memoryCache;
        synchronized (memoryCache) {
            Object object = this.memoryCache.getObject(frameKey);
            if (object != null && object instanceof TextureTile) {
                return (TextureTile)object;
            }
            return null;
        }
    }

    private static boolean isFileResident(String string) {
        return WorldWind.dataFileCache().findFile(string, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTileResident(FrameKey frameKey) {
        MemoryCache memoryCache = this.memoryCache;
        synchronized (memoryCache) {
            return this.memoryCache.getObject(frameKey) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeTileResident(FrameKey frameKey, TextureTile textureTile) {
        MemoryCache memoryCache = this.memoryCache;
        synchronized (memoryCache) {
            this.memoryCache.add(frameKey, textureTile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFrame(LinkedList<FrameRecord> linkedList, FrameRecord frameRecord) {
        LinkedList<FrameRecord> linkedList2 = linkedList;
        synchronized (linkedList2) {
            if (linkedList.contains(frameRecord)) {
                return;
            }
            linkedList.addFirst(frameRecord);
        }
    }

    private void requestAllFrames(LinkedList<FrameRecord> linkedList, Collection<FrameRecord> collection) {
        for (FrameRecord frameRecord : collection) {
            this.requestFrame(linkedList, frameRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequests(int n) {
        FrameRecord frameRecord;
        LinkedList<FrameRecord> linkedList = this.readQueue;
        synchronized (linkedList) {
            while (this.readQueue.size() > n) {
                this.readQueue.removeLast();
            }
            while (!WorldWind.threadedTaskService().isFull() && (frameRecord = this.readQueue.poll()) != null) {
                WorldWind.threadedTaskService().addTask(new ReadTask(this, frameRecord));
            }
        }
        linkedList = this.downloadQueue;
        synchronized (linkedList) {
            while (this.downloadQueue.size() > n) {
                this.downloadQueue.removeLast();
            }
            while (!WorldWind.retrievalService().isFull() && (frameRecord = this.downloadQueue.poll()) != null) {
                WorldWind.retrievalService().runRetriever(new RpfRetriever(this, frameRecord));
            }
        }
    }

    private static class ReadTask
    implements Runnable {
        public final RpfLayer layer;
        public final FrameRecord record;

        public ReadTask(RpfLayer rpfLayer, FrameRecord frameRecord) {
            this.layer = rpfLayer;
            this.record = frameRecord;
        }

        private void deleteCorruptFrame(RpfLayer rpfLayer, FrameRecord frameRecord) {
            URL uRL = WorldWind.dataFileCache().findFile(frameRecord.cacheFilePath, false);
            if (uRL != null) {
                WorldWind.dataFileCache().removeFile(uRL);
            }
            frameRecord.setCorruptCache(false);
            rpfLayer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, rpfLayer);
            String string = WorldWind.retrieveErrMsg("generic.DeletedCorruptDataFile") + (uRL != null ? uRL.getFile() : "null");
            WorldWind.logger().log(Level.FINE, string);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            ReadTask readTask = (ReadTask)object;
            return this.record != null ? this.record.equals(readTask.record) : readTask.record == null;
        }

        public void run() {
            FrameKey frameKey = RpfLayer.keyFor(this.record);
            if (!this.layer.isTileResident(frameKey)) {
                this.readFrame(frameKey, this.record);
                this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this.layer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(FrameKey frameKey, FrameRecord frameRecord) {
            URL uRL = WorldWind.dataFileCache().findFile(frameRecord.cacheFilePath, false);
            if (uRL == null) {
                this.layer.requestFrame(this.layer.downloadQueue, this.record);
                return;
            }
            if (!frameRecord.fileLock.tryLock()) {
                return;
            }
            try {
                if (this.layer.isTileResident(frameKey)) {
                    return;
                }
                TextureData textureData = null;
                try {
                    textureData = TextureIO.newTextureData(uRL, false, "dds");
                }
                catch (IOException iOException) {
                    String string = WorldWind.retrieveErrMsg("generic.TextureIOException") + frameRecord.cacheFilePath;
                    WorldWind.logger().log(Level.FINE, string, iOException);
                }
                if (textureData == null) {
                    this.deleteCorruptFrame(this.layer, this.record);
                    return;
                }
                TextureTile textureTile = new TextureTile(frameRecord.sector){

                    public void initializeTexture(DrawContext drawContext) {
                        if (this.getTexture() == null) {
                            Texture texture = TextureIO.newTexture(this.getTextureData());
                            RpfLayer.initializeFrameTexture(texture);
                            this.setTexture(texture);
                        }
                    }
                };
                textureTile.setTextureData(textureData);
                this.layer.makeTileResident(frameKey, textureTile);
            }
            finally {
                frameRecord.fileLock.unlock();
            }
        }
    }

    private static class RpfRetriever
    extends WWObjectImpl
    implements Retriever {
        private final RpfLayer layer;
        private final FrameRecord record;
        private volatile RpfImageFile rpfImageFile;
        private volatile ByteBuffer buffer;
        private volatile String state = "gov.nasa.worldwind.RetrieverStatusNotStarted";
        private long submitTime;
        private long beginTime;
        private long endTime;

        public RpfRetriever(RpfLayer rpfLayer, FrameRecord frameRecord) {
            this.layer = rpfLayer;
            this.record = frameRecord;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            RpfRetriever rpfRetriever = (RpfRetriever)object;
            return this.record.equals(rpfRetriever.record);
        }

        public long getBeginTime() {
            return this.beginTime;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public int getContentLength() {
            return 0;
        }

        public int getContentLengthRead() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public String getName() {
            return this.record.filePath;
        }

        public String getState() {
            return this.state;
        }

        public long getSubmitTime() {
            return this.submitTime;
        }

        private boolean interrupted() {
            if (Thread.currentThread().isInterrupted()) {
                this.setState("gov.nasa.worldwind.RetrieverStatusInterrupted");
                String string = WorldWind.retrieveErrMsg("layers.RpfLayer.DownloadInterrupted") + this.record.filePath;
                WorldWind.logger().log(Level.FINER, string);
                return true;
            }
            return false;
        }

        public void setBeginTime(long l) {
            this.beginTime = l;
        }

        public void setEndTime(long l) {
            this.endTime = l;
        }

        private void setState(String string) {
            String string2 = this.state;
            this.state = string;
            this.firePropertyChange("gov.nasa.worldwind.avkey.RetrieverState", string2, this.state);
        }

        public void setSubmitTime(long l) {
            this.submitTime = l;
        }

        public Retriever call() throws Exception {
            if (this.interrupted()) {
                return this;
            }
            if (!this.record.fileLock.tryLock()) {
                this.setState("gov.nasa.worldwind.RetrieverStatusSuccessful");
                return this;
            }
            try {
                File file;
                this.setState("gov.nasa.worldwind.RetrieverStatusStarted");
                if (!this.interrupted() && RpfLayer.isFileResident(this.record.cacheFilePath)) {
                    this.setState("gov.nasa.worldwind.RetrieverStatusSuccessful");
                    RpfRetriever rpfRetriever = this;
                    return rpfRetriever;
                }
                if (!this.interrupted()) {
                    this.setState("gov.nasa.worldwind.RetrieverStatusConnecting");
                    file = new File(this.record.filePath);
                    if (!file.exists()) {
                        String string = WorldWind.retrieveErrMsg("generic.fileNotFound") + this.record.filePath;
                        throw new IOException(string);
                    }
                    this.rpfImageFile = RpfImageFile.load(file);
                }
                if (!this.interrupted()) {
                    this.setState("gov.nasa.worldwind.RetrieverStatusReading");
                    file = WorldWind.dataFileCache().newFile(this.record.cacheFilePath);
                    if (file == null) {
                        String string = WorldWind.retrieveErrMsg("generic.CantCreateCacheFile") + this.record.cacheFilePath;
                        throw new IOException(string);
                    }
                    this.buffer = this.rpfImageFile.getImageAsDdsTexture();
                    WWIO.saveBuffer(this.buffer, file);
                }
                if (!this.interrupted()) {
                    this.setState("gov.nasa.worldwind.RetrieverStatusSuccessful");
                    this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this.layer);
                }
            }
            catch (Exception exception) {
                this.setState("gov.nasa.worldwind.RetrieverStatusError");
                throw exception;
            }
            finally {
                this.record.fileLock.unlock();
            }
            return this;
        }
    }

    private static class FrameRecord {
        public final RpfFrameProperties properties;
        public final Sector sector;
        public final String filePath;
        public final String cacheFilePath;
        private boolean corruptCache = false;
        final Lock fileLock = new ReentrantLock();

        public FrameRecord(RpfFrameProperties rpfFrameProperties, Sector sector, String string, String string2) {
            this.properties = rpfFrameProperties;
            this.sector = sector;
            this.filePath = string;
            this.cacheFilePath = string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            FrameRecord frameRecord = (FrameRecord)object;
            return this.filePath.equals(frameRecord.filePath) && this.properties.equals(frameRecord.properties);
        }

        public boolean isCorruptCache() {
            return this.corruptCache;
        }

        public void setCorruptCache(boolean bl) {
            this.corruptCache = bl;
        }
    }

    private static class FrameKey {
        public final RpfZone zone;
        public final int frameNumber;
        private final int hashCode;

        public FrameKey(RpfZone rpfZone, int n) {
            this.zone = rpfZone;
            this.frameNumber = n;
            this.hashCode = this.computeHash();
        }

        private int computeHash() {
            int n = 0;
            if (this.zone != null) {
                n = 29 * n + this.zone.ordinal();
            }
            n = 29 * n + this.frameNumber;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            FrameKey frameKey = (FrameKey)object;
            return this.zone == frameKey.zone && this.frameNumber == frameKey.frameNumber;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

