/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Globe;
import gov.nasa.worldwind.Level;
import gov.nasa.worldwind.MemoryCache;
import gov.nasa.worldwind.Tile;
import gov.nasa.worldwind.TileKey;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Sector;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class TextureTile
extends Tile
implements Disposable {
    private volatile TextureData textureData;
    private Texture texture;
    private TextureTile fallbackTile = null;
    private Point centroid;
    private Point[] corners;
    private Extent extent = null;
    private double extentVerticalExaggertion = Double.MIN_VALUE;
    private double minDistanceToEye = Double.MAX_VALUE;
    private static ConcurrentLinkedQueue<TextureTile> texturesToDispose = new ConcurrentLinkedQueue();

    public static synchronized void disposeTextures() {
        TextureTile textureTile = texturesToDispose.poll();
        while (textureTile != null && textureTile.texture != null) {
            textureTile.texture.dispose();
            textureTile.texture = null;
            textureTile = texturesToDispose.poll();
        }
    }

    public TextureTile(Sector sector) {
        super(sector);
    }

    public TextureTile(Sector sector, Level level, int n, int n2) {
        super(sector, level, n, n2);
    }

    public final long getSizeInBytes() {
        long l = super.getSizeInBytes();
        if (this.textureData != null) {
            l += (long)this.textureData.getEstimatedMemorySize();
        }
        return l;
    }

    public void dispose() {
        if (this.texture == null) {
            return;
        }
        if (GLContext.getCurrent() != null) {
            this.texture.dispose();
            this.texture = null;
        } else if (!texturesToDispose.contains(this)) {
            texturesToDispose.add(this);
        }
    }

    public TextureTile getFallbackTile() {
        return this.fallbackTile;
    }

    public void setFallbackTile(TextureTile textureTile) {
        this.fallbackTile = textureTile;
    }

    public TextureData getTextureData() {
        return this.textureData;
    }

    public void setTextureData(TextureData textureData) {
        this.textureData = textureData;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean holdsTexture() {
        return this.getTexture() != null || this.getTextureData() != null;
    }

    public void setTexture(Texture texture) {
        if (texture == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.TextureIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.texture = texture;
        this.textureData = null;
    }

    public Point getCentroidPoint(Globe globe) {
        if (globe == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.GlobeIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.centroid == null) {
            LatLon latLon = this.getSector().getCentroid();
            this.centroid = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0);
        }
        return this.centroid;
    }

    public Point[] getCornerPoints(Globe globe) {
        if (globe == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.GlobeIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.corners == null) {
            Sector sector = this.getSector();
            this.corners = new Point[4];
            this.corners[0] = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), 0.0);
            this.corners[1] = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), 0.0);
            this.corners[2] = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), 0.0);
            this.corners[3] = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), 0.0);
        }
        return this.corners;
    }

    public double getMinDistanceToEye() {
        return this.minDistanceToEye;
    }

    public void setMinDistanceToEye(double d) {
        if (d < 0.0) {
            String string = WorldWind.retrieveErrMsg("layers.TextureTile.MinDistanceToEyeNegative");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.minDistanceToEye = d;
    }

    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.extent == null || this.extentVerticalExaggertion != drawContext.getVerticalExaggeration()) {
            this.extent = Sector.computeBoundingCylinder(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), this.getSector());
            this.extentVerticalExaggertion = drawContext.getVerticalExaggeration();
        }
        return this.extent;
    }

    public TextureTile[] createSubTiles(Level level) {
        if (level == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LevelIsNull");
            WorldWind.logger().log(java.util.logging.Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = this.getSector().getMinLatitude();
        Angle angle2 = this.getSector().getMaxLatitude();
        Angle angle3 = Angle.midAngle(angle, angle2);
        Angle angle4 = this.getSector().getMinLongitude();
        Angle angle5 = this.getSector().getMaxLongitude();
        Angle angle6 = Angle.midAngle(angle4, angle5);
        String string = level.getCacheName();
        int n = level.getLevelNumber();
        int n2 = this.getRow();
        int n3 = this.getColumn();
        TextureTile[] textureTileArray = new TextureTile[4];
        TileKey tileKey = new TileKey(n, 2 * n2, 2 * n3, string);
        TextureTile textureTile = this.getTileFromMemoryCache(tileKey);
        textureTileArray[0] = textureTile != null ? textureTile : new TextureTile(new Sector(angle, angle3, angle4, angle6), level, 2 * n2, 2 * n3);
        tileKey = new TileKey(n, 2 * n2, 2 * n3 + 1, string);
        textureTile = this.getTileFromMemoryCache(tileKey);
        textureTileArray[1] = textureTile != null ? textureTile : new TextureTile(new Sector(angle, angle3, angle6, angle5), level, 2 * n2, 2 * n3 + 1);
        tileKey = new TileKey(n, 2 * n2 + 1, 2 * n3, string);
        textureTile = this.getTileFromMemoryCache(tileKey);
        textureTileArray[2] = textureTile != null ? textureTile : new TextureTile(new Sector(angle3, angle2, angle4, angle6), level, 2 * n2 + 1, 2 * n3);
        tileKey = new TileKey(n, 2 * n2 + 1, 2 * n3 + 1, string);
        textureTile = this.getTileFromMemoryCache(tileKey);
        textureTileArray[3] = textureTile != null ? textureTile : new TextureTile(new Sector(angle3, angle2, angle6, angle5), level, 2 * n2 + 1, 2 * n3 + 1);
        return textureTileArray;
    }

    public void initializeTexture(DrawContext drawContext) {
        if (this.getTexture() == null) {
            int n = 9729;
            this.setTexture(TextureIO.newTexture(this.getTextureData()));
            this.getTexture().bind();
            GL gL = drawContext.getGL();
            gL.glTexParameteri(3553, 10241, n);
            gL.glTexParameteri(3553, 10240, n);
            gL.glTexParameteri(3553, 10242, 33071);
            gL.glTexParameteri(3553, 10243, 33071);
        }
    }

    public boolean bindTexture(DrawContext drawContext) {
        if (this.holdsTexture()) {
            if (this.getTexture() == null) {
                this.initializeTexture(drawContext);
            }
            if (this.getTexture() == null) {
                return false;
            }
            this.getTexture().bind();
        } else if (this.getFallbackTile() != null) {
            TextureTile textureTile = this.getFallbackTile();
            if (textureTile.getTexture() == null) {
                textureTile.initializeTexture(drawContext);
            }
            if (textureTile.getTexture() == null) {
                return false;
            }
            textureTile.getTexture().bind();
        }
        return true;
    }

    public void applyTextureTransform(DrawContext drawContext) {
        GL gL = GLContext.getCurrent().getGL();
        gL.glMatrixMode(5890);
        gL.glLoadIdentity();
        if (this.holdsTexture()) {
            if (this.getTexture() == null) {
                this.initializeTexture(drawContext);
            }
            if (this.getTexture() == null) {
                return;
            }
            if (this.getTexture().getMustFlipVertically()) {
                gL.glScaled(1.0, -1.0, 1.0);
                gL.glTranslated(0.0, -1.0, 0.0);
            }
        } else if (this.getFallbackTile() != null) {
            TextureTile textureTile = this.getFallbackTile();
            if (textureTile.getTexture() == null) {
                textureTile.initializeTexture(drawContext);
            }
            if (textureTile.getTexture() == null) {
                return;
            }
            if (textureTile.getTexture().getMustFlipVertically()) {
                gL.glScaled(1.0, -1.0, 1.0);
                gL.glTranslated(0.0, -1.0, 0.0);
            }
            this.applyResourceTextureTransform(drawContext);
        }
    }

    private void applyResourceTextureTransform(DrawContext drawContext) {
        if (this.getLevel() == null) {
            return;
        }
        int n = this.getLevelNumber() - this.getFallbackTile().getLevelNumber();
        if (n <= 0) {
            return;
        }
        double d = Math.pow(2.0, n);
        double d2 = 1.0 / d;
        double d3 = d2 * ((double)this.getColumn() % d);
        double d4 = d2 * ((double)this.getRow() % d);
        drawContext.getGL().glTranslated(d3, d4, 0.0);
        drawContext.getGL().glScaled(d2, d2, 1.0);
    }

    private TextureTile getTileFromMemoryCache(TileKey tileKey) {
        return (TextureTile)WorldWind.memoryCache().getObject(tileKey);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextureTile textureTile = (TextureTile)object;
        return !(this.getTileKey() == null ? textureTile.getTileKey() != null : !this.getTileKey().equals(textureTile.getTileKey()));
    }

    public int hashCode() {
        return this.getTileKey() != null ? this.getTileKey().hashCode() : 0;
    }

    public String toString() {
        return this.getSector().toString();
    }

    static {
        WorldWind.memoryCache().addCacheListener(new MemoryCache.CacheListener(){

            public synchronized void entryRemoved(Object object, Object object2) {
                TextureTile textureTile;
                if (object2 != null && object2 instanceof TextureTile && (textureTile = (TextureTile)object2).texture != null) {
                    texturesToDispose.add(textureTile);
                }
            }
        });
    }
}

