/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.IconRenderer;
import gov.nasa.worldwind.Material;
import gov.nasa.worldwind.SectorGeometryList;
import gov.nasa.worldwind.Track;
import gov.nasa.worldwind.TrackPointIteratorImpl;
import gov.nasa.worldwind.TrackRenderer;
import gov.nasa.worldwind.UserFacingIcon;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.AbstractLayer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackLayer
extends AbstractLayer {
    private TrackRenderer trackRenderer = new TrackRenderer();
    private List<Track> tracks = new ArrayList<Track>();
    private Sector boundingSector;
    private IconRenderer iconRenderer = new IconRenderer();
    private UserFacingIcon icon;

    public TrackLayer(List<Track> list) {
        if (list == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.TracksIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.tracks = list;
        this.boundingSector = Sector.boundingSector(this.iterator());
    }

    private TrackPointIteratorImpl iterator() {
        return new TrackPointIteratorImpl(this.tracks);
    }

    @Override
    public void dispose() {
        this.trackRenderer.dispose();
    }

    public int getNumPoints() {
        return this.iterator().getNumPoints();
    }

    public double getMarkerPixels() {
        return this.trackRenderer.getMarkerPixels();
    }

    public void setMarkerPixels(double d) {
        this.trackRenderer.setMarkerPixels(d);
    }

    public double getMinMarkerSize() {
        return this.trackRenderer.getMinMarkerSize();
    }

    public void setMinMarkerSize(double d) {
        this.trackRenderer.setMinMarkerSize(d);
    }

    public double getMarkerElevation() {
        return this.trackRenderer.getMarkerElevation();
    }

    public void setMarkerElevation(double d) {
        this.trackRenderer.setMarkerElevation(d);
    }

    public Material getMaterial() {
        return this.trackRenderer.getMaterial();
    }

    public void setMaterial(Material material) {
        this.trackRenderer.setMaterial(material);
    }

    public String getIconFilePath() {
        return this.icon != null ? this.icon.getPath() : null;
    }

    public void setIconFilePath(String string) {
        this.icon = string != null ? new UserFacingIcon(string, null) : null;
    }

    public int getLowerLimit() {
        return this.trackRenderer.getLowerLimit();
    }

    public void setLowerLimit(int n) {
        this.trackRenderer.setLowerLimit(n);
    }

    public int getUpperLimit() {
        return this.trackRenderer.getUpperLimit();
    }

    public void setUpperLimit(int n) {
        this.trackRenderer.setUpperLimit(n);
    }

    @Override
    protected void doPick(DrawContext drawContext, java.awt.Point point) {
        this.draw(drawContext, point);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        this.draw(drawContext, null);
    }

    private void draw(DrawContext drawContext, java.awt.Point point) {
        TrackPointIteratorImpl trackPointIteratorImpl = this.iterator();
        if (!trackPointIteratorImpl.hasNext()) {
            return;
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (!drawContext.getVisibleSector().intersects(this.boundingSector)) {
            return;
        }
        Point point2 = this.trackRenderer.render(drawContext, trackPointIteratorImpl);
        if (point2 != null && this.icon != null) {
            if (drawContext.isPickingMode()) {
                this.iconRenderer.pick(drawContext, this.icon, point2, point, this);
            } else {
                this.iconRenderer.render(drawContext, this.icon, point2);
            }
        }
    }

    @Override
    public String toString() {
        return WorldWind.retrieveErrMsg("layers.TrackLayer.Name");
    }
}

