/*
 * Decompiled with CFR 0.152.
 */
package worldwinddemo;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.GeoRSSParser;
import gov.nasa.worldwind.Layer;
import gov.nasa.worldwind.LayerList;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.Renderable;
import gov.nasa.worldwind.RenderingEvent;
import gov.nasa.worldwind.RenderingListener;
import gov.nasa.worldwind.SelectEvent;
import gov.nasa.worldwind.SelectListener;
import gov.nasa.worldwind.UserFacingIcon;
import gov.nasa.worldwind.Version;
import gov.nasa.worldwind.WWIcon;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.SurfacePolygon;
import gov.nasa.worldwind.geom.SurfaceQuadrilateral;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.TiledImageLayer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import worldwinddemo.StatusBar;

public class AWT1Up {
    public static void main(String[] stringArray) {
        System.out.println("Java run-time version: " + System.getProperty("java.version"));
        try {
            AWT1UpFrame aWT1UpFrame = new AWT1UpFrame();
            aWT1UpFrame.setDefaultCloseOperation(3);
            aWT1UpFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind AWT Canvas App");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        }
    }

    private static class AWT1UpFrame
    extends JFrame {
        StatusBar statusBar;
        JLabel cursorPositionDisplay;
        WorldWindowGLCanvas wwd;
        WWIcon lastPickedIcon;
        private static final String lineTestString = "<gml:LineString> <gml:posList>45.256 -110.45 46.46 -109.48 43.84 -109.86</gml:posList></gml:LineString>";
        private static final String itemTestString = "<item>    <title>M 3.2, Mona Passage</title>    <link>http://example.org/2005/09/09/atom01</link>    <pubDate>Wed, 17 Aug 2005 07:02:32 GMT</pubDate>    <georss:where>      <gml:Polygon>        <gml:exterior>          <gml:LinearRing>            <gml:posList>    \t\t\t        45.256 -110.45 46.46 -109.48 43.84 -109.86 45.256 -110.45        \t       </gml:posList>          </gml:LinearRing>   </gml:exterior>  </gml:Polygon> </georss:where> </item>";

        public AWT1UpFrame() {
            try {
                System.out.println(Version.getVersion());
                this.wwd = new WorldWindowGLCanvas();
                this.wwd.setPreferredSize(new Dimension(800, 600));
                this.getContentPane().add((Component)this.wwd, "Center");
                this.statusBar = new StatusBar();
                this.getContentPane().add((Component)this.statusBar, "Last");
                this.pack();
                Dimension dimension = this.getPreferredSize();
                Point point = new Point(0, 0);
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                int n = point.x + (dimension2.width - dimension.width) / 2;
                int n2 = point.y + (dimension2.height - dimension.height) / 2;
                this.setLocation(n, n2);
                this.setResizable(true);
                Model model = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
                LayerList layerList = model.getLayers();
                for (Layer layer : layerList) {
                    if (layer instanceof TiledImageLayer) {
                        ((TiledImageLayer)layer).setShowImageTileOutlines(false);
                    }
                    if (layer instanceof LandsatI3) {
                        ((TiledImageLayer)layer).setDrawBoundingVolumes(false);
                    }
                    if (!(layer instanceof CompassLayer)) continue;
                    ((CompassLayer)layer).setShowTilt(true);
                }
                model.getLayers().add(this.buildShapesLayer());
                model.getLayers().add(this.buildIconLayer());
                model.getLayers().add(this.buildGeoRSSLayer());
                model.setShowWireframeExterior(false);
                model.setShowWireframeInterior(false);
                this.wwd.setModel(model);
                this.statusBar.setEventSource(this.wwd);
                this.wwd.addRenderingListener(new RenderingListener(){

                    public void stageChanged(RenderingEvent renderingEvent) {
                    }
                });
                this.wwd.addSelectListener(new SelectListener(){
                    private WWIcon lastToolTipIcon = null;

                    public void selected(SelectEvent selectEvent) {
                        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                            if (selectEvent.hasObjects()) {
                                System.out.println("Single clicked " + selectEvent.getTopObject());
                            } else {
                                System.out.println("Single clicked no object");
                            }
                        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftDoubleClick")) {
                            if (selectEvent.hasObjects()) {
                                System.out.println("Double clicked " + selectEvent.getTopObject());
                            } else {
                                System.out.println("Double clicked no object");
                            }
                        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.RightClick")) {
                            if (selectEvent.hasObjects()) {
                                System.out.println("Right clicked " + selectEvent.getTopObject());
                            } else {
                                System.out.println("Right clicked no object");
                            }
                        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Hover")) {
                            if (this.lastToolTipIcon != null) {
                                this.lastToolTipIcon.setShowToolTip(false);
                                this.lastToolTipIcon = null;
                                AWT1UpFrame.this.wwd.repaint();
                            }
                            if (selectEvent.hasObjects() && selectEvent.getTopObject() instanceof WWIcon) {
                                this.lastToolTipIcon = (WWIcon)selectEvent.getTopObject();
                                this.lastToolTipIcon.setShowToolTip(true);
                                AWT1UpFrame.this.wwd.repaint();
                            }
                        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                            AWT1UpFrame.this.highlight(selectEvent.getTopObject());
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void highlight(Object object) {
            if (this.lastPickedIcon == object) {
                return;
            }
            if (this.lastPickedIcon != null) {
                this.lastPickedIcon.setHighlighted(false);
                this.lastPickedIcon = null;
            }
            if (object != null && object instanceof WWIcon) {
                this.lastPickedIcon = (WWIcon)object;
                this.lastPickedIcon.setHighlighted(true);
            }
        }

        private IconLayer buildIconLayer() {
            IconLayer iconLayer = new IconLayer();
            for (double d = 0.0; d < 10.0; d += 10.0) {
                for (double d2 = -180.0; d2 < 180.0; d2 += 10.0) {
                    double d3 = 0.0;
                    if (d2 % 90.0 == 0.0) {
                        d3 = 2000000.0;
                    }
                    UserFacingIcon userFacingIcon = new UserFacingIcon("images/32x32-icon-nasa.png", new Position(Angle.fromDegrees(d), Angle.fromDegrees(d2), d3));
                    userFacingIcon.setHighlightScale(1.5);
                    userFacingIcon.setToolTipFont(this.makeToolTipFont());
                    userFacingIcon.setToolTipText(userFacingIcon.getPath());
                    userFacingIcon.setToolTipTextColor(Color.YELLOW);
                    iconLayer.addIcon(userFacingIcon);
                }
            }
            return iconLayer;
        }

        private RenderableLayer buildShapesLayer() {
            RenderableLayer renderableLayer = new RenderableLayer();
            Color color = new Color(1.0f, 1.0f, 0.0f, 0.3f);
            Color color2 = new Color(1.0f, 1.0f, 0.0f, 0.4f);
            SurfaceQuadrilateral surfaceQuadrilateral = new SurfaceQuadrilateral(new Sector(Angle.fromDegrees(41.0), Angle.fromDegrees(41.6), Angle.fromDegrees(-122.5), Angle.fromDegrees(-121.7)), color, color2);
            renderableLayer.addRenderable(surfaceQuadrilateral);
            surfaceQuadrilateral = new SurfaceQuadrilateral(new Sector(Angle.fromDegrees(38.9), Angle.fromDegrees(39.3), Angle.fromDegrees(-120.2), Angle.fromDegrees(-119.9)), new Color(0.0f, 1.0f, 1.0f, 0.3f), new Color(0.5f, 1.0f, 1.0f, 0.4f));
            renderableLayer.addRenderable(surfaceQuadrilateral);
            double d = 28.0;
            double d2 = -82.0;
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            arrayList.add(new LatLon(Angle.fromDegrees(d + 5.0), Angle.fromDegrees(d2 + 2.5)));
            arrayList.add(new LatLon(Angle.fromDegrees(d + 5.0), Angle.fromDegrees(d2 - 2.5)));
            arrayList.add(new LatLon(Angle.fromDegrees(d + 2.5), Angle.fromDegrees(d2 - 5.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(d - 2.5), Angle.fromDegrees(d2 - 5.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(d - 5.0), Angle.fromDegrees(d2 - 2.5)));
            arrayList.add(new LatLon(Angle.fromDegrees(d - 5.0), Angle.fromDegrees(d2 + 2.5)));
            arrayList.add(new LatLon(Angle.fromDegrees(d - 2.5), Angle.fromDegrees(d2 + 5.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(d + 2.5), Angle.fromDegrees(d2 + 5.0)));
            SurfacePolygon surfacePolygon = new SurfacePolygon(arrayList, new Color(1.0f, 0.11f, 0.2f, 0.4f), new Color(1.0f, 0.0f, 0.0f, 0.6f));
            surfacePolygon.setStroke(new BasicStroke(2.0f));
            renderableLayer.addRenderable(surfacePolygon);
            return renderableLayer;
        }

        private RenderableLayer buildGeoRSSLayer() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new File("GeoRSSTestData.xml"));
                List<Renderable> list = GeoRSSParser.parseShapes(document);
                RenderableLayer renderableLayer = new RenderableLayer();
                if (list != null) {
                    for (Renderable renderable : list) {
                        renderableLayer.addRenderable(renderable);
                    }
                }
                return renderableLayer;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            return null;
        }

        private Font makeToolTipFont() {
            HashMap<TextAttribute, Color> hashMap = new HashMap<TextAttribute, Color>();
            hashMap.put(TextAttribute.BACKGROUND, new Color(0.4f, 0.4f, 0.4f, 1.0f));
            return Font.decode("Arial-BOLD-14").deriveFont(hashMap);
        }
    }
}

