/*
 * Decompiled with CFR 0.152.
 */
package worldwinddemo;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Layer;
import gov.nasa.worldwind.LayerList;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.Version;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.BMNGSurfaceLayer;
import gov.nasa.worldwind.layers.Earth.EarthNASAPlaceNameLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3;
import gov.nasa.worldwind.layers.Earth.USGSDigitalOrtho;
import gov.nasa.worldwind.layers.Earth.USGSUrbanAreaOrtho;
import gov.nasa.worldwind.layers.TiledImageLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import worldwinddemo.StatusBar;

public class BasicDemo {
    private LayerAction[] layers = new LayerAction[]{new LayerAction(new BMNGSurfaceLayer(), true), new LayerAction(new LandsatI3(), true), new LayerAction(new USGSDigitalOrtho(), false), new LayerAction(new USGSUrbanAreaOrtho(), true), new LayerAction(new EarthNASAPlaceNameLayer(), true), new LayerAction(new CompassLayer(), true)};
    private static AppFrame appFrame;

    public static void main(String[] stringArray) {
        System.out.println("Java run-time version: " + System.getProperty("java.version"));
        System.out.println(Version.getVersion());
        try {
            BasicDemo basicDemo = new BasicDemo();
            appFrame = new AppFrame(basicDemo.layers);
            appFrame.setDefaultCloseOperation(3);
            appFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Basic Demo");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        }
    }

    private static class LayerAction
    extends AbstractAction {
        private Layer layer;
        private boolean selected;

        public LayerAction(Layer layer, boolean bl) {
            super(layer.getName());
            this.layer = layer;
            this.selected = bl;
            this.layer.setEnabled(this.selected);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                this.layer.setEnabled(true);
            } else {
                this.layer.setEnabled(false);
            }
            appFrame.wwd.repaint();
        }
    }

    private static class AppFrame
    extends JFrame {
        private final WorldWindowGLCanvas wwd = new WorldWindowGLCanvas();

        public AppFrame(LayerAction[] layerActionArray) {
            LayerList layerList = new LayerList();
            try {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                this.wwd.setPreferredSize(new Dimension(800, 600));
                jPanel.add((Component)this.wwd, "Center");
                StatusBar statusBar = new StatusBar();
                statusBar.setEventSource(this.wwd);
                jPanel.add((Component)statusBar, "Last");
                this.getContentPane().add((Component)jPanel, "Center");
                JPanel jPanel2 = new JPanel(new BorderLayout());
                Serializable serializable = new JPanel(new GridLayout(0, 1, 0, 10));
                ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
                Serializable serializable2 = new JPanel(new GridLayout(0, 1, 0, 15));
                serializable2.setBorder(new TitledBorder("Layers"));
                for (LayerAction layerAction : layerActionArray) {
                    JCheckBox jCheckBox = new JCheckBox(layerAction);
                    jCheckBox.setSelected(layerAction.selected);
                    serializable2.add(jCheckBox);
                    layerList.add(layerAction.layer);
                    if (layerAction.layer instanceof TiledImageLayer) {
                        ((TiledImageLayer)layerAction.layer).setShowImageTileOutlines(false);
                    }
                    if (layerAction.layer instanceof LandsatI3) {
                        ((TiledImageLayer)layerAction.layer).setDrawBoundingVolumes(false);
                    }
                    if (!(layerAction.layer instanceof USGSDigitalOrtho)) continue;
                    ((TiledImageLayer)layerAction.layer).setDrawTileIDs(false);
                }
                ((Container)serializable).add((Component)serializable2);
                jPanel2.add((Component)serializable, "North");
                this.getContentPane().add((Component)jPanel2, "West");
                this.pack();
                serializable = this.getPreferredSize();
                ((Dimension)serializable).setSize(((Dimension)serializable).getWidth(), 1.1 * ((Dimension)serializable).getHeight());
                this.setSize((Dimension)serializable);
                Point point = new Point(0, 0);
                serializable2 = Toolkit.getDefaultToolkit().getScreenSize();
                int n = point.x + (((Dimension)serializable2).width - ((Dimension)serializable).width) / 2;
                int n2 = point.y + (((Dimension)serializable2).height - ((Dimension)serializable).height) / 2;
                this.setLocation(n, n2);
                this.setResizable(true);
                Model model = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
                model.setLayers(layerList);
                model.setShowWireframeExterior(false);
                model.setShowWireframeInterior(false);
                model.setShowTessellationBoundingVolumes(false);
                this.wwd.setModel(model);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

