/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.AVList;
import gov.nasa.worldwind.WWRuntimeException;
import gov.nasa.worldwind.WorldWind;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVListImpl
implements AVList,
PropertyChangeListener {
    protected final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private Map<String, Object> avList;

    private boolean hasAvList() {
        return this.avList != null;
    }

    private void createAvList() {
        if (!this.hasAvList()) {
            this.avList = new HashMap<String, Object>();
        }
    }

    private Map<String, Object> avList(boolean bl) {
        if (bl && !this.hasAvList()) {
            this.createAvList();
        }
        return this.avList;
    }

    @Override
    public final Object getValue(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.AttributeKeyIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.hasAvList()) {
            return this.avList.get(string);
        }
        return null;
    }

    @Override
    public final String getStringValue(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.AttributeKeyIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalStateException(string2);
        }
        try {
            return (String)this.getValue(string);
        }
        catch (ClassCastException classCastException) {
            String string3 = WorldWind.retrieveErrMsg("AVAAccessibleImpl.AttributeValueForKeyIsNotAString") + string;
            WorldWind.logger().log(Level.FINE, string3);
            throw new WWRuntimeException(string3, classCastException);
        }
    }

    @Override
    public final void setValue(String string, Object object) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.AttributeKeyIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        this.avList(true).put(string, object);
    }

    @Override
    public final boolean hasKey(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.KeyIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        return this.hasAvList() && this.avList.containsKey(string);
    }

    @Override
    public final void removeKey(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.KeyIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.hasKey(string)) {
            this.avList.remove(string);
        }
    }

    @Override
    public AVList copy() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.createAvList();
        aVListImpl.avList.putAll(this.avList);
        return aVListImpl;
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.PropertyNameIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (propertyChangeListener == null) {
            String string3 = WorldWind.retrieveErrMsg("nullValue.ListenerIsNull");
            WorldWind.logger().log(Level.FINE, string3);
            throw new IllegalArgumentException(string3);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.PropertyNameIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (propertyChangeListener == null) {
            String string3 = WorldWind.retrieveErrMsg("nullValue.ListenerIsNull");
            WorldWind.logger().log(Level.FINE, string3);
            throw new IllegalArgumentException(string3);
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ListenerIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ListenerIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PropertyChangeEventIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.changeSupport.firePropertyChange(propertyChangeEvent);
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.PropertyNameIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PropertyChangeEventIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.changeSupport.firePropertyChange(propertyChangeEvent);
    }
}

