/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Globe;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Matrix4;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Position;
import java.awt.Rectangle;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public abstract class AbstractView
extends WWObjectImpl
implements View {
    private static final Double DefaultFov = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.FieldOfView", 45.0);
    private Matrix4 modelView;
    private Matrix4 projection;
    private Rectangle viewport;
    private Angle fieldOfView = Angle.fromDegrees(DefaultFov);
    private Globe globe = null;
    private double verticalExaggeration = -1.0;
    private Point eye = null;
    private Point up = null;
    private Point forward = null;
    private Frustum frustumInModelCoords = null;
    private double pixelSizeScale = -1.0;
    private double horizonDistance = -1.0;
    private static final int[] matrixMode = new int[1];
    private static final int[] viewportArray = new int[4];

    public void apply(DrawContext drawContext) {
        this.validateDrawContext(drawContext);
        this.globe = drawContext.getGlobe();
        this.verticalExaggeration = drawContext.getVerticalExaggeration();
        drawContext.getGL().glGetIntegerv(2978, viewportArray, 0);
        this.viewport = new Rectangle(viewportArray[0], viewportArray[1], viewportArray[2], viewportArray[3]);
        this.clearCachedAttributes();
        this.doApply(drawContext);
    }

    protected abstract void doApply(DrawContext var1);

    private void clearCachedAttributes() {
        this.eye = null;
        this.up = null;
        this.forward = null;
        this.frustumInModelCoords = null;
        this.pixelSizeScale = -1.0;
        this.horizonDistance = -1.0;
    }

    protected void applyMatrixState(DrawContext drawContext, Matrix4 matrix4, Matrix4 matrix42) {
        Object object;
        this.validateDrawContext(drawContext);
        if (matrix4 == null) {
            object = WorldWind.retrieveErrMsg("AbstractView.ModelViewIsNull");
            WorldWind.logger().log(Level.FINE, (String)object);
        }
        if (matrix42 == null) {
            object = WorldWind.retrieveErrMsg("AbstractView.ProjectionIsNull");
            WorldWind.logger().log(Level.FINE, (String)object);
        }
        object = drawContext.getGL();
        object.glGetIntegerv(2976, matrixMode, 0);
        int n = matrixMode[0];
        if (n != 5888) {
            n = 5888;
            object.glMatrixMode(n);
        }
        if (matrix4 != null) {
            object.glLoadMatrixd(matrix4.getEntries(), 0);
        } else {
            object.glLoadIdentity();
        }
        n = 5889;
        object.glMatrixMode(n);
        if (matrix42 != null) {
            object.glLoadMatrixd(matrix42.getEntries(), 0);
        } else {
            object.glLoadIdentity();
        }
        if (n != matrixMode[0]) {
            object.glMatrixMode(matrixMode[0]);
        }
        this.modelView = matrix4;
        this.projection = matrix42;
    }

    protected void validateDrawContext(DrawContext drawContext) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = WorldWind.retrieveErrMsg("AbstractView.DrawingContextGLIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
    }

    public Matrix4 getModelViewMatrix() {
        return this.modelView;
    }

    public Matrix4 getProjectionMatrix() {
        return this.projection;
    }

    public Rectangle getViewport() {
        return this.viewport;
    }

    public Frustum getFrustumInModelCoordinates() {
        Frustum frustum;
        if (this.frustumInModelCoords == null && (frustum = this.getFrustum()) != null && this.modelView != null) {
            this.frustumInModelCoords = frustum.getInverseTransformed(this.modelView);
        }
        return this.frustumInModelCoords;
    }

    public Angle getFieldOfView() {
        return this.fieldOfView;
    }

    public void setFieldOfView(Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.fieldOfView = angle;
    }

    public void pushReferenceCenter(DrawContext drawContext, Point point) {
        Object object;
        Matrix4 matrix4;
        this.validateDrawContext(drawContext);
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.modelView != null) {
            matrix4 = new Matrix4(this.modelView.getEntries());
            object = new Matrix4();
            ((Matrix4)object).translate(point);
            matrix4.multiply((Matrix)object);
        } else {
            matrix4 = new Matrix4();
        }
        object = drawContext.getGL();
        object.glGetIntegerv(2976, matrixMode, 0);
        if (matrixMode[0] != 5888) {
            object.glMatrixMode(5888);
        }
        object.glPushMatrix();
        object.glLoadMatrixd(matrix4.getEntries(), 0);
        if (matrixMode[0] != 5888) {
            object.glMatrixMode(matrixMode[0]);
        }
    }

    public void popReferenceCenter(DrawContext drawContext) {
        this.validateDrawContext(drawContext);
        GL gL = drawContext.getGL();
        gL.glGetIntegerv(2976, matrixMode, 0);
        if (matrixMode[0] != 5888) {
            gL.glMatrixMode(5888);
        }
        gL.glPopMatrix();
        if (matrixMode[0] != 5888) {
            gL.glMatrixMode(matrixMode[0]);
        }
    }

    public Point getEyePoint() {
        Matrix matrix;
        if (this.eye == null && this.modelView != null && (matrix = this.modelView.getInverse()) != null) {
            this.eye = matrix.transform(new Point(0.0, 0.0, 0.0, 1.0));
        }
        return this.eye;
    }

    public Point getUpVector() {
        Matrix matrix;
        if (this.up == null && this.modelView != null && (matrix = this.modelView.getInverse()) != null) {
            this.up = matrix.transform(new Point(0.0, 1.0, 0.0, 0.0));
        }
        return this.up;
    }

    public Point getForwardVector() {
        Matrix matrix;
        if (this.forward == null && this.modelView != null && (matrix = this.modelView.getInverse()) != null) {
            this.forward = matrix.transform(new Point(0.0, 0.0, -1.0, 0.0));
        }
        return this.forward;
    }

    public Line computeRayFromScreenPoint(double d, double d2) {
        if (this.viewport == null) {
            return null;
        }
        double d3 = (double)this.viewport.height - d2 - 1.0;
        Point point = this.unProject(new Point(d, d3, 0.0, 0.0));
        Point point2 = this.unProject(new Point(d, d3, 1.0, 0.0));
        if (point == null || point2 == null) {
            return null;
        }
        return new Line(point, point2.subtract(point).normalize());
    }

    public Position computePositionFromScreenPoint(double d, double d2) {
        Line line = this.computeRayFromScreenPoint(d, d2);
        if (line == null) {
            return null;
        }
        if (this.globe == null) {
            return null;
        }
        return this.globe.getIntersectionPosition(line);
    }

    public double computePixelSizeAtDistance(double d) {
        if (this.pixelSizeScale < 0.0) {
            if (this.fieldOfView != null && this.viewport.width > 0) {
                this.pixelSizeScale = 2.0 * this.fieldOfView.tanHalfAngle() / (double)this.viewport.width;
            } else if (this.viewport.width > 0) {
                this.pixelSizeScale = 1.0 / (double)this.viewport.width;
            }
        }
        if (this.pixelSizeScale < 0.0) {
            return -1.0;
        }
        return this.pixelSizeScale * Math.abs(d);
    }

    public double computeHorizonDistance() {
        if (this.horizonDistance < 0.0) {
            this.horizonDistance = this.computeHorizonDistance(this.globe, this.verticalExaggeration, this.getEyePoint());
        }
        return this.horizonDistance;
    }

    protected double computeHorizonDistance(Globe globe, double d, Point point) {
        if (globe == null || point == null) {
            return -1.0;
        }
        Position position = globe.computePositionFromPoint(point);
        double d2 = d * globe.getElevation(position.getLatitude(), position.getLongitude());
        Point point2 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d2);
        double d3 = point.length() - point2.length();
        double d4 = globe.getMaximumRadius();
        return Math.sqrt(d3 * (2.0 * d4 + d3));
    }

    public Point project(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.modelView == null || this.projection == null || this.viewport == null) {
            return null;
        }
        Point point2 = this.modelView.transform(new Point(point.x(), point.y(), point.z(), 1.0));
        Point point3 = this.projection.transform(point2);
        if (point3.w() == 0.0) {
            return null;
        }
        Point point4 = new Point(point3.x() / point3.w(), point3.y() / point3.w(), point3.z() / point3.w(), 0.0);
        return new Point((point4.x() + 1.0) * ((double)this.viewport.width / 2.0) + (double)this.viewport.x, (point4.y() + 1.0) * ((double)this.viewport.height / 2.0) + (double)this.viewport.y, (point4.z() + 1.0) / 2.0, 0.0);
    }

    public Point unProject(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.modelView == null || this.projection == null || this.viewport == null) {
            return null;
        }
        double[] dArray = this.projection.getEntries();
        double[] dArray2 = this.modelView.getEntries();
        int[] nArray = new int[]{this.viewport.x, this.viewport.y, this.viewport.width, this.viewport.height};
        double[] dArray3 = new double[3];
        GLU gLU = new GLU();
        if (gLU.gluUnProject(point.x(), point.y(), point.z(), dArray2, 0, dArray, 0, nArray, 0, dArray3, 0)) {
            return new Point(dArray3[0], dArray3[1], dArray3[2], 0.0);
        }
        return null;
    }
}

