/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.FrameController;
import gov.nasa.worldwind.Layer;
import gov.nasa.worldwind.LayerList;
import gov.nasa.worldwind.PickedObject;
import gov.nasa.worldwind.SectorGeometry;
import gov.nasa.worldwind.SectorGeometryList;
import gov.nasa.worldwind.WWObject;
import gov.nasa.worldwind.WorldWind;
import java.awt.Color;
import java.awt.Point;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.media.opengl.GL;

public class BasicFrameController
implements FrameController {
    public void initializeFrame(DrawContext drawContext) {
        if (null == drawContext) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        gL.glPushAttrib(14336);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glEnable(2929);
    }

    public void finalizeFrame(DrawContext drawContext) {
        if (null == drawContext) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glPopAttrib();
        gL.glFlush();
    }

    private void checkGLErrors(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        int n = gL.glGetError();
        if (n != 0) {
            String string = drawContext.getGLU().gluErrorString(n);
            string = string + n;
            WorldWind.logger().log(Level.FINE, string);
        }
    }

    public void drawFrame(DrawContext drawContext) {
        WWObject wWObject;
        Object object;
        if (null == drawContext) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.clearFrame(drawContext);
        if (drawContext.getView() == null || drawContext.getModel() == null || drawContext.getLayers() == null) {
            return;
        }
        try {
            drawContext.getView().apply(drawContext);
        }
        catch (Exception exception) {
            String string = WorldWind.retrieveErrMsg("BasicFrameController.ExceptionWhileApplyingView");
            WorldWind.logger().log(Level.FINE, string, exception);
            return;
        }
        try {
            if (drawContext.getModel().getTessellator() != null) {
                object = drawContext.getModel().getTessellator().tessellate(drawContext);
                drawContext.setSurfaceGeometry((SectorGeometryList)object);
            }
            if (drawContext.getSurfaceGeometry() == null) {
                object = WorldWind.retrieveErrMsg("generic.NoSurfaceGeometry");
                WorldWind.logger().log(Level.FINE, (String)object);
            }
        }
        catch (Exception exception) {
            String string = WorldWind.retrieveErrMsg("BasicFrameController.ExceptionWhileTessellatingGlobe");
            WorldWind.logger().log(Level.FINE, string, exception);
            return;
        }
        object = drawContext.getLayers();
        Iterator<Layer> iterator = ((LayerList)object).iterator();
        while (iterator.hasNext()) {
            wWObject = null;
            try {
                wWObject = iterator.next();
                if (wWObject == null) continue;
                wWObject.render(drawContext);
            }
            catch (Exception exception) {
                Object object2 = WorldWind.retrieveErrMsg("BasicFrameController.ExceptionWhileRenderingLayer");
                object2 = (String)object2 + (wWObject != null ? wWObject.getClass().getName() : WorldWind.retrieveErrMsg("term.unknown"));
                WorldWind.logger().log(Level.FINE, (String)object2, exception);
            }
        }
        while (drawContext.getOrderedRenderables().peek() != null) {
            drawContext.getOrderedRenderables().poll().render(drawContext);
        }
        if (drawContext.getSurfaceGeometry() != null && drawContext.getModel().isShowWireframeExterior() || drawContext.getModel().isShowWireframeInterior() || drawContext.getModel().isShowTessellationBoundingVolumes()) {
            wWObject = drawContext.getModel();
            float[] fArray = new float[4];
            drawContext.getGL().glGetFloatv(2816, fArray, 0);
            for (SectorGeometry sectorGeometry : drawContext.getSurfaceGeometry()) {
                if (wWObject.isShowWireframeInterior() || wWObject.isShowWireframeExterior()) {
                    sectorGeometry.renderWireframe(drawContext, wWObject.isShowWireframeInterior(), wWObject.isShowWireframeExterior());
                }
                if (!wWObject.isShowTessellationBoundingVolumes()) continue;
                drawContext.getGL().glColor3d(1.0, 0.0, 0.0);
                sectorGeometry.renderBoundingVolume(drawContext);
            }
            drawContext.getGL().glColor4fv(fArray, 0);
        }
    }

    public void initializePicking(DrawContext drawContext) {
        if (null == drawContext) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        gL.glPushAttrib(14336);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glEnable(2929);
    }

    public void pick(DrawContext drawContext, Point point) {
        Object object;
        Object object2;
        if (null == drawContext) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.clearFrame(drawContext);
        if (drawContext.getView() == null || drawContext.getModel() == null || drawContext.getLayers() == null) {
            return;
        }
        try {
            drawContext.getView().apply(drawContext);
        }
        catch (Exception exception) {
            String string = WorldWind.retrieveErrMsg("BasicFrameController.ExceptionWhileApplyingView");
            WorldWind.logger().log(Level.FINE, string, exception);
            return;
        }
        if (drawContext.getSurfaceGeometry() != null && drawContext.getSurfaceGeometry().size() > 0) {
            drawContext.getSurfaceGeometry().pick(drawContext, point);
        }
        LayerList layerList = drawContext.getLayers();
        Iterator<Layer> iterator = layerList.iterator();
        while (iterator.hasNext()) {
            object2 = null;
            try {
                object2 = iterator.next();
                if (object2 == null || !object2.isPickEnabled()) continue;
                object2.pick(drawContext, point);
            }
            catch (Exception exception) {
                object = WorldWind.retrieveErrMsg("BasicFrameController.ExceptionWhilePickingInLayer");
                object = (String)object + (object2 != null ? object2.getClass().getName() : WorldWind.retrieveErrMsg("term.unknown"));
                WorldWind.logger().log(Level.FINE, (String)object, exception);
            }
        }
        while (drawContext.getOrderedRenderables().peek() != null) {
            drawContext.getOrderedRenderables().poll().pick(drawContext, point);
        }
        object2 = drawContext.getPickedObjects();
        if (null != object2 && 0 < ((ArrayList)object2).size()) {
            int n;
            int[] nArray = new int[4];
            object = BufferUtil.newByteBuffer(3);
            GL gL = drawContext.getGL();
            gL.glGetIntegerv(2978, nArray, 0);
            gL.glReadPixels(point.x, nArray[3] - point.y, 1, 1, 6407, 5121, (Buffer)object);
            Color color = new Color(((ByteBuffer)object).get(0) & 0xFF, ((ByteBuffer)object).get(1) & 0xFF, ((ByteBuffer)object).get(2) & 0xFF, 0);
            if (null != color && 0 != (n = color.getRGB())) {
                Iterator iterator2 = ((ArrayList)object2).iterator();
                while (iterator2.hasNext()) {
                    PickedObject pickedObject = (PickedObject)iterator2.next();
                    if (null == pickedObject || pickedObject.getColorCode() != n) continue;
                    pickedObject.setOnTop();
                    break;
                }
            }
        }
    }

    public void finalizePicking(DrawContext drawContext) {
        if (null == drawContext) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    private void clearFrame(DrawContext drawContext) {
        Color color = drawContext.getClearColor();
        drawContext.getGL().glClearColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        drawContext.getGL().glClear(16640);
    }
}

