/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Globe;
import gov.nasa.worldwind.Layer;
import gov.nasa.worldwind.LayerList;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.Tessellator;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.globes.EllipsoidRectangularTessellator;
import java.util.logging.Level;

public class BasicModel
extends WWObjectImpl
implements Model {
    private Globe globe;
    private Tessellator tessellator;
    private LayerList layers;
    private boolean showWireframeInterior = false;
    private boolean showWireframeExterior = false;
    private boolean showTessellationBoundingVolumes = false;

    public BasicModel() {
        Globe globe = (Globe)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.GlobeClassName");
        this.setGlobe(globe);
        this.createLayers();
    }

    private void createLayers() {
        String[] stringArray;
        LayerList layerList = new LayerList();
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.LayersClassName", "gov.nasa.worldwind.layers.Earth.BMNGSurfaceLayer");
        if (string == null) {
            return;
        }
        for (String string2 : stringArray = string.split(",")) {
            try {
                if (string2.length() <= 0) continue;
                Layer layer = (Layer)WorldWind.createComponent(string2);
                layerList.add(layer);
            }
            catch (Exception exception) {
                String string3 = WorldWind.retrieveErrMsg("BasicModel.LayerNotFound") + string2;
                WorldWind.logger().log(Level.FINE, string3, exception);
            }
        }
        this.setLayers(layerList);
    }

    public void setGlobe(Globe globe) {
        if (this.globe != null) {
            this.globe.removePropertyChangeListener(this);
        }
        if (globe != null) {
            globe.addPropertyChangeListener(this);
        }
        Globe globe2 = this.globe;
        this.globe = globe;
        this.firePropertyChange("gov.nasa.worldwind.avkey.GlobeObject", globe2, this.globe);
    }

    public void setLayers(LayerList layerList) {
        if (this.layers != null) {
            this.layers.removePropertyChangeListener(this);
        }
        if (layerList != null) {
            layerList.addPropertyChangeListener(this);
        }
        LayerList layerList2 = this.layers;
        this.layers = layerList;
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", layerList2, this.layers);
    }

    public Globe getGlobe() {
        return this.globe;
    }

    public LayerList getLayers() {
        return this.layers;
    }

    public Tessellator getTessellator() {
        if (this.tessellator == null && this.globe != null) {
            this.tessellator = new EllipsoidRectangularTessellator(this.globe);
        }
        return this.tessellator;
    }

    public void setTessellator(Tessellator tessellator) {
        this.tessellator = tessellator;
    }

    public void setShowWireframeInterior(boolean bl) {
        this.showWireframeInterior = bl;
    }

    public void setShowWireframeExterior(boolean bl) {
        this.showWireframeExterior = bl;
    }

    public boolean isShowWireframeInterior() {
        return this.showWireframeInterior;
    }

    public boolean isShowWireframeExterior() {
        return this.showWireframeExterior;
    }

    public boolean isShowTessellationBoundingVolumes() {
        return this.showTessellationBoundingVolumes;
    }

    public void setShowTessellationBoundingVolumes(boolean bl) {
        this.showTessellationBoundingVolumes = bl;
    }

    public Extent getExtent() {
        Object object;
        Object object2;
        LayerList layerList = this.getLayers();
        if (layerList != null) {
            object2 = layerList.iterator();
            while (object2.hasNext()) {
                object = (Layer)object2.next();
                Extent extent = (Extent)object.getValue("gov.nasa.worldwind.avkey.Extent");
                if (extent == null) continue;
                return extent;
            }
        }
        if ((object2 = this.getGlobe()) != null && (object = object2.getExtent()) != null) {
            return object;
        }
        return null;
    }
}

