/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.AbstractView;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Globe;
import gov.nasa.worldwind.SectorGeometryList;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix4;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.ViewFrustum;
import java.awt.Rectangle;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;

public class BasicOrbitView
extends AbstractView {
    private static final Double DefaultLatitude;
    private static final Double DefaultLongitude;
    private static final Double DefaultZoom;
    private static final Double DefaultMinZoom;
    private static final Double DefaultMaxZoom;
    private static final Boolean DefaultEnableZoomConstraint;
    private static final Double DefaultHeading;
    private static final Double DefaultPitch;
    private static final Double DefaultMinPitch;
    private static final Double DefaultMaxPitch;
    private static final Boolean DefaultEnablePitchConstraint;
    private Angle focusLat = Angle.fromDegrees(DefaultLatitude);
    private Angle focusLon = Angle.fromDegrees(DefaultLongitude);
    private double eyeDist = DefaultZoom;
    private Angle heading = Angle.fromDegrees(DefaultHeading);
    private Angle pitch = Angle.fromDegrees(DefaultPitch);
    private double altitude;
    private double minEyeDist = DefaultMinZoom;
    private double maxEyeDist = DefaultMaxZoom;
    private boolean enableZoomConstraint = DefaultEnableZoomConstraint;
    private Angle minPitch = Angle.fromDegrees(DefaultMinPitch);
    private Angle maxPitch = Angle.fromDegrees(DefaultMaxPitch);
    private boolean enablePitchConstraint = DefaultEnablePitchConstraint;
    private ViewFrustum viewFrustum;
    private double collisionRadius;
    private boolean isInitialized = false;

    protected void doApply(DrawContext drawContext) {
        if (!this.isInitialized) {
            this.doInitialize(drawContext);
            this.isInitialized = true;
        }
        Matrix4 matrix4 = null;
        Matrix4 matrix42 = this.computeModelViewMatrix(drawContext);
        Point point = matrix42.getInverse().transform(new Point(0.0, 0.0, 0.0, 1.0));
        this.viewFrustum = this.computeViewFrustum(drawContext, point);
        if (this.viewFrustum != null) {
            this.collisionRadius = this.computeCollisionRadius(this.viewFrustum);
            matrix4 = this.viewFrustum.getProjectionMatrix();
        }
        this.applyMatrixState(drawContext, matrix42, matrix4);
    }

    private void doInitialize(DrawContext drawContext) {
        Globe globe = drawContext.getGlobe();
        this.collisionRadius = 1.0;
        this.minEyeDist = 1.0;
        this.maxEyeDist = globe != null ? 6.0 * globe.getRadius() : Double.POSITIVE_INFINITY;
        if (globe != null) {
            this.eyeDist = this.clampZoom(3.0 * globe.getRadius());
        }
    }

    private Matrix4 computeModelViewMatrix(DrawContext drawContext) {
        double d;
        Globe globe = drawContext.getGlobe();
        if (globe == null) {
            return null;
        }
        Point point = globe.computePointFromPosition(this.focusLat, this.focusLon, 0.0);
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("BasicOrbitView.NullSurfacePoint");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        Matrix4 matrix4 = BasicOrbitView.lookAt(this.focusLat, this.focusLon, point.length(), this.eyeDist, this.heading, this.pitch);
        Point point2 = matrix4.getInverse().transform(new Point(0.0, 0.0, 0.0, 1.0));
        Position position = globe.computePositionFromPoint(point2);
        Point point3 = BasicOrbitView.computeSurfacePoint(drawContext, position.getLatitude(), position.getLongitude());
        if (point3 != null && (d = point2.length() - this.collisionRadius - point3.length()) < 0.0) {
            Point point4;
            Point point5 = point2.normalize();
            Point point6 = Point.fromOriginAndDirection(point2.length() - d, point5, Point.ZERO);
            Point point7 = point2.subtract(point);
            double d2 = point7.dot(point4 = point6.subtract(point)) / (point7.length() * point4.length());
            if (d2 >= -1.0 && d2 <= 1.0) {
                double d3 = Math.acos(d2);
                this.pitch = this.clampPitch(this.pitch.subtract(Angle.fromRadians(d3)));
                this.eyeDist = this.clampZoom(point4.length());
                matrix4 = BasicOrbitView.lookAt(this.focusLat, this.focusLon, point.length(), this.eyeDist, this.heading, this.pitch);
            }
        }
        point2 = matrix4.getInverse().transform(new Point(0.0, 0.0, 0.0, 1.0));
        position = globe.computePositionFromPoint(point2);
        this.altitude = point2.length() - globe.getRadiusAt(position.getLatitude(), position.getLongitude());
        return matrix4;
    }

    private static Matrix4 lookAt(Angle angle, Angle angle2, double d, double d2, Angle angle3, Angle angle4) {
        Matrix4 matrix4 = new Matrix4();
        matrix4.translate(0.0, 0.0, -d2);
        matrix4.rotateX(angle4.multiply(-1.0));
        matrix4.rotateZ(angle3);
        matrix4.translate(0.0, 0.0, -d);
        matrix4.rotateX(angle);
        matrix4.rotateY(angle2.multiply(-1.0));
        return matrix4;
    }

    private static Point computeSurfacePoint(DrawContext drawContext, Angle angle, Angle angle2) {
        Point point = null;
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList != null) {
            point = sectorGeometryList.getSurfacePoint(angle, angle2);
        }
        if (point != null) {
            return point;
        }
        Globe globe = drawContext.getGlobe();
        if (globe != null) {
            double d = drawContext.getVerticalExaggeration() * globe.getElevation(angle, angle2);
            point = globe.computePointFromPosition(angle, angle2, d);
        }
        return point;
    }

    public Frustum getFrustum() {
        if (this.viewFrustum == null) {
            return null;
        }
        return this.viewFrustum.getFrustum();
    }

    private ViewFrustum computeViewFrustum(DrawContext drawContext, Point point) {
        Rectangle rectangle = this.getViewport();
        Angle angle = this.getFieldOfView();
        if (rectangle == null || angle == null) {
            return null;
        }
        double d = angle.tanHalfAngle();
        double d2 = Math.max(10.0, this.altitude / (2.0 * Math.sqrt(2.0 * d * d + 1.0)));
        double d3 = this.computeHorizonDistance(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), point);
        return new ViewFrustum(angle, rectangle.width, rectangle.height, d2, d3);
    }

    private double computeCollisionRadius(ViewFrustum viewFrustum) {
        Rectangle rectangle = this.getViewport();
        Angle angle = this.getFieldOfView();
        if (rectangle == null || angle == null || viewFrustum == null || viewFrustum.getFrustum() == null || viewFrustum.getFrustum().getNear() == null) {
            return 1.0;
        }
        double d = Math.abs(viewFrustum.getFrustum().getNear().getDistance());
        if (d == 0.0) {
            d = 1.0;
        }
        double d2 = angle.tanHalfAngle();
        double d3 = d * d2;
        double d4 = (double)rectangle.height * d3 / (double)rectangle.width;
        return 1.0 + Math.sqrt(d3 * d3 + d4 * d4 + d * d);
    }

    public Position getPosition() {
        return new Position(this.focusLat, this.focusLon, 0.0);
    }

    public void goToLatLon(LatLon latLon) {
        if (latLon == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatLonIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon2 = this.clampCoordinate(latLon);
        this.focusLat = latLon2.getLatitude();
        this.focusLon = latLon2.getLongitude();
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void goToAltitude(double d) {
        throw new UnsupportedOperationException();
    }

    public void goToCoordinate(LatLon latLon, double d) {
        throw new UnsupportedOperationException();
    }

    private LatLon clampCoordinate(LatLon latLon) {
        if (latLon == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatLonIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().getDegrees();
        if (d < -90.0) {
            d = -90.0;
        } else if (d > 90.0) {
            d = 90.0;
        }
        double d2 = latLon.getLongitude().getDegrees();
        if (d2 < -180.0) {
            d2 += 360.0;
        } else if (d2 > 180.0) {
            d2 -= 360.0;
        }
        return LatLon.fromDegrees(d, d2);
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.heading = this.clampHeading(angle);
    }

    private Angle clampHeading(Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.getDegrees();
        if (d < 0.0) {
            d += 360.0;
        } else if (d > 360.0) {
            d -= 360.0;
        }
        return Angle.fromDegrees(d);
    }

    public Angle getPitch() {
        return this.pitch;
    }

    public void setPitch(Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.pitch = this.clampPitch(angle);
    }

    public Angle[] getPitchConstraints() {
        return new Angle[]{this.minPitch, this.maxPitch};
    }

    public void setPitchConstraints(Angle angle, Angle angle2) {
        if (angle.compareTo(angle2) < 0) {
            String string = WorldWind.retrieveErrMsg("BasicOrbitView.InvalidConstraints");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.minPitch = angle;
        this.maxPitch = angle2;
    }

    public boolean isEnablePitchConstraints() {
        return this.enablePitchConstraint;
    }

    public void setEnablePitchConstraints(boolean bl) {
        this.enablePitchConstraint = bl;
    }

    private Angle clampPitch(Angle angle) {
        Angle[] angleArray = this.getPitchConstraints();
        if (angle.compareTo(angleArray[0]) < 0) {
            this.pitch = angleArray[0];
        } else if (angle.compareTo(angleArray[1]) > 0) {
            this.pitch = angleArray[1];
        }
        this.pitch = angle;
        return this.pitch;
    }

    public Angle getRoll() {
        return Angle.ZERO;
    }

    public void setRoll(Angle angle) {
    }

    public double getZoom() {
        return this.eyeDist;
    }

    public void setZoom(double d) {
        this.eyeDist = this.clampZoom(d);
    }

    public double[] getZoomConstraints() {
        return new double[]{Math.max(this.minEyeDist, this.collisionRadius), this.maxEyeDist};
    }

    public void setZoomConstraints(double d, double d2) {
        if (d < 0.0 || d > d2) {
            String string = WorldWind.retrieveErrMsg("BasicOrbitView.InvalidConstraints");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.minEyeDist = d;
        this.maxEyeDist = d2;
    }

    public boolean isEnableZoomConstraints() {
        return this.enableZoomConstraint;
    }

    public void setEnableZoomConstraints(boolean bl) {
        this.enableZoomConstraint = bl;
    }

    private double clampZoom(double d) {
        double d2 = d;
        double[] dArray = this.getZoomConstraints();
        if (d2 < dArray[0]) {
            d2 = dArray[0];
        } else if (d2 > dArray[1]) {
            d2 = dArray[1];
        }
        return d2;
    }

    public LatLon computeVisibleLatLonRange() {
        return null;
    }

    static {
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        DefaultLatitude = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialLatitude", 0.0);
        DefaultLongitude = Configuration.getDoubleValue("gov.nasa.worldwind.avkey.InitialLongitude", 180.0 * (double)timeZone.getOffset(System.currentTimeMillis()) / 4.32E7);
        DefaultZoom = 0.0;
        DefaultMinZoom = 0.0;
        DefaultMaxZoom = Double.POSITIVE_INFINITY;
        DefaultEnableZoomConstraint = Boolean.TRUE;
        DefaultHeading = 0.0;
        DefaultPitch = 0.0;
        DefaultMinPitch = 0.0;
        DefaultMaxPitch = 90.0;
        DefaultEnablePitchConstraint = Boolean.TRUE;
    }
}

