/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.WorldWind;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;

public class Configuration {
    private static final String CONFIG_FILE_NAME = "config/worldwind.properties";
    private static final String CONFIG_FILE_PROPERTY_KEY = "gov.nasa.worldwind.config.file";
    private static Configuration ourInstance = new Configuration();
    private Properties defaultSettings = new Properties();
    private Properties customSettings;

    private static Configuration getInstance() {
        return ourInstance;
    }

    private Configuration() {
        this.initializeDefaults();
        this.initializeCustom();
    }

    private void initializeDefaults() {
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.DataFileCacheClassName", "gov.nasa.worldwind.BasicDataFileCache");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.DataFileCacheConfigurationFileName", "config/DataFileCache.xml");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.FrameControllerClassName", "gov.nasa.worldwind.BasicFrameController");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.GlobeClassName", "gov.nasa.worldwind.globes.Earth");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.InputHandlerClassName", "gov.nasa.worldwind.awt.AWTInputHandler");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.LoggerName", "gov.nasa.worldwind");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.MemoryCacheClassName", "gov.nasa.worldwind.BasicMemoryCache");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.ModelClassName", "gov.nasa.worldwind.BasicModel");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.RetrievalServiceClassName", "gov.nasa.worldwind.BasicRetrievalService");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.SceneControllerClassName", "gov.nasa.worldwind.BasicSceneController");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.ThreadedTaskServiceClassName", "gov.nasa.worldwind.ThreadedTaskService");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.ViewClassName", "gov.nasa.worldwind.BasicOrbitView");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.LayersClassName", "gov.nasa.worldwind.layers.Earth.BMNGSurfaceLayer,gov.nasa.worldwind.layers.Earth.LandsatI3,gov.nasa.worldwind.layers.Earth.USGSUrbanAreaOrtho,gov.nasa.worldwind.layers.Earth.EarthNASAPlaceNameLayer,gov.nasa.worldwind.layers.CompassLayer");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.InitialLatitude", "0");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.RetrievalPoolSize", "5");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.RetrievalQueueSize", "200");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", "9000");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.ThreadedTaskPoolSize", "1");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.ThreadedTaskQueueSize", "5");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.VerticalExaggeration", "1");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.CacheSize", "2000000000");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.CacheLowWater", "140000000");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.URLConnectTimeout", "8000");
        this.defaultSettings.setProperty("gov.nasa.worldwind.avkey.URLReadTimeout", "5000");
    }

    private void initializeCustom() {
        this.customSettings = new Properties(this.defaultSettings);
        String string = System.getProperty(CONFIG_FILE_PROPERTY_KEY, CONFIG_FILE_NAME);
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
            if (inputStream == null) {
                File file = new File(string);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                } else {
                    String string2 = WorldWind.retrieveErrMsg("Configuration.UnavailablePropsFile" + string);
                    WorldWind.logger().log(Level.FINE, string2);
                }
            }
            if (inputStream != null) {
                this.customSettings.load(inputStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = WorldWind.retrieveErrMsg("Configuration.UnavailablePropsFile" + string);
            WorldWind.logger().log(Level.FINE, string3);
        }
        catch (IOException iOException) {
            String string4 = WorldWind.retrieveErrMsg("Configuration.ExceptionReadingPropsFile" + string);
            WorldWind.logger().log(Level.FINE, string4);
        }
        catch (Exception exception) {
            String string5 = WorldWind.retrieveErrMsg("Configuration.ExceptionReadingPropsFile" + string + " " + exception.getLocalizedMessage());
            WorldWind.logger().log(Level.FINE, string5, exception);
        }
    }

    public static String getStringValue(String string, String string2) {
        String string3 = Configuration.getStringValue(string);
        return string3 != null ? string3 : string2;
    }

    public static String getStringValue(String string) {
        return Configuration.getInstance().customSettings.getProperty(string);
    }

    public static Integer getIntegerValue(String string, Integer n) {
        Integer n2 = Configuration.getIntegerValue(string);
        return n2 != null ? n2 : n;
    }

    public static Integer getIntegerValue(String string) {
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = WorldWind.retrieveErrMsg("Configuration.ConversionError" + string2);
            WorldWind.logger().log(Level.FINE, string3);
            return null;
        }
    }

    public static Long getLongValue(String string, Long l) {
        Long l2 = Configuration.getLongValue(string);
        return l2 != null ? l2 : l;
    }

    public static Long getLongValue(String string) {
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = WorldWind.retrieveErrMsg("Configuration.ConversionError" + string2);
            WorldWind.logger().log(Level.FINE, string3);
            return null;
        }
    }

    public static Double getDoubleValue(String string, Double d) {
        Double d2 = Configuration.getDoubleValue(string);
        return d2 != null ? d2 : d;
    }

    public static Double getDoubleValue(String string) {
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = WorldWind.retrieveErrMsg("Configuration.ConversionError" + string2);
            WorldWind.logger().log(Level.FINE, string3);
            return null;
        }
    }

    public static boolean hasKey(String string) {
        return Configuration.getInstance().customSettings.contains(string);
    }

    public static void removeKey(String string) {
        Configuration.getInstance().customSettings.remove(string);
    }

    public static void setValue(String string, Object object) {
        Configuration.getInstance().customSettings.put(string, object.toString());
    }

    public static String currentWorkingDirectory() {
        String string = System.getProperty("user.dir");
        return string != null ? string : ".";
    }

    public static String getUserHomeDirectory() {
        String string = System.getProperty("user.home");
        return string != null ? string : ".";
    }

    public static String systemTempDirectory() {
        String string = System.getProperty("java.io.tmpdir");
        return string != null ? string : ".";
    }

    public static boolean isMacOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("mac");
    }

    public static boolean isWindowsOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("windows");
    }

    public static boolean isLinuxOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("linux");
    }

    public static boolean isUnixOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("unix");
    }

    public static boolean isSolarisOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("solaris");
    }
}

