/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.WWIO;
import gov.nasa.worldwind.WorldWind;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class DDSConverter {
    static final int DDSD_CAPS = 1;
    static final int DDSD_HEIGHT = 2;
    static final int DDSD_WIDTH = 4;
    static final int DDSD_PIXELFORMAT = 4096;
    static final int DDSD_MIPMAPCOUNT = 131072;
    static final int DDSD_LINEARSIZE = 524288;
    static final int DDPF_FOURCC = 4;
    static final int DDSCAPS_TEXTURE = 4096;

    public static ByteBuffer convertToDxt1NoTransparency(ByteBuffer byteBuffer, String string) throws IOException {
        if (byteBuffer == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.ByteBufferIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = WorldWind.retrieveErrMsg("nullValue.MimeTypeIsNull");
            WorldWind.logger().log(Level.FINE, string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = WWIO.getSuffixForMimeType(string);
        if (string4 == null) {
            String string5 = WorldWind.retrieveErrMsg("DDSConverter.UnsupportedMimeType") + string;
            WorldWind.logger().log(Level.FINE, string5);
            throw new IllegalArgumentException(string5);
        }
        File file = WWIO.saveBufferToTempFile(byteBuffer, string4);
        return DDSConverter.convertToDxt1NoTransparency(file);
    }

    public static ByteBuffer convertToDxt1NoTransparency(File file) throws IOException {
        if (file == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.FileIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists() || !file.canRead()) {
            String string = WorldWind.retrieveErrMsg("DDSConverter.NoFileOrNoPermission");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            return null;
        }
        int[] nArray = new int[16];
        int n = 128 + bufferedImage.getWidth() * bufferedImage.getHeight() / 2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DDSConverter.buildHeaderDxt1(byteBuffer, bufferedImage.getWidth(), bufferedImage.getHeight());
        int n2 = bufferedImage.getWidth() / 4;
        int n3 = bufferedImage.getHeight() / 4;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                BufferedImage bufferedImage2 = bufferedImage.getSubimage(j * 4, i * 4, 4, 4);
                bufferedImage2.getRGB(0, 0, 4, 4, nArray, 0, 4);
                Color[] colorArray = DDSConverter.getColors888(nArray);
                for (int k = 0; k < nArray.length; ++k) {
                    nArray[k] = DDSConverter.getPixel565(colorArray[k]);
                    colorArray[k] = DDSConverter.getColor565(nArray[k]);
                }
                int[] nArray2 = DDSConverter.determineExtremeColors(colorArray);
                if (nArray[nArray2[0]] < nArray[nArray2[1]]) {
                    int n4 = nArray2[0];
                    nArray2[0] = nArray2[1];
                    nArray2[1] = n4;
                }
                byteBuffer.putShort((short)nArray[nArray2[0]]);
                byteBuffer.putShort((short)nArray[nArray2[1]]);
                long l = DDSConverter.computeBitMask(colorArray, nArray2);
                byteBuffer.putInt((int)l);
            }
        }
        return byteBuffer;
    }

    public static ByteBuffer convertToDxt1WithTransparency(ByteBuffer byteBuffer, String string) throws IOException {
        if (byteBuffer == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.ByteBufferIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = WorldWind.retrieveErrMsg("nullValue.MimeTypeIsNull");
            WorldWind.logger().log(Level.FINE, string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = WWIO.getSuffixForMimeType(string);
        if (string4 == null) {
            String string5 = WorldWind.retrieveErrMsg("DDSConverter.UnsupportedMimeType") + string;
            WorldWind.logger().log(Level.FINE, string5);
            throw new IllegalArgumentException(string5);
        }
        File file = WWIO.saveBufferToTempFile(byteBuffer, string4);
        return DDSConverter.convertToDxt1WithTransparency(file);
    }

    public static ByteBuffer convertToDxt3(ByteBuffer byteBuffer, String string) throws IOException {
        if (byteBuffer == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.ByteBufferIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = WorldWind.retrieveErrMsg("nullValue.MimeTypeIsNull");
            WorldWind.logger().log(Level.FINE, string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = WWIO.getSuffixForMimeType(string);
        if (string4 == null) {
            String string5 = WorldWind.retrieveErrMsg("DDSConverter.UnsupportedMimeType") + string;
            WorldWind.logger().log(Level.FINE, string5);
            throw new IllegalArgumentException(string5);
        }
        File file = WWIO.saveBufferToTempFile(byteBuffer, string4);
        return DDSConverter.convertToDxt3(file);
    }

    public static ByteBuffer convertToDxt3(File file) throws IOException {
        if (file == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.FileIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists() || !file.canRead()) {
            String string = WorldWind.retrieveErrMsg("DDSConverter.NoFileOrNoPermission");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            return null;
        }
        int[] nArray = new int[16];
        int n = 128 + bufferedImage.getWidth() * bufferedImage.getHeight() / 2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n *= 2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DDSConverter.buildHeaderDxt3(byteBuffer, bufferedImage.getWidth(), bufferedImage.getHeight());
        int n2 = bufferedImage.getWidth() / 4;
        int n3 = bufferedImage.getHeight() / 4;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                long l = DDSConverter.makeAlphas(nArray);
                byteBuffer.putLong(l);
                BufferedImage bufferedImage2 = bufferedImage.getSubimage(j * 4, i * 4, 4, 4);
                bufferedImage2.getRGB(0, 0, 4, 4, nArray, 0, 4);
                Color[] colorArray = DDSConverter.getColors888(nArray);
                for (int k = 0; k < nArray.length; ++k) {
                    nArray[k] = DDSConverter.getPixel565(colorArray[k]);
                    colorArray[k] = DDSConverter.getColor565(nArray[k]);
                }
                int[] nArray2 = DDSConverter.determineExtremeColors(colorArray);
                if (nArray[nArray2[0]] < nArray[nArray2[1]]) {
                    int n4 = nArray2[0];
                    nArray2[0] = nArray2[1];
                    nArray2[1] = n4;
                }
                byteBuffer.putShort((short)nArray[nArray2[0]]);
                byteBuffer.putShort((short)nArray[nArray2[1]]);
                long l2 = DDSConverter.computeBitMask(colorArray, nArray2);
                byteBuffer.putInt((int)l2);
            }
        }
        return byteBuffer;
    }

    private static long makeAlphas(int[] nArray) {
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            l |= (long)((nArray[i] & 0xC0000000) >> i * 2);
        }
        return l;
    }

    protected static void buildHeaderDxt1(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.rewind();
        byteBuffer.put((byte)68);
        byteBuffer.put((byte)68);
        byteBuffer.put((byte)83);
        byteBuffer.put((byte)32);
        byteBuffer.putInt(124);
        int n3 = 659463;
        byteBuffer.putInt(n3);
        byteBuffer.putInt(n2);
        byteBuffer.putInt(n);
        byteBuffer.putInt(n * n2 / 2);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.position(byteBuffer.position() + 44);
        byteBuffer.putInt(32);
        byteBuffer.putInt(4);
        byteBuffer.put((byte)68);
        byteBuffer.put((byte)88);
        byteBuffer.put((byte)84);
        byteBuffer.put((byte)49);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(4096);
        byteBuffer.putInt(0);
        byteBuffer.position(byteBuffer.position() + 12);
    }

    protected static void buildHeaderDxt3(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.rewind();
        byteBuffer.put((byte)68);
        byteBuffer.put((byte)68);
        byteBuffer.put((byte)83);
        byteBuffer.put((byte)32);
        byteBuffer.putInt(124);
        int n3 = 659463;
        byteBuffer.putInt(n3);
        byteBuffer.putInt(n2);
        byteBuffer.putInt(n);
        byteBuffer.putInt(n * n2 / 2);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.position(byteBuffer.position() + 44);
        byteBuffer.putInt(32);
        byteBuffer.putInt(4);
        byteBuffer.put((byte)68);
        byteBuffer.put((byte)88);
        byteBuffer.put((byte)84);
        byteBuffer.put((byte)51);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(4096);
        byteBuffer.putInt(0);
        byteBuffer.position(byteBuffer.position() + 12);
    }

    protected static int[] determineExtremeColors(Color[] colorArray) {
        int n = Integer.MIN_VALUE;
        int[] nArray = new int[2];
        for (int i = 0; i < colorArray.length - 1; ++i) {
            for (int j = i + 1; j < colorArray.length; ++j) {
                int n2 = DDSConverter.distance(colorArray[i], colorArray[j]);
                if (n2 <= n) continue;
                n = n2;
                nArray[0] = i;
                nArray[1] = j;
            }
        }
        return nArray;
    }

    protected static long computeBitMask(Color[] colorArray, int[] nArray) {
        Color[] colorArray2 = new Color[]{null, null, new Color(), new Color()};
        colorArray2[0] = colorArray[nArray[0]];
        colorArray2[1] = colorArray[nArray[1]];
        if (colorArray2[0].equals(colorArray2[1])) {
            return 0L;
        }
        colorArray2[2].r = (2 * colorArray2[0].r + colorArray2[1].r + 1) / 3;
        colorArray2[2].g = (2 * colorArray2[0].g + colorArray2[1].g + 1) / 3;
        colorArray2[2].b = (2 * colorArray2[0].b + colorArray2[1].b + 1) / 3;
        colorArray2[3].r = (colorArray2[0].r + 2 * colorArray2[1].r + 1) / 3;
        colorArray2[3].g = (colorArray2[0].g + 2 * colorArray2[1].g + 1) / 3;
        colorArray2[3].b = (colorArray2[0].b + 2 * colorArray2[1].b + 1) / 3;
        long l = 0L;
        for (int i = 0; i < colorArray.length; ++i) {
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            for (int j = 0; j < colorArray2.length; ++j) {
                int n3 = DDSConverter.distance(colorArray[i], colorArray2[j]);
                if (n3 >= n) continue;
                n = n3;
                n2 = j;
            }
            l |= (long)(n2 << i * 2);
        }
        return l;
    }

    protected static int getPixel565(Color color) {
        int n = color.r >> 3;
        int n2 = color.g >> 2;
        int n3 = color.b >> 3;
        return n << 11 | n2 << 5 | n3;
    }

    protected static Color getColor565(int n) {
        Color color = new Color();
        color.r = (int)((long)n & 0xF800L) >> 11;
        color.g = (int)((long)n & 0x7E0L) >> 5;
        color.b = (int)((long)n & 0x1FL);
        return color;
    }

    protected static Color getColor888(int n) {
        return new Color((int)((long)n & 0xFF0000L) >> 16, (int)((long)n & 0xFF00L) >> 8, (int)((long)n & 0xFFL));
    }

    protected static Color[] getColors888(int[] nArray) {
        Color[] colorArray = new Color[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            colorArray[i] = new Color();
            colorArray[i].r = (int)((long)nArray[i] & 0xFF0000L) >> 16;
            colorArray[i].g = (int)((long)nArray[i] & 0xFF00L) >> 8;
            colorArray[i].b = (int)((long)nArray[i] & 0xFFL);
        }
        return colorArray;
    }

    protected static int distance(Color color, Color color2) {
        return (color2.r - color.r) * (color2.r - color.r) + (color2.g - color.g) * (color2.g - color.g) + (color2.b - color.b) * (color2.b - color.b);
    }

    public static ByteBuffer convertToDxt1WithTransparency(File file) throws IOException {
        if (file == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.FileIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists() || !file.canRead()) {
            String string = WorldWind.retrieveErrMsg("DDSConverter.NoFileOrNoPermission");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            return null;
        }
        int[] nArray = new int[16];
        int n = 128 + bufferedImage.getWidth() * bufferedImage.getHeight() / 2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        DDSConverter.buildHeaderDxt1(byteBuffer, bufferedImage.getWidth(), bufferedImage.getHeight());
        int n2 = bufferedImage.getWidth() / 4;
        int n3 = bufferedImage.getHeight() / 4;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                BufferedImage bufferedImage2 = bufferedImage.getSubimage(j * 4, i * 4, 4, 4);
                bufferedImage2.getRGB(0, 0, 4, 4, nArray, 0, 4);
                TransparentColor[] transparentColorArray = DDSConverter.getColors5551(nArray);
                int[] nArray2 = DDSConverter.determineExtremeColors(transparentColorArray);
                short s = DDSConverter.getShort5551(transparentColorArray[nArray2[0]]);
                short s2 = DDSConverter.getShort5551(transparentColorArray[nArray2[1]]);
                if (s > s2) {
                    int n4 = nArray2[0];
                    nArray2[0] = nArray2[1];
                    nArray2[1] = n4;
                    short s3 = s;
                    s = s2;
                    s2 = s3;
                } else if (s == s2) {
                    DDSConverter.equalTransparentCase(transparentColorArray, nArray2, s);
                    s = DDSConverter.getShort5551(transparentColorArray[nArray2[0]]);
                    s2 = DDSConverter.getShort5551(transparentColorArray[nArray2[1]]);
                }
                byteBuffer.putShort(s);
                byteBuffer.putShort(s2);
                long l = DDSConverter.computeBitMask(transparentColorArray, nArray2);
                byteBuffer.putInt((int)l);
            }
        }
        return byteBuffer;
    }

    protected static void equalTransparentCase(TransparentColor[] transparentColorArray, int[] nArray, short s) {
        if (s == 0) {
            transparentColorArray[nArray[0]] = TransparentColor.OFF_TRANSPARENT;
        }
    }

    protected static int distance(TransparentColor transparentColor, TransparentColor transparentColor2) {
        return (transparentColor2.r - transparentColor.r) * (transparentColor2.r - transparentColor.r) + (transparentColor2.g - transparentColor.g) * (transparentColor2.g - transparentColor.g) + (transparentColor2.b - transparentColor.b) * (transparentColor2.b - transparentColor.b) + (transparentColor2.a - transparentColor.a) * (transparentColor2.a - transparentColor.a);
    }

    protected static long computeBitMask(TransparentColor[] transparentColorArray, int[] nArray) {
        TransparentColor[] transparentColorArray2 = new TransparentColor[]{null, null, new TransparentColor(), new TransparentColor()};
        transparentColorArray2[0] = transparentColorArray[nArray[0]];
        transparentColorArray2[1] = transparentColorArray[nArray[1]];
        transparentColorArray2[2].r = (byte)((transparentColorArray2[0].r + transparentColorArray2[1].r) / 2);
        transparentColorArray2[2].g = (byte)((transparentColorArray2[0].g + transparentColorArray2[1].g) / 2);
        transparentColorArray2[2].b = (byte)((transparentColorArray2[0].b + transparentColorArray2[1].b) / 2);
        transparentColorArray2[2].a = (byte)1;
        transparentColorArray2[3].r = (byte)0;
        transparentColorArray2[3].g = (byte)0;
        transparentColorArray2[3].b = (byte)0;
        transparentColorArray2[3].a = (byte)0;
        long l = 0L;
        for (int i = 0; i < transparentColorArray.length; ++i) {
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            if (transparentColorArray[i].a == 0) {
                n2 = 3;
            } else {
                for (int j = 0; j < transparentColorArray2.length; ++j) {
                    int n3 = DDSConverter.distance(transparentColorArray[i], transparentColorArray2[j]);
                    if (n3 >= n) continue;
                    n = n3;
                    n2 = j;
                }
            }
            l |= (long)(n2 << i * 2);
        }
        return l;
    }

    protected static short getShort5551(TransparentColor transparentColor) {
        short s = 0;
        s = (short)(s | ((transparentColor.r & 0xF8) << 8 | (transparentColor.g & 0xF8) << 4 | (transparentColor.b & 0xF8) >> 3 | (transparentColor.a & 0xF8) >> 7));
        return s;
    }

    protected static int[] determineExtremeColors(TransparentColor[] transparentColorArray) {
        int n = Integer.MIN_VALUE;
        int[] nArray = new int[]{0, 0};
        for (int i = 0; i < transparentColorArray.length - 1; ++i) {
            for (int j = i + 1; j < transparentColorArray.length; ++j) {
                int n2 = DDSConverter.distance(transparentColorArray[i], transparentColorArray[j]);
                if (n2 <= n) continue;
                n = n2;
                nArray[0] = i;
                nArray[1] = j;
            }
        }
        return nArray;
    }

    protected static TransparentColor[] getColors5551(int[] nArray) {
        TransparentColor[] transparentColorArray = new TransparentColor[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            transparentColorArray[i] = DDSConverter.generateColor5551(nArray[i]);
        }
        return transparentColorArray;
    }

    protected static TransparentColor generateColor5551(int n) {
        short s = (short)(n >> 24);
        if ((s & 0xF0) == 0) {
            return TransparentColor.TRANSPARENT;
        }
        TransparentColor transparentColor = new TransparentColor();
        transparentColor.a = (byte)-1;
        transparentColor.r = (byte)((n & 0xFF0000) >> 16);
        transparentColor.g = (byte)((n & 0xFF00) >> 8);
        transparentColor.b = (byte)(n & 0xFF);
        return transparentColor;
    }

    protected static class TransparentColor {
        private static final TransparentColor TRANSPARENT = new TransparentColor(0, 0, 0, 0);
        private static final TransparentColor OFF_TRANSPARENT = new TransparentColor(0, 0, 1, 0);
        private byte r;
        private byte g;
        private byte b;
        private byte a;

        private TransparentColor() {
        }

        private TransparentColor(byte by, byte by2, byte by3, byte by4) {
            this.r = by;
            this.g = by2;
            this.b = by3;
            this.a = by4;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TransparentColor transparentColor = (TransparentColor)object;
            if (this.a != transparentColor.a) {
                return false;
            }
            if (this.b != transparentColor.b) {
                return false;
            }
            if (this.g != transparentColor.g) {
                return false;
            }
            return this.r == transparentColor.r;
        }

        public int hashCode() {
            int n = this.r;
            n = 29 * n + this.g;
            n = 29 * n + this.b;
            n = 29 * n + this.a;
            return n;
        }

        public String toString() {
            return "TransColor argb: " + this.a + ", " + this.r + ", " + this.g + ", " + this.b;
        }
    }

    protected static class Color {
        private int r;
        private int g;
        private int b;

        public Color() {
            this.b = 0;
            this.g = 0;
            this.r = 0;
        }

        public Color(int n, int n2, int n3) {
            this.r = n;
            this.g = n2;
            this.b = n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Color color = (Color)object;
            if (this.b != color.b) {
                return false;
            }
            if (this.g != color.g) {
                return false;
            }
            return this.r == color.r;
        }

        public int hashCode() {
            int n = this.r;
            n = 29 * n + this.g;
            n = 29 * n + this.b;
            return n;
        }
    }
}

