/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import com.sun.opengl.util.texture.TextureCoords;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Globe;
import gov.nasa.worldwind.LayerList;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.OrderedRenderable;
import gov.nasa.worldwind.PickedObject;
import gov.nasa.worldwind.PickedObjectList;
import gov.nasa.worldwind.SectorGeometryList;
import gov.nasa.worldwind.SurfaceTileRenderer;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Sector;
import java.awt.Color;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawContextImpl
extends WWObjectImpl
implements DrawContext {
    private GLContext glContext;
    private GLU glu = new GLU();
    private View view;
    private Model model;
    private Globe globe;
    private double verticalExaggeration = 1.0;
    private Sector visibleSector;
    private SectorGeometryList surfaceGeometry;
    private PickedObjectList pickedObjects = new PickedObjectList();
    private int uniquePickNumber = 0;
    private Color clearColor = new Color(0, 0, 0, 0);
    private boolean isPickingMode = false;
    private int numTextureUnits = -1;
    private SurfaceTileRenderer surfaceTileRenderer = new SurfaceTileRenderer();
    PriorityQueue<OrderedRenderable> orderedRenderables = new PriorityQueue<OrderedRenderable>(100, new Comparator<OrderedRenderable>(){

        @Override
        public int compare(OrderedRenderable orderedRenderable, OrderedRenderable orderedRenderable2) {
            double d;
            double d2 = orderedRenderable.getDistanceFromEye();
            return d2 > (d = orderedRenderable2.getDistanceFromEye()) ? -1 : (d2 == d ? 0 : 1);
        }
    });

    @Override
    public final GL getGL() {
        return this.getGLContext().getGL();
    }

    @Override
    public final GLU getGLU() {
        return this.glu;
    }

    @Override
    public final GLContext getGLContext() {
        return this.glContext;
    }

    @Override
    public final int getDrawableHeight() {
        return this.getGLDrawable().getHeight();
    }

    @Override
    public final int getDrawableWidth() {
        return this.getGLDrawable().getWidth();
    }

    @Override
    public final GLDrawable getGLDrawable() {
        return this.getGLContext().getGLDrawable();
    }

    @Override
    public final void initialize(GLContext gLContext) {
        if (gLContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.GLContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.glContext = gLContext;
        if (!this.isPickingMode()) {
            this.visibleSector = null;
            if (this.surfaceGeometry != null) {
                this.surfaceGeometry.clear();
            }
            this.surfaceGeometry = null;
        }
        this.pickedObjects.clear();
        this.orderedRenderables.clear();
        this.uniquePickNumber = 0;
        if (this.numTextureUnits < 1) {
            this.numTextureUnits = DrawContextImpl.queryMaxTextureUnits(gLContext);
        }
    }

    private static int queryMaxTextureUnits(GLContext gLContext) {
        int[] nArray = new int[1];
        gLContext.getGL().glGetIntegerv(34018, nArray, 0);
        return nArray[0];
    }

    @Override
    public final void setModel(Model model) {
        this.model = model;
        if (this.model == null) {
            return;
        }
        Globe globe = this.model.getGlobe();
        if (globe != null) {
            this.globe = globe;
        }
    }

    @Override
    public final Model getModel() {
        return this.model;
    }

    @Override
    public final LayerList getLayers() {
        return this.model.getLayers();
    }

    @Override
    public final Sector getVisibleSector() {
        return this.visibleSector;
    }

    @Override
    public final void setVisibleSector(Sector sector) {
        this.visibleSector = sector;
    }

    @Override
    public void setSurfaceGeometry(SectorGeometryList sectorGeometryList) {
        this.surfaceGeometry = sectorGeometryList;
    }

    @Override
    public SectorGeometryList getSurfaceGeometry() {
        return this.surfaceGeometry;
    }

    @Override
    public final Globe getGlobe() {
        return this.globe != null ? this.globe : this.model.getGlobe();
    }

    @Override
    public final void setView(View view) {
        this.view = view;
    }

    @Override
    public final View getView() {
        return this.view;
    }

    @Override
    public final void setGLContext(GLContext gLContext) {
        if (gLContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.GLContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.glContext = gLContext;
    }

    @Override
    public final double getVerticalExaggeration() {
        return this.verticalExaggeration;
    }

    @Override
    public final void setVerticalExaggeration(double d) {
        this.verticalExaggeration = d;
    }

    @Override
    public void addPickedObjects(PickedObjectList pickedObjectList) {
        if (pickedObjectList == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PickedObjectList");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.pickedObjects == null) {
            this.pickedObjects = pickedObjectList;
            return;
        }
        for (PickedObject pickedObject : pickedObjectList) {
            this.pickedObjects.add(pickedObject);
        }
    }

    @Override
    public void addPickedObject(PickedObject pickedObject) {
        if (null == pickedObject) {
            String string = WorldWind.retrieveErrMsg("nullValue.PickedObject");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (null == this.pickedObjects) {
            this.pickedObjects = new PickedObjectList();
        }
        this.pickedObjects.add(pickedObject);
    }

    @Override
    public PickedObjectList getPickedObjects() {
        return this.pickedObjects;
    }

    @Override
    public Color getUniquePickColor() {
        ++this.uniquePickNumber;
        int n = this.getClearColor().getRGB();
        if (n == this.uniquePickNumber) {
            ++this.uniquePickNumber;
        }
        if (this.uniquePickNumber >= 0xFFFFFF) {
            this.uniquePickNumber = 1;
            if (n == this.uniquePickNumber) {
                ++this.uniquePickNumber;
            }
        }
        return new Color(this.uniquePickNumber, true);
    }

    @Override
    public Color getClearColor() {
        return this.clearColor;
    }

    @Override
    public boolean isPickingMode() {
        return this.isPickingMode;
    }

    @Override
    public void enablePickingMode() {
        this.isPickingMode = true;
    }

    @Override
    public void disablePickingMode() {
        this.isPickingMode = false;
    }

    @Override
    public void addOrderedRenderable(OrderedRenderable orderedRenderable) {
        if (null == orderedRenderable) {
            String string = WorldWind.retrieveErrMsg("nullValue.OrderedRenderable");
            WorldWind.logger().log(Level.FINE, string);
            return;
        }
        this.orderedRenderables.add(orderedRenderable);
    }

    @Override
    public Queue<OrderedRenderable> getOrderedRenderables() {
        return this.orderedRenderables;
    }

    @Override
    public void drawUnitQuad() {
        GL gL = this.getGL();
        gL.glBegin(7);
        gL.glVertex2d(0.0, 0.0);
        gL.glVertex2d(1.0, 0.0);
        gL.glVertex2d(1.0, 1.0);
        gL.glVertex2d(0.0, 1.0);
        gL.glEnd();
    }

    @Override
    public void drawUnitQuad(TextureCoords textureCoords) {
        GL gL = this.getGL();
        gL.glBegin(7);
        gL.glTexCoord2d(textureCoords.left(), textureCoords.bottom());
        gL.glVertex2d(0.0, 0.0);
        gL.glTexCoord2d(textureCoords.right(), textureCoords.bottom());
        gL.glVertex2d(1.0, 0.0);
        gL.glTexCoord2d(textureCoords.right(), textureCoords.top());
        gL.glVertex2d(1.0, 1.0);
        gL.glTexCoord2d(textureCoords.left(), textureCoords.top());
        gL.glVertex2d(0.0, 1.0);
        gL.glEnd();
    }

    @Override
    public int getNumTextureUnits() {
        return this.numTextureUnits;
    }

    @Override
    public void setNumTextureUnits(int n) {
        this.numTextureUnits = n;
    }

    @Override
    public Point getPointOnGlobe(Angle angle, Angle angle2) {
        Point point;
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatitudeOrLongitudeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (!this.getVisibleSector().contains(angle, angle2)) {
            return null;
        }
        SectorGeometryList sectorGeometryList = this.getSurfaceGeometry();
        if (sectorGeometryList != null && (point = sectorGeometryList.getSurfacePoint(angle, angle2)) != null) {
            return point;
        }
        return null;
    }

    @Override
    public SurfaceTileRenderer getSurfaceTileRenderer() {
        return this.surfaceTileRenderer;
    }
}

