/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.RetrievalPostProcessor;
import gov.nasa.worldwind.URLRetriever;
import gov.nasa.worldwind.WorldWind;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class HTTPRetriever
extends URLRetriever {
    private int responseCode;
    private String responseMessage;

    public HTTPRetriever(URL uRL, RetrievalPostProcessor retrievalPostProcessor) {
        super(uRL, retrievalPostProcessor);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    protected ByteBuffer doRead(URLConnection uRLConnection) throws Exception {
        if (uRLConnection == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ConnectionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        this.responseCode = httpURLConnection.getResponseCode();
        this.responseMessage = httpURLConnection.getResponseMessage();
        String string = uRLConnection.getContentType();
        WorldWind.logger().log(Level.FINER, WorldWind.retrieveErrMsg("HTTPRetriever.ResponseCode") + this.responseCode + WorldWind.retrieveErrMsg("HTTPRetriever.ResponseContentLength") + uRLConnection.getContentLength() + (string != null ? " " + string : " content type not returned") + WorldWind.retrieveErrMsg("HTTPRetriever.Retrieving") + uRLConnection.getURL());
        if (this.responseCode == 200) {
            return super.doRead(uRLConnection);
        }
        return null;
    }
}

