/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import com.sun.opengl.util.j2d.TextRenderer;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Layer;
import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.OrderedRenderable;
import gov.nasa.worldwind.Pedestal;
import gov.nasa.worldwind.PickSupport;
import gov.nasa.worldwind.SectorGeometryList;
import gov.nasa.worldwind.ToolTipRenderer;
import gov.nasa.worldwind.WWIcon;
import gov.nasa.worldwind.WWRuntimeException;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Position;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconRenderer
implements Disposable {
    private HashMap<String, Texture> iconTextures = new HashMap();
    private Pedestal pedestal;
    private PickSupport pickSupport = new PickSupport();
    private HashMap<Font, ToolTipRenderer> toolTipRenderers = new HashMap();

    @Override
    public void dispose() {
        for (Texture texture : this.iconTextures.values()) {
            if (texture == null) continue;
            texture.dispose();
        }
    }

    public Pedestal getPedestal() {
        return this.pedestal;
    }

    public void setPedestal(Pedestal pedestal) {
        this.pedestal = pedestal;
    }

    private static boolean isIconValid(WWIcon wWIcon, boolean bl) {
        if (wWIcon == null || wWIcon.getPath() == null) {
            return false;
        }
        return !bl || wWIcon.getPosition() != null;
    }

    public void pick(DrawContext drawContext, Iterator<WWIcon> iterator, java.awt.Point point, Layer layer) {
        this.drawMany(drawContext, iterator);
    }

    public void pick(DrawContext drawContext, WWIcon wWIcon, Point point, java.awt.Point point2, Layer layer) {
        if (!IconRenderer.isIconValid(wWIcon, false)) {
            return;
        }
        this.drawOne(drawContext, wWIcon, point);
    }

    public void render(DrawContext drawContext, Iterator<WWIcon> iterator) {
        this.drawMany(drawContext, iterator);
    }

    public void render(DrawContext drawContext, WWIcon wWIcon, Point point) {
        if (!IconRenderer.isIconValid(wWIcon, false)) {
            return;
        }
        this.drawOne(drawContext, wWIcon, point);
    }

    private void drawMany(DrawContext drawContext, Iterator<WWIcon> iterator) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (iterator == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.IconIterator");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            WWIcon wWIcon = iterator.next();
            if (!IconRenderer.isIconValid(wWIcon, true) || !wWIcon.isVisible()) continue;
            Position position = wWIcon.getPosition();
            Point point = null;
            if (position.getElevation() < drawContext.getGlobe().getMaxElevation()) {
                point = drawContext.getSurfaceGeometry().getSurfacePoint(wWIcon.getPosition());
            }
            if (point == null) {
                point = drawContext.getGlobe().computePointFromPosition(wWIcon.getPosition());
            }
            double d = drawContext.getView().getEyePoint().distanceTo(point);
            drawContext.addOrderedRenderable(new OrderedIcon(wWIcon, point, d));
            if (!wWIcon.isShowToolTip()) continue;
            this.addToolTip(drawContext, wWIcon, point);
        }
    }

    private void drawOne(DrawContext drawContext, WWIcon wWIcon, Point point) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (!wWIcon.isVisible()) {
            return;
        }
        if (point == null) {
            Angle angle = wWIcon.getPosition().getLatitude();
            Angle angle2 = wWIcon.getPosition().getLongitude();
            if (!drawContext.getVisibleSector().contains(angle, angle2)) {
                return;
            }
            point = drawContext.getSurfaceGeometry().getSurfacePoint(angle, angle2, wWIcon.getPosition().getElevation());
            if (point == null) {
                return;
            }
        }
        if (!drawContext.getView().getFrustumInModelCoordinates().contains(point)) {
            return;
        }
        double d = drawContext.getView().computeHorizonDistance();
        double d2 = drawContext.getView().getEyePoint().distanceTo(point);
        if (d2 > d) {
            return;
        }
        drawContext.addOrderedRenderable(new OrderedIcon(wWIcon, point, d2));
        if (wWIcon.isShowToolTip()) {
            this.addToolTip(drawContext, wWIcon, point);
        }
    }

    private void addToolTip(DrawContext drawContext, WWIcon wWIcon, Point point) {
        if (wWIcon.getToolTipFont() == null && wWIcon.getToolTipText() == null) {
            return;
        }
        Point point2 = drawContext.getView().project(point);
        if (point2 == null) {
            return;
        }
        OrderedText orderedText = new OrderedText(wWIcon.getToolTipText(), wWIcon.getToolTipFont(), point2, wWIcon.getToolTipTextColor(), 0.0);
        drawContext.addOrderedRenderable(orderedText);
    }

    private void beginDrawIcons(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        int n = 293121;
        gL.glPushAttrib(n);
        gL.glEnable(2929);
        gL.glDepthMask(false);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.001f);
        int[] nArray = new int[4];
        gL.glGetIntegerv(2978, nArray, 0);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glOrtho(0.0, nArray[2], 0.0, nArray[3], -1.0, 1.0);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glMatrixMode(5890);
        gL.glPushMatrix();
        if (drawContext.isPickingMode()) {
            this.pickSupport.beginPicking(drawContext);
            gL.glEnable(3553);
            gL.glTexEnvf(8960, 8704, 34160.0f);
            gL.glTexEnvf(8960, 34176, 34168.0f);
            gL.glTexEnvf(8960, 34161, 7681.0f);
        } else {
            gL.glEnable(3553);
            gL.glEnable(3042);
            gL.glBlendFunc(1, 771);
        }
    }

    private void endDrawIcons(DrawContext drawContext) {
        if (drawContext.isPickingMode()) {
            this.pickSupport.endPicking(drawContext);
        }
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    private Point drawIcon(DrawContext drawContext, OrderedIcon orderedIcon) {
        double d;
        double d2;
        if (orderedIcon.point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            return null;
        }
        WWIcon wWIcon = orderedIcon.icon;
        Point point = drawContext.getView().project(orderedIcon.point);
        if (point == null) {
            return null;
        }
        Texture texture = this.iconTextures.get(wWIcon.getPath());
        if (texture == null) {
            texture = this.initializeTexture(drawContext, wWIcon);
        }
        Texture texture2 = null;
        if (this.pedestal != null) {
            d2 = this.pedestal.getScale();
            d = this.pedestal.getSpacingPixels();
            texture2 = this.iconTextures.get(this.pedestal.getPath());
            if (texture2 == null) {
                texture2 = this.initializeTexture(drawContext, this.pedestal);
            }
        } else {
            d2 = 0.0;
            d = 0.0;
        }
        GL gL = drawContext.getGL();
        this.setDepthFunc(drawContext, point);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        Dimension dimension = wWIcon.getSize();
        double d3 = dimension != null ? dimension.getWidth() : (double)texture.getWidth();
        double d4 = dimension != null ? dimension.getHeight() : (double)texture.getHeight();
        gL.glTranslated(point.x() - d3 / 2.0, point.y() + d2 * d4 + d, 0.0);
        if (wWIcon.isHighlighted()) {
            double d5 = this.pedestal != null ? 0.0 : d4 / 2.0;
            gL.glTranslated(d3 / 2.0, d5, 0.0);
            gL.glScaled(wWIcon.getHighlightScale(), wWIcon.getHighlightScale(), wWIcon.getHighlightScale());
            gL.glTranslated(-d3 / 2.0, -d5, 0.0);
        }
        if (drawContext.isPickingMode()) {
            Color color = drawContext.getUniquePickColor();
            int n = color.getRGB();
            this.pickSupport.addPickableObject(n, wWIcon, orderedIcon.getPosition(), false);
            gL.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        }
        texture.bind();
        TextureCoords textureCoords = texture.getImageTexCoords();
        gL.glScaled(d3, d4, 1.0);
        drawContext.drawUnitQuad(textureCoords);
        if (texture2 != null) {
            gL.glLoadIdentity();
            gL.glTranslated(point.x() - d2 * (d3 / 2.0), point.y(), 0.0);
            gL.glScaled(d3 * d2, d4 * d2, 1.0);
            texture2.bind();
            textureCoords = texture2.getImageTexCoords();
            drawContext.drawUnitQuad(textureCoords);
        }
        return point;
    }

    private void setDepthFunc(DrawContext drawContext, Point point) {
        GL gL = drawContext.getGL();
        if (drawContext.getView().getAltitude() < drawContext.getGlobe().getMaxElevation() * drawContext.getVerticalExaggeration()) {
            double d = point.z() - 0.00391006472;
            d = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
            gL.glDepthFunc(513);
            gL.glDepthRange(d, d);
        } else if (point.z() >= 1.0) {
            gL.glDepthFunc(514);
            gL.glDepthRange(1.0, 1.0);
        } else {
            gL.glDepthFunc(519);
        }
    }

    private Texture initializeTexture(DrawContext drawContext, WWIcon wWIcon) {
        try {
            Object object;
            InputStream inputStream = this.getClass().getResourceAsStream("/" + wWIcon.getPath());
            if (inputStream == null && ((File)(object = new File(wWIcon.getPath()))).exists()) {
                inputStream = new FileInputStream((File)object);
            }
            object = TextureIO.newTexture(inputStream, true, null);
            this.iconTextures.put(wWIcon.getPath(), (Texture)object);
            ((Texture)object).bind();
            GL gL = drawContext.getGL();
            gL.glTexEnvf(8960, 8704, 8448.0f);
            gL.glTexParameteri(3553, 10241, 9987);
            gL.glTexParameteri(3553, 10240, 9729);
            gL.glTexParameteri(3553, 10242, 33071);
            gL.glTexParameteri(3553, 10243, 33071);
            return object;
        }
        catch (IOException iOException) {
            String string = WorldWind.retrieveErrMsg("generic.IOExceptionDuringTextureInitialization");
            WorldWind.logger().log(Level.FINE, string, iOException);
            throw new WWRuntimeException(string, iOException);
        }
    }

    public String toString() {
        return WorldWind.retrieveErrMsg("layers.IconLayer.Name");
    }

    private class OrderedIcon
    implements OrderedRenderable,
    Locatable {
        WWIcon icon;
        Point point;
        double eyeDistance;
        java.awt.Point pickPoint;
        Layer layer;

        OrderedIcon(WWIcon wWIcon, Point point, double d) {
            this.icon = wWIcon;
            this.point = point;
            this.eyeDistance = d;
        }

        OrderedIcon(WWIcon wWIcon, Point point, java.awt.Point point2, Layer layer, double d) {
            this.icon = wWIcon;
            this.point = point;
            this.eyeDistance = d;
            this.pickPoint = point2;
            this.layer = layer;
        }

        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        public Position getPosition() {
            return this.icon.getPosition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render(DrawContext drawContext) {
            IconRenderer.this.beginDrawIcons(drawContext);
            try {
                IconRenderer.this.drawIcon(drawContext, this);
                while (drawContext.getOrderedRenderables().peek() instanceof OrderedIcon) {
                    OrderedIcon orderedIcon = (OrderedIcon)drawContext.getOrderedRenderables().poll();
                    IconRenderer.this.drawIcon(drawContext, orderedIcon);
                }
            }
            catch (WWRuntimeException wWRuntimeException) {
                String string = WorldWind.retrieveErrMsg("generic.ExceptionWhileRenderingIcon");
                WorldWind.logger().log(Level.FINE, string + ":" + wWRuntimeException.getMessage());
            }
            catch (Exception exception) {
                String string = WorldWind.retrieveErrMsg("generic.ExceptionWhileRenderingIcon");
                WorldWind.logger().log(Level.FINE, string, exception);
            }
            finally {
                IconRenderer.this.endDrawIcons(drawContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pick(DrawContext drawContext, java.awt.Point point) {
            IconRenderer.this.pickSupport.clearPickList();
            IconRenderer.this.beginDrawIcons(drawContext);
            try {
                IconRenderer.this.drawIcon(drawContext, this);
                while (drawContext.getOrderedRenderables().peek() instanceof OrderedIcon) {
                    IconRenderer.this.drawIcon(drawContext, (OrderedIcon)drawContext.getOrderedRenderables().poll());
                }
            }
            catch (WWRuntimeException wWRuntimeException) {
                String string = WorldWind.retrieveErrMsg("generic.ExceptionWhileRenderingIcon");
                WorldWind.logger().log(Level.FINE, string + ":" + wWRuntimeException.getMessage());
            }
            catch (Exception exception) {
                String string = WorldWind.retrieveErrMsg("generic.ExceptionWhilePickingIcon");
                WorldWind.logger().log(Level.FINE, string, exception);
            }
            finally {
                IconRenderer.this.endDrawIcons(drawContext);
                IconRenderer.this.pickSupport.resolvePick(drawContext, point, this.layer);
                IconRenderer.this.pickSupport.clearPickList();
            }
        }
    }

    private class OrderedText
    implements OrderedRenderable {
        Font font;
        String text;
        Point point;
        double eyeDistance;
        java.awt.Point pickPoint;
        Layer layer;
        Color color;

        OrderedText(String string, Font font, Point point, Color color, double d) {
            this.text = string;
            this.font = font;
            this.point = point;
            this.eyeDistance = d;
            this.color = color;
        }

        OrderedText(String string, Font font, Point point, java.awt.Point point2, Layer layer, double d) {
            this.text = string;
            this.font = font;
            this.point = point;
            this.eyeDistance = d;
            this.pickPoint = point2;
            this.layer = layer;
        }

        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        public void render(DrawContext drawContext) {
            ToolTipRenderer toolTipRenderer = (ToolTipRenderer)IconRenderer.this.toolTipRenderers.get(this.font);
            if (toolTipRenderer == null) {
                toolTipRenderer = this.font != null ? new ToolTipRenderer(new TextRenderer(this.font, true, true)) : new ToolTipRenderer();
                IconRenderer.this.toolTipRenderers.put(this.font, toolTipRenderer);
            }
            Rectangle rectangle = drawContext.getView().getViewport();
            toolTipRenderer.setForeground(this.color);
            toolTipRenderer.setUseSystemLookAndFeel(this.color == null);
            toolTipRenderer.beginRendering(rectangle.width, rectangle.height, true);
            toolTipRenderer.draw(this.text, (int)this.point.x(), (int)this.point.y());
            toolTipRenderer.endRendering();
        }

        public void pick(DrawContext drawContext, java.awt.Point point) {
        }
    }
}

