/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Layer;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerList
extends WWObjectImpl
implements Iterable<Layer> {
    private List<Layer> layerList = new ArrayList<Layer>();

    public LayerList() {
    }

    public LayerList(Layer[] layerArray) {
        if (layerArray == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LayersIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        for (Layer layer : layerArray) {
            this.add(layer);
        }
    }

    public void add(Layer layer) {
        if (layer == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LayerIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.layerList.contains(layer)) {
            return;
        }
        this.layerList.add(layer);
        layer.addPropertyChangeListener(this);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this.layerList);
    }

    public void remove(Layer layer) {
        if (layer == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LayerIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (!this.layerList.contains(layer)) {
            return;
        }
        layer.removePropertyChangeListener(this);
        this.layerList.remove(layer);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this.layerList);
    }

    @Override
    public Iterator<Layer> iterator() {
        return this.layerList.iterator();
    }

    public int getSize() {
        return this.layerList.size();
    }

    public String toString() {
        String string = "";
        for (Layer layer : this.layerList) {
            string = string + layer.toString() + ", ";
        }
        return string;
    }
}

