/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.AbsentResourceList;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Tile;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;

public class PlaceNameService {
    private final String service;
    private final String dataset;
    private final String fileCachePath;
    private static final String FORMAT_SUFFIX = ".xml.gz";
    private final Sector sector;
    private final LatLon tileDelta;
    private Extent extent = null;
    private double extentVerticalExaggeration = Double.MIN_VALUE;
    private final Font font;
    private boolean enabled;
    private Color color;
    private double minDisplayDistance;
    private double maxDisplayDistance;
    private int numColumns;
    private static final int MAX_ABSENT_TILE_TRIES = 2;
    private static final int MIN_ABSENT_TILE_CHECK_INTERVAL = 10000;
    private final AbsentResourceList absentTiles = new AbsentResourceList(2, 10000);

    public PlaceNameService(String string, String string2, String string3, Sector sector, LatLon latLon, Font font) {
        this.service = string;
        this.dataset = string2;
        this.fileCachePath = string3;
        this.sector = sector;
        this.tileDelta = latLon;
        this.font = font;
        this.enabled = true;
        this.color = Color.white;
        this.minDisplayDistance = Double.MIN_VALUE;
        this.maxDisplayDistance = Double.MAX_VALUE;
        String string4 = this.validate();
        if (string4 != null) {
            WorldWind.logger().log(Level.FINE, string4);
            throw new IllegalArgumentException(string4);
        }
        this.numColumns = this.numColumnsInLevel();
    }

    public String createFileCachePathFromTile(int n, int n2) {
        if (n < 0 || n2 < 0) {
            String string = WorldWind.retrieveErrMsg("PlaceNameService.RowOrColumnOutOfRange");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder(this.fileCachePath);
        stringBuilder.append(File.separator).append(this.dataset);
        stringBuilder.append(File.separator).append(n);
        stringBuilder.append(File.separator).append(n).append('_').append(n2);
        if (FORMAT_SUFFIX.charAt(0) != '.') {
            stringBuilder.append('.');
        }
        stringBuilder.append(FORMAT_SUFFIX);
        String string = stringBuilder.toString();
        return string.replaceAll("[:*?<>|]", "");
    }

    private int numColumnsInLevel() {
        int n = Tile.computeColumn(this.tileDelta.getLongitude(), this.sector.getMinLongitude());
        int n2 = Tile.computeColumn(this.tileDelta.getLongitude(), this.sector.getMaxLongitude().subtract(this.tileDelta.getLongitude()));
        return n2 - n + 1;
    }

    public long getTileNumber(int n, int n2) {
        return n * this.numColumns + n2;
    }

    public URL createServiceURLFromSector(Sector sector) throws MalformedURLException {
        if (sector == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.SectorIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder(this.service);
        if (stringBuilder.charAt(stringBuilder.length() - 1) != '?') {
            stringBuilder.append('?');
        }
        stringBuilder.append("TypeName=").append(this.dataset);
        stringBuilder.append("&Request=GetFeature");
        stringBuilder.append("&Service=WFS");
        stringBuilder.append("&OUTPUTFORMAT=GML2-GZIP");
        stringBuilder.append("&BBOX=");
        stringBuilder.append(sector.getMinLongitude().getDegrees()).append(',');
        stringBuilder.append(sector.getMinLatitude().getDegrees()).append(',');
        stringBuilder.append(sector.getMaxLongitude().getDegrees()).append(',');
        stringBuilder.append(sector.getMaxLatitude().getDegrees());
        return new URL(stringBuilder.toString());
    }

    public final synchronized PlaceNameService deepCopy() {
        PlaceNameService placeNameService = new PlaceNameService(this.service, this.dataset, this.fileCachePath, this.sector, this.tileDelta, this.font);
        placeNameService.enabled = this.enabled;
        placeNameService.color = this.color;
        placeNameService.minDisplayDistance = this.minDisplayDistance;
        placeNameService.maxDisplayDistance = this.maxDisplayDistance;
        return placeNameService;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PlaceNameService placeNameService = (PlaceNameService)object;
        if (this.service != null ? !this.service.equals(placeNameService.service) : placeNameService.service != null) {
            return false;
        }
        if (this.dataset != null ? !this.dataset.equals(placeNameService.dataset) : placeNameService.dataset != null) {
            return false;
        }
        if (this.fileCachePath != null ? !this.fileCachePath.equals(placeNameService.fileCachePath) : placeNameService.fileCachePath != null) {
            return false;
        }
        if (this.sector != null ? !this.sector.equals(placeNameService.sector) : placeNameService.sector != null) {
            return false;
        }
        if (this.tileDelta != null ? !this.tileDelta.equals(placeNameService.tileDelta) : placeNameService.tileDelta != null) {
            return false;
        }
        if (this.font != null ? !this.font.equals(placeNameService.font) : placeNameService.font != null) {
            return false;
        }
        if (this.color != null ? !this.color.equals(placeNameService.color) : placeNameService.color != null) {
            return false;
        }
        if (this.minDisplayDistance != placeNameService.minDisplayDistance) {
            return false;
        }
        return this.maxDisplayDistance == placeNameService.maxDisplayDistance;
    }

    public final synchronized Color getColor() {
        return this.color;
    }

    public final String getDataset() {
        return this.dataset;
    }

    public final Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.extent == null || this.extentVerticalExaggeration != drawContext.getVerticalExaggeration()) {
            this.extentVerticalExaggeration = drawContext.getVerticalExaggeration();
            this.extent = Sector.computeBoundingCylinder(drawContext.getGlobe(), this.extentVerticalExaggeration, this.sector);
        }
        return this.extent;
    }

    public final String getFileCachePath() {
        return this.fileCachePath;
    }

    public final Font getFont() {
        return this.font;
    }

    public final synchronized double getMaxDisplayDistance() {
        return this.maxDisplayDistance;
    }

    public final synchronized double getMinDisplayDistance() {
        return this.minDisplayDistance;
    }

    public final LatLon getTileDelta() {
        return this.tileDelta;
    }

    public final Sector getSector() {
        return this.sector;
    }

    public final String getService() {
        return this.service;
    }

    public int hashCode() {
        int n = this.service != null ? this.service.hashCode() : 0;
        n = 29 * n + (this.dataset != null ? this.dataset.hashCode() : 0);
        n = 29 * n + (this.fileCachePath != null ? this.fileCachePath.hashCode() : 0);
        n = 29 * n + (this.sector != null ? this.sector.hashCode() : 0);
        n = 29 * n + (this.tileDelta != null ? this.tileDelta.hashCode() : 0);
        n = 29 * n + (this.font != null ? this.font.hashCode() : 0);
        n = 29 * n + (this.color != null ? this.color.hashCode() : 0);
        n = 29 * n + Double.valueOf(this.minDisplayDistance).hashCode();
        n = 29 * n + Double.valueOf(this.maxDisplayDistance).hashCode();
        return n;
    }

    public final synchronized boolean isEnabled() {
        return this.enabled;
    }

    public final synchronized void setColor(Color color) {
        if (color == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ColorIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    public final synchronized void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final synchronized void setMaxDisplayDistance(double d) {
        if (d < this.minDisplayDistance) {
            String string = WorldWind.retrieveErrMsg("PlaceNameService.MaxDisplayDistanceLessThanMinDisplayDistance");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.maxDisplayDistance = d;
    }

    public final synchronized void setMinDisplayDistance(double d) {
        if (d > this.maxDisplayDistance) {
            String string = WorldWind.retrieveErrMsg("PlaceNameService.MinDisplayDistanceGrtrThanMaxDisplayDistance");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.minDisplayDistance = d;
    }

    public final synchronized void markResourceAbsent(long l) {
        this.absentTiles.markResourceAbsent(l);
    }

    public final synchronized boolean isResourceAbsent(long l) {
        return this.absentTiles.isResourceAbsent(l);
    }

    public final synchronized void unmarkResourceAbsent(long l) {
        this.absentTiles.unmarkResourceAbsent(l);
    }

    public final String validate() {
        String string = "";
        if (this.service == null) {
            string = string + WorldWind.retrieveErrMsg("nullValue.ServiceIsNull") + ", ";
        }
        if (this.dataset == null) {
            string = string + WorldWind.retrieveErrMsg("nullValue.DataSetIsNull") + ", ";
        }
        if (this.fileCachePath == null) {
            string = string + WorldWind.retrieveErrMsg("nullValue.FileCachePathIsNull") + ", ";
        }
        if (this.sector == null) {
            string = string + WorldWind.retrieveErrMsg("nullValue.SectorIsNull") + ", ";
        }
        if (this.tileDelta == null) {
            string = string + WorldWind.retrieveErrMsg("nullValue.TileDeltaIsNull") + ", ";
        }
        if (this.font == null) {
            string = string + WorldWind.retrieveErrMsg("nullValue.FontIsNull") + ", ";
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }
}

