/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.RetrievalPostProcessor;
import gov.nasa.worldwind.Retriever;
import gov.nasa.worldwind.WWRuntimeException;
import gov.nasa.worldwind.WorldWind;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public final class RetrieveToFilePostProcessor
implements RetrievalPostProcessor {
    File destination;

    public RetrieveToFilePostProcessor(File file) {
        if (file == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DestNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.destination = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer run(Retriever retriever) {
        if (retriever == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RetrieverIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        try {
            ByteBuffer byteBuffer = retriever.getBuffer();
            if (byteBuffer == null) {
                WorldWind.logger().log(Level.FINE, WorldWind.retrieveErrMsg("RetrieveToFilePostProcessor.NullBufferPostprocessing") + retriever.getName());
                return null;
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.destination);
                fileOutputStream.getChannel().write(byteBuffer);
                ByteBuffer byteBuffer2 = null;
                return byteBuffer2;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            String string = WorldWind.retrieveErrMsg("RetrieveToFilePostProcessor.ErrorPostprocessing") + retriever.getName();
            WorldWind.logger().log(Level.FINE, string);
            throw new WWRuntimeException(string, iOException);
        }
    }
}

