/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.SectorGeometry;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.TextureTile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceTileRenderer
implements Disposable {
    private static final int DEFAULT_ALPHA_TEXTURE_SIZE = 2;
    private Texture alphaTexture;
    private Texture outlineTexture;
    private boolean showImageTileOutlines = false;

    @Override
    public void dispose() {
    }

    public boolean isShowImageTileOutlines() {
        return this.showImageTileOutlines;
    }

    public void setShowImageTileOutlines(boolean bl) {
        this.showImageTileOutlines = bl;
    }

    public void renderTile(DrawContext drawContext, TextureTile textureTile) {
        if (textureTile == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.TileIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        ArrayList<TextureTile> arrayList = new ArrayList<TextureTile>(1);
        arrayList.add(textureTile);
        this.renderTiles(drawContext, arrayList);
        arrayList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderTiles(DrawContext drawContext, Iterable<TextureTile> iterable) {
        if (iterable == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.TileIterableIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        GL gL = drawContext.getGL();
        gL.glPushAttrib(291073);
        try {
            boolean bl;
            if (this.alphaTexture == null) {
                this.initAlphaTexture(2);
            }
            boolean bl2 = bl = this.showImageTileOutlines && drawContext.getNumTextureUnits() > 2;
            if (bl && this.outlineTexture == null) {
                this.initOutlineTexture(128);
            }
            gL.glEnable(2929);
            gL.glDepthFunc(515);
            gL.glEnable(3008);
            gL.glAlphaFunc(516, 0.01f);
            gL.glActiveTexture(33984);
            gL.glEnable(3553);
            gL.glMatrixMode(5890);
            gL.glPushMatrix();
            if (!drawContext.isPickingMode()) {
                gL.glTexEnvi(8960, 8704, 7681);
            } else {
                gL.glTexEnvf(8960, 8704, 34160.0f);
                gL.glTexEnvf(8960, 34176, 34168.0f);
                gL.glTexEnvf(8960, 34161, 7681.0f);
            }
            int n = 2;
            int n2 = 33985;
            if (bl) {
                n = 3;
                n2 = 33986;
                gL.glActiveTexture(33985);
                gL.glEnable(3553);
                gL.glMatrixMode(5890);
                gL.glPushMatrix();
                gL.glTexEnvi(8960, 8704, 260);
            }
            gL.glActiveTexture(n2);
            gL.glEnable(3553);
            gL.glMatrixMode(5890);
            gL.glPushMatrix();
            gL.glTexEnvi(8960, 8704, 8448);
            for (SectorGeometry sectorGeometry : drawContext.getSurfaceGeometry()) {
                Iterable<TextureTile> iterable2 = this.getIntersectingTiles(sectorGeometry, iterable);
                if (iterable2 == null) continue;
                Sector sector = sectorGeometry.getSector();
                double d = sector.getDeltaLatRadians();
                double d2 = sector.getDeltaLonRadians();
                double d3 = sector.getMinLatitude().radians;
                double d4 = sector.getMinLongitude().radians;
                for (TextureTile textureTile : iterable2) {
                    gL.glActiveTexture(33984);
                    if (!textureTile.bindTexture(drawContext)) continue;
                    gL.glMatrixMode(5890);
                    gL.glLoadIdentity();
                    textureTile.applyTextureTransform(drawContext);
                    Sector sector2 = textureTile.getSector();
                    double d5 = sector2.getDeltaLatRadians() > 0.0 ? d / sector2.getDeltaLatRadians() : 1.0;
                    double d6 = sector2.getDeltaLonRadians() > 0.0 ? d2 / sector2.getDeltaLonRadians() : 1.0;
                    gL.glScaled(d6, d5, 1.0);
                    double d7 = -(sector2.getMinLatitude().radians - d3) / d;
                    double d8 = -(sector2.getMinLongitude().radians - d4) / d2;
                    gL.glTranslated(d8, d7, 0.0);
                    if (bl) {
                        gL.glActiveTexture(33985);
                        this.outlineTexture.bind();
                        gL.glMatrixMode(5890);
                        gL.glLoadIdentity();
                        gL.glScaled(d6, d5, 1.0);
                        gL.glTranslated(d8, d7, 0.0);
                    }
                    gL.glActiveTexture(n2);
                    this.alphaTexture.bind();
                    gL.glMatrixMode(5890);
                    gL.glLoadIdentity();
                    gL.glScaled(d6, d5, 1.0);
                    gL.glTranslated(d8, d7, 0.0);
                    sectorGeometry.renderMultiTexture(drawContext, n);
                }
            }
            gL.glActiveTexture(n2);
            gL.glMatrixMode(5890);
            gL.glPopMatrix();
            gL.glDisable(3553);
            gL.glActiveTexture(33984);
            gL.glMatrixMode(5890);
            gL.glPopMatrix();
            gL.glDisable(3553);
            if (bl) {
                gL.glActiveTexture(33985);
                gL.glMatrixMode(5890);
                gL.glPopMatrix();
                gL.glDisable(3553);
            }
        }
        catch (Exception exception) {
            String string = WorldWind.retrieveErrMsg("generic.ExceptionWhileRenderingLayer");
            string = string + this.getClass().getName();
            WorldWind.logger().log(Level.FINE, string, exception);
        }
        finally {
            gL.glPopAttrib();
        }
    }

    private Iterable<TextureTile> getIntersectingTiles(SectorGeometry sectorGeometry, Iterable<TextureTile> iterable) {
        ArrayList<TextureTile> arrayList = null;
        for (TextureTile textureTile : iterable) {
            if (!textureTile.getSector().intersects(sectorGeometry.getSector())) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<TextureTile>();
            }
            arrayList.add(textureTile);
        }
        if (arrayList == null) {
            return null;
        }
        return arrayList;
    }

    private static void fillByteBuffer(ByteBuffer byteBuffer, byte by) {
        for (int i = 0; i < byteBuffer.capacity(); ++i) {
            byteBuffer.put(by);
        }
    }

    private void initAlphaTexture(int n) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n * n);
        SurfaceTileRenderer.fillByteBuffer(byteBuffer, (byte)-1);
        TextureData textureData = new TextureData(6406, n, n, 0, 6406, 5121, false, false, false, byteBuffer.rewind(), null);
        this.alphaTexture = TextureIO.newTexture(textureData);
        this.alphaTexture.bind();
        this.alphaTexture.setTexParameteri(10240, 9728);
        this.alphaTexture.setTexParameteri(10241, 9728);
        this.alphaTexture.setTexParameteri(10242, 33069);
        this.alphaTexture.setTexParameteri(10243, 33069);
    }

    private void initOutlineTexture(int n) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n * n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                byte by = i == 0 || j == 0 || i == n - 1 || j == n - 1 ? (byte)-1 : 0;
                byteBuffer.put(i * n + j, by);
            }
        }
        TextureData textureData = new TextureData(6409, n, n, 0, 6409, 5121, false, false, false, byteBuffer.rewind(), null);
        this.outlineTexture = TextureIO.newTexture(textureData);
        this.outlineTexture.bind();
        this.outlineTexture.setTexParameteri(10240, 9728);
        this.outlineTexture.setTexParameteri(10241, 9728);
        this.outlineTexture.setTexParameteri(10242, 33071);
        this.outlineTexture.setTexParameteri(10243, 33071);
    }
}

