/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWDuplicateRequestException;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ThreadedTaskService
extends WWObjectImpl
implements Thread.UncaughtExceptionHandler {
    private static final int DEFAULT_CORE_POOL_SIZE = 1;
    private static final int DEFAULT_QUEUE_SIZE = 10;
    private static final String RUNNING_THREAD_NAME_PREFIX = WorldWind.retrieveMessage("ThreadedTaskService.RUNNING_THREAD_NAME_PREFIX", "ThreadStrings");
    private static final String IDLE_THREAD_NAME_PREFIX = WorldWind.retrieveMessage("ThreadedTaskService.IDLE_THREAD_NAME_PREFIX", "ThreadStrings");
    private ConcurrentLinkedQueue<Runnable> activeTasks;
    private TaskExecutor executor;

    public ThreadedTaskService() {
        Integer n = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.ThreadedTaskPoolSize", 1);
        Integer n2 = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.ThreadedTaskQueueSize", 10);
        this.executor = new TaskExecutor(n, n2);
        this.activeTasks = new ConcurrentLinkedQueue();
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (throwable instanceof WWDuplicateRequestException) {
            return;
        }
        String string = WorldWind.retrieveErrMsg("ThreadedTaskService.UncaughtExceptionDuringTask") + thread.getName();
        WorldWind.logger().log(Level.FINE, string);
        Thread.currentThread().getThreadGroup().uncaughtException(thread, throwable);
    }

    public synchronized boolean contains(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        return this.activeTasks.contains(runnable) || this.executor.getQueue().contains(runnable);
    }

    public synchronized void addTask(Runnable runnable) {
        if (runnable == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RunnableIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.activeTasks.contains(runnable) || this.executor.getQueue().contains(runnable)) {
            return;
        }
        this.executor.execute(runnable);
    }

    public boolean isFull() {
        return this.executor.getQueue().remainingCapacity() == 0;
    }

    private class TaskExecutor
    extends ThreadPoolExecutor {
        private static final long THREAD_TIMEOUT = 2L;

        private TaskExecutor(int n, int n2) {
            super(n, n, 2L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(n2), new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    thread.setPriority(1);
                    thread.setUncaughtExceptionHandler(ThreadedTaskService.this);
                    return thread;
                }
            }, new ThreadPoolExecutor.DiscardPolicy(){

                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    String string = WorldWind.retrieveErrMsg("ThreadedTaskService.ResourceRejected") + runnable;
                    WorldWind.logger().log(Level.FINEST, string);
                    super.rejectedExecution(runnable, threadPoolExecutor);
                }
            });
        }

        protected void beforeExecute(Thread thread, Runnable runnable) {
            WorldWind.logger().log(Level.FINEST, WorldWind.retrieveErrMsg("ThreadedTaskService.EnteringBeforeExecute"));
            if (thread == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.ThreadIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            if (runnable == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RunnableIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            if (ThreadedTaskService.this.activeTasks.contains(runnable)) {
                String string = WorldWind.retrieveErrMsg("ThreadedTaskService.CancellingDuplicateTask") + runnable;
                WorldWind.logger().log(Level.FINER, string);
                throw new WWDuplicateRequestException(string);
            }
            ThreadedTaskService.this.activeTasks.add(runnable);
            if (RUNNING_THREAD_NAME_PREFIX != null) {
                thread.setName(RUNNING_THREAD_NAME_PREFIX + runnable);
            }
            thread.setPriority(1);
            thread.setUncaughtExceptionHandler(ThreadedTaskService.this);
            super.beforeExecute(thread, runnable);
            WorldWind.logger().log(Level.FINEST, WorldWind.retrieveErrMsg("ThreadedTaskService.LeavingBeforeExecute"));
        }

        protected void afterExecute(Runnable runnable, Throwable throwable) {
            WorldWind.logger().log(Level.FINEST, WorldWind.retrieveErrMsg("ThreadedTaskService.EnteringAfterExecute"));
            if (runnable == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RunnableIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            super.afterExecute(runnable, throwable);
            ThreadedTaskService.this.activeTasks.remove(runnable);
            if (throwable == null && IDLE_THREAD_NAME_PREFIX != null) {
                Thread.currentThread().setName(IDLE_THREAD_NAME_PREFIX);
            }
        }
    }
}

