/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.WorldWind;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ToolTipRenderer {
    private static final Font toolTipFont = UIManager.getFont("ToolTip.font");
    private static final Color toolTipFg = UIManager.getColor("ToolTip.foreground");
    private static final Color toolTipBg = UIManager.getColor("ToolTip.background");
    private static final Border toolTipBorder = UIManager.getBorder("ToolTip.border");
    private Color foreground;
    private Color background;
    private float[] compArray;
    private Insets insets;
    private float borderWidth;
    private boolean useSystemLookAndFeel = false;
    private TextRenderer textRenderer;
    private int orthoWidth;
    private int orthoHeight;
    private GLU glu = new GLU();

    public ToolTipRenderer() {
        this(new TextRenderer(toolTipFont, true, true), false);
    }

    public ToolTipRenderer(TextRenderer textRenderer) {
        this(textRenderer, false);
    }

    public ToolTipRenderer(TextRenderer textRenderer, boolean bl) {
        if (textRenderer == null) {
            String string = WorldWind.retrieveErrMsg("");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.textRenderer = textRenderer;
        this.useSystemLookAndFeel = bl;
        this.borderWidth = 1.0f;
    }

    public void beginRendering(int n, int n2, boolean bl) {
        GL gL = GLU.getCurrentGL();
        int n3 = 28681;
        gL.glPushAttrib(n3);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        this.glu.gluOrtho2D(0.0, n, 0.0, n2);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMatrixMode(5890);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glDisable(2896);
        gL.glDisable(3553);
        if (bl) {
            gL.glDisable(2929);
        }
        gL.glDisable(2884);
        gL.glEnable(3042);
        gL.glBlendFunc(1, 771);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.001f);
        this.orthoWidth = n;
        this.orthoHeight = n2;
    }

    public void endRendering() {
        GL gL = GLU.getCurrentGL();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    private static Rectangle2D ensureVisibleBounds(Rectangle2D rectangle2D, int n, int n2) {
        double d = rectangle2D.getMinX() < 0.0 ? 1.0 : (rectangle2D.getMaxX() > (double)n ? (double)n - rectangle2D.getWidth() - 1.0 : rectangle2D.getX());
        double d2 = rectangle2D.getMinX() < 0.0 ? 1.0 : (rectangle2D.getMaxY() > (double)n2 ? (double)n2 - rectangle2D.getHeight() - 1.0 : rectangle2D.getY());
        return new Rectangle2D.Double(d, d2, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Color getBackground() {
        return this.background;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public boolean getUseSystemLookAndFeel() {
        return this.useSystemLookAndFeel;
    }

    public void draw(String string, int n, int n2) {
        Color color;
        Color color2;
        Insets insets;
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.StringIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        GL gL = GLU.getCurrentGL();
        if (this.useSystemLookAndFeel) {
            insets = toolTipBorder.getBorderInsets(null);
            color2 = toolTipFg;
            color = toolTipBg;
        } else {
            if (this.foreground != null) {
                color2 = this.foreground;
            } else {
                gL.glGetFloatv(2816, this.compArray, 0);
                color2 = new Color(this.compArray[0], this.compArray[1], this.compArray[2], this.compArray[3]);
            }
            if (this.background != null) {
                color = this.background;
            } else {
                if (this.compArray == null) {
                    this.compArray = new float[4];
                }
                Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), this.compArray);
                color = Color.getHSBColor(0.0f, 0.0f, (this.compArray[2] + 0.5f) % 1.0f);
            }
            insets = this.insets != null ? this.insets : new Insets(1, 1, 1, 1);
        }
        Rectangle2D rectangle2D = this.textRenderer.getBounds(string);
        Rectangle2D rectangle2D2 = new Rectangle2D.Double(n, n2, rectangle2D.getWidth() + (double)insets.left + (double)insets.right, rectangle2D.getHeight() + (double)insets.bottom + (double)insets.top);
        rectangle2D2 = ToolTipRenderer.ensureVisibleBounds(rectangle2D2, this.orthoWidth, this.orthoHeight);
        double d = rectangle2D2.getX() + (double)insets.left - rectangle2D.getX();
        double d2 = rectangle2D2.getY() + (double)insets.bottom + rectangle2D.getY() + rectangle2D.getHeight();
        this.setDrawColor(color);
        gL.glPolygonMode(1032, 6914);
        gL.glRectd(rectangle2D2.getMinX(), rectangle2D2.getMinY(), rectangle2D2.getMaxX(), rectangle2D2.getMaxY());
        this.setDrawColor(color2);
        gL.glPolygonMode(1032, 6913);
        gL.glLineWidth(this.borderWidth);
        gL.glRectd(rectangle2D2.getMinX(), rectangle2D2.getMinY(), rectangle2D2.getMaxX(), rectangle2D2.getMaxY());
        this.textRenderer.setColor(color2);
        gL.glPolygonMode(1032, 6914);
        this.textRenderer.begin3DRendering();
        this.textRenderer.draw(string, (int)d, (int)d2);
        this.textRenderer.end3DRendering();
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setBorderWidth(float f) {
        this.borderWidth = f;
    }

    private void setDrawColor(float f, float f2, float f3, float f4) {
        GL gL = GLU.getCurrentGL();
        gL.glColor4f(f * f4, f2 * f4, f3 * f4, f4);
    }

    private void setDrawColor(Color color) {
        if (this.compArray == null) {
            this.compArray = new float[4];
        }
        color.getRGBComponents(this.compArray);
        this.setDrawColor(this.compArray[0], this.compArray[1], this.compArray[2], this.compArray[3]);
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public void setUseSystemLookAndFeel(boolean bl) {
        this.useSystemLookAndFeel = bl;
    }
}

