/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Track;
import gov.nasa.worldwind.TrackPoint;
import gov.nasa.worldwind.TrackPointIterator;
import gov.nasa.worldwind.TrackSegment;
import gov.nasa.worldwind.WorldWind;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackPointIteratorImpl
implements TrackPointIterator {
    private List<Track> tracksList;
    private Iterator<Track> tracks;
    private Iterator<TrackSegment> segments;
    private Iterator<TrackPoint> positions;

    public TrackPointIteratorImpl(List<Track> list) {
        this.tracksList = list;
        this.reset();
    }

    @Override
    public TrackPointIteratorImpl reset() {
        if (this.tracksList == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.TracksIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.tracks = this.tracksList.iterator();
        this.segments = null;
        this.positions = null;
        this.loadNextPositions();
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.positions != null && this.positions.hasNext()) {
            return true;
        }
        this.loadNextPositions();
        return this.positions != null && this.positions.hasNext();
    }

    private void loadNextPositions() {
        if (this.segments != null && this.segments.hasNext()) {
            TrackSegment trackSegment = this.segments.next();
            this.positions = trackSegment.getPoints().iterator();
            return;
        }
        if (this.tracks.hasNext()) {
            Track track = this.tracks.next();
            this.segments = track.getSegments().iterator();
            this.loadNextPositions();
        }
    }

    @Override
    public TrackPoint next() {
        if (!this.hasNext()) {
            String string = WorldWind.retrieveErrMsg("iterator.NoMoreTrackPoints");
            WorldWind.logger().log(Level.FINE, string);
            throw new NoSuchElementException(string);
        }
        return this.positions.next();
    }

    @Override
    public void remove() {
        String string = WorldWind.retrieveErrMsg("iterator.RemoveNotSupported");
        WorldWind.logger().log(Level.FINE, string);
        throw new UnsupportedOperationException(string);
    }

    public int getNumPoints() {
        int n = 0;
        while (this.hasNext()) {
            ++n;
            this.next();
        }
        return n;
    }
}

