/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.BasicRetrievalService;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.FileCache;
import gov.nasa.worldwind.MemoryCache;
import gov.nasa.worldwind.RetrievalService;
import gov.nasa.worldwind.ThreadedTaskService;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WWRuntimeException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WorldWind {
    private static WorldWind instance = new WorldWind();
    private WWObjectImpl wwo = new WWObjectImpl();
    private MemoryCache memoryCache;
    private FileCache dataFileCache;
    private BasicRetrievalService retrievalService;
    private ThreadedTaskService threadedTaskService = new ThreadedTaskService();

    private WorldWind() {
        this.retrievalService = (BasicRetrievalService)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.RetrievalServiceClassName");
        this.threadedTaskService = (ThreadedTaskService)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ThreadedTaskServiceClassName");
        this.dataFileCache = (FileCache)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.DataFileCacheClassName");
        this.memoryCache = (MemoryCache)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.MemoryCacheClassName");
    }

    public static Logger logger() {
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.LoggerName");
        if (string == null) {
            return Logger.global;
        }
        Logger logger = Logger.getLogger(string);
        return logger != null ? logger : Logger.global;
    }

    public static MemoryCache memoryCache() {
        return WorldWind.instance.memoryCache;
    }

    public static FileCache dataFileCache() {
        return WorldWind.instance.dataFileCache;
    }

    public static RetrievalService retrievalService() {
        return WorldWind.instance.retrievalService;
    }

    public static ThreadedTaskService threadedTaskService() {
        return WorldWind.instance.threadedTaskService;
    }

    public static Object createComponent(String string) throws WWRuntimeException {
        if (string == null || string.length() == 0) {
            String string2 = "Class name key is null or zero length";
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.newInstance();
        }
        catch (Exception exception) {
            String string3 = "Exception while creating World Wind component " + string;
            WorldWind.logger().log(Level.FINE, string3);
            throw new WWRuntimeException(string3, exception);
        }
        catch (Throwable throwable) {
            String string4 = "Error while creating World Wind component " + string;
            WorldWind.logger().log(Level.FINE, string4);
            throw new WWRuntimeException(string4, throwable);
        }
    }

    public static Object createConfigurationComponent(String string) throws IllegalStateException, IllegalArgumentException {
        if (string == null) {
            String string2 = "Class name key is null";
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = Configuration.getStringValue(string);
        if (string3 == null) {
            String string4 = "No class name in configuration for key " + string;
            WorldWind.logger().log(Level.FINE, string4);
            throw new IllegalStateException(string4);
        }
        try {
            return WorldWind.createComponent(string3);
        }
        catch (Throwable throwable) {
            String string5 = "Unable to create class for configuration key " + string;
            WorldWind.logger().log(Level.FINE, string5);
            throw new WWRuntimeException(string5, throwable);
        }
    }

    public static void setValue(String string, String string2) {
        WorldWind.instance.wwo.setValue(string, string2);
    }

    public static Object getValue(String string) {
        return WorldWind.instance.wwo.getValue(string);
    }

    public static String getStringValue(String string) {
        return WorldWind.instance.wwo.getStringValue(string);
    }

    public static boolean hasKey(String string) {
        return WorldWind.instance.wwo.hasKey(string);
    }

    public static void removeKey(String string) {
        WorldWind.instance.wwo.removeKey(string);
    }

    public static String retrieveErrMsg(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ErrorStrings", Locale.getDefault());
        return (String)resourceBundle.getObject(string);
    }

    public static String retrieveMessage(String string, String string2) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, Locale.getDefault());
        return (String)resourceBundle.getObject(string);
    }
}

