/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.AVListImpl;
import gov.nasa.worldwind.Globe;
import gov.nasa.worldwind.InputHandler;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.PickedObject;
import gov.nasa.worldwind.PickedObjectList;
import gov.nasa.worldwind.PositionEvent;
import gov.nasa.worldwind.PositionListener;
import gov.nasa.worldwind.SelectEvent;
import gov.nasa.worldwind.SelectListener;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.InterpolatorTimer;
import gov.nasa.worldwind.awt.KeyPollTimer;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Position;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.logging.Level;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class AWTInputHandler
extends AVListImpl
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
InputHandler {
    private WorldWindow worldWindow = null;
    private final EventListenerList eventListeners = new EventListenerList();
    private Position previousPickPosition = null;
    private PickedObjectList lastPickedObjects = null;
    private PickedObjectList hoverObjects;
    private boolean isHovering = false;
    private Timer hoverTimer = new Timer(600, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (AWTInputHandler.this.hoverMatches()) {
                AWTInputHandler.this.isHovering = true;
                AWTInputHandler.this.callSelectListeners(new SelectEvent(AWTInputHandler.this.worldWindow, "gov.nasa.worldwind.SelectEvent.Hover", null, AWTInputHandler.this.hoverObjects));
                AWTInputHandler.this.hoverTimer.stop();
            }
        }
    });
    private java.awt.Point lastMousePoint = new java.awt.Point();
    private final Integer[] POLLED_KEYS = new Integer[]{37, 39, 38, 40, 33, 34, 107, 61, 109, 45};
    private KeyPollTimer keyPollTimer = new KeyPollTimer(25, Arrays.asList(this.POLLED_KEYS), new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent == null) {
                return;
            }
            Object object = actionEvent.getSource();
            if (object != null && object instanceof Integer) {
                AWTInputHandler.this.keysPolled((Integer)object, actionEvent.getModifiers());
            }
        }
    });
    private InterpolatorTimer interpolatorTimer = new InterpolatorTimer(15);
    private PropertyChangeListener viewPropertyListener = null;
    private InterpolatorTimer.ViewProperties viewTarget = null;
    private boolean smoothViewChange = true;
    private final double viewLatLonMinChangeFactor = 1.0E-5;
    private final double viewLatLonMaxChangeFactor = 0.2;
    private final double viewLatLonErrorThresold = 1.0E-9;
    private final double viewLatLonStepCoefficient = 0.6;
    private final double viewLatLonCenterStepCoefficient = 0.1;
    private final double viewAngleChangeFactor = 0.25;
    private final double viewAngleErrorThreshold = 1.0E-4;
    private final double viewAngleStepCoefficient = 0.3;
    private final double viewAngleResetStepCoefficient = 0.1;
    private final double viewZoomChangeFactor = 0.05;
    private final double viewZoomErrorThreshold = 0.001;
    private final double viewZoomStepCoefficient = 0.1;

    public void setEventSource(WorldWindow worldWindow) {
        Component component;
        if (worldWindow != null && !(worldWindow instanceof Component)) {
            String string = WorldWind.retrieveErrMsg("awt.AWTInputHandler.EventSourceNotAComponent");
            WorldWind.logger().log(Level.FINER, string);
            throw new IllegalArgumentException(string);
        }
        if (worldWindow == this.worldWindow) {
            return;
        }
        if (this.worldWindow != null) {
            component = (Component)((Object)this.worldWindow);
            component.removeKeyListener(this);
            component.removeMouseMotionListener(this);
            component.removeMouseListener(this);
            component.removeMouseWheelListener(this);
            if (this.keyPollTimer != null) {
                component.removeKeyListener(this.keyPollTimer);
            }
        }
        this.worldWindow = worldWindow;
        if (this.worldWindow == null) {
            return;
        }
        component = (Component)((Object)this.worldWindow);
        component.addKeyListener(this);
        component.addMouseMotionListener(this);
        component.addMouseListener(this);
        component.addMouseWheelListener(this);
        if (this.keyPollTimer != null) {
            component.addKeyListener(this.keyPollTimer);
        }
    }

    public WorldWindow getEventSource() {
        return this.worldWindow;
    }

    public void setHoverDelay(int n) {
        this.hoverTimer.setDelay(n);
    }

    public int getHoverDelay() {
        return this.hoverTimer.getDelay();
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.worldWindow == null) {
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.worldWindow == null) {
            return;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.worldWindow == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        View view = this.worldWindow.getView();
        if (view == null) {
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 32) {
            this.interpolatorTimer.stop();
        } else if (n == 78) {
            InterpolatorTimer.ViewProperties viewProperties = new InterpolatorTimer.ViewProperties();
            viewProperties.heading = Angle.fromDegrees(0.0);
            this.getClass();
            this.setViewProperties(view, viewProperties, 0.1, this.viewAngleErrorThreshold, true);
        } else if (n == 82) {
            InterpolatorTimer.ViewProperties viewProperties = new InterpolatorTimer.ViewProperties();
            viewProperties.heading = Angle.fromDegrees(0.0);
            viewProperties.pitch = Angle.fromDegrees(0.0);
            this.getClass();
            this.setViewProperties(view, viewProperties, 0.1, this.viewAngleErrorThreshold, true);
        }
    }

    public void keysPolled(int n, int n2) {
        double d;
        double d2;
        double d3;
        boolean bl;
        if (this.worldWindow == null) {
            return;
        }
        View view = this.worldWindow.getView();
        if (view == null) {
            return;
        }
        int n3 = n2 & 0x200;
        boolean bl2 = bl = n3 != 0;
        if (AWTInputHandler.areModifiersExactly(n2, n3)) {
            Globe globe;
            d3 = view.getHeading().sin();
            d2 = view.getHeading().cos();
            d = 0.0;
            double d4 = 0.0;
            if (n == 37) {
                d = d3;
                d4 = -d2;
            } else if (n == 39) {
                d = -d3;
                d4 = d2;
            } else if (n == 38) {
                d = d2;
                d4 = d3;
            } else if (n == 40) {
                d = -d2;
                d4 = -d3;
            }
            if ((d != 0.0 || d4 != 0.0) && (globe = this.worldWindow.getModel().getGlobe()) != null) {
                LatLon latLon = this.computeViewLatLonChange(view, globe, 10.0 * d, 10.0 * d4, bl);
                this.setViewLatLon(view, this.computeNewViewLatLon(view, latLon.getLatitude(), latLon.getLongitude()));
                return;
            }
        }
        d3 = 0.0;
        d2 = 0.0;
        if (AWTInputHandler.areModifiersExactly(n2, n3)) {
            if (n == 34) {
                d2 = 1.0;
            } else if (n == 33) {
                d2 = -1.0;
            }
        } else if (AWTInputHandler.areModifiersExactly(n2, 0x40 | n3)) {
            if (n == 37) {
                d3 = -1.0;
            } else if (n == 39) {
                d3 = 1.0;
            } else if (n == 38) {
                d2 = -1.0;
            } else if (n == 40) {
                d2 = 1.0;
            }
        }
        if (d3 != 0.0) {
            this.setViewAngle(view, this.computeNewViewHeading(view, this.computeViewAngleChange(4.0 * d3, bl)), null);
            return;
        }
        if (d2 != 0.0) {
            this.setViewAngle(view, null, this.computeNewViewPitch(view, this.computeViewAngleChange(4.0 * d2, bl)));
            return;
        }
        d = 0.0;
        if (AWTInputHandler.areModifiersExactly(n2, n3)) {
            if (n == 107 || n == 61) {
                d = -1.0;
            } else if (n == 109 || n == 45) {
                d = 1.0;
            }
        } else if (AWTInputHandler.areModifiersExactly(n2, 0x80 | n3) || AWTInputHandler.areModifiersExactly(n2, 0x100 | n3)) {
            if (n == 38) {
                d = -1.0;
            } else if (n == 40) {
                d = 1.0;
            }
        }
        if (d != 0.0) {
            this.setViewZoom(view, this.computeNewViewZoom(view, this.computeZoomViewChange(d, bl)));
            return;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.worldWindow == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        View view = this.worldWindow.getView();
        if (view == null) {
            return;
        }
        if (this.lastPickedObjects != null && this.lastPickedObjects.size() > 0) {
            PickedObject pickedObject = this.lastPickedObjects.getTopObject();
            if (pickedObject != null && pickedObject.isTerrain()) {
                InterpolatorTimer.ViewProperties viewProperties = new InterpolatorTimer.ViewProperties();
                Position position = pickedObject.getPosition();
                viewProperties.latLon = new LatLon(position.getLatitude(), position.getLongitude());
                this.getClass();
                this.setViewProperties(view, viewProperties, 0.1, this.viewLatLonErrorThresold, true);
                return;
            }
            if (1 == mouseEvent.getButton()) {
                if (mouseEvent.getClickCount() % 2 == 1) {
                    this.callSelectListeners(new SelectEvent(this.worldWindow, "gov.nasa.worldwind.SelectEvent.LeftClick", mouseEvent, this.lastPickedObjects));
                } else {
                    this.callSelectListeners(new SelectEvent(this.worldWindow, "gov.nasa.worldwind.SelectEvent.LeftDoubleClick", mouseEvent, this.lastPickedObjects));
                }
            } else if (3 == mouseEvent.getButton()) {
                this.callSelectListeners(new SelectEvent(this.worldWindow, "gov.nasa.worldwind.SelectEvent.RightClick", mouseEvent, this.lastPickedObjects));
            }
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.worldWindow == null) {
            return;
        }
        this.cancelHover();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.worldWindow == null) {
            return;
        }
        this.doHover(true);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.worldWindow == null) {
            return;
        }
        this.cancelHover();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.worldWindow == null) {
            return;
        }
        this.cancelHover();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.worldWindow == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        View view = this.worldWindow.getView();
        if (view == null) {
            return;
        }
        if (this.worldWindow.getModel() == null) {
            return;
        }
        java.awt.Point point = new java.awt.Point(mouseEvent.getPoint().x - this.lastMousePoint.x, mouseEvent.getPoint().y - this.lastMousePoint.y);
        if (AWTInputHandler.areModifiersExactly(mouseEvent, 1024)) {
            LatLon latLon = null;
            Position position = view.computePositionFromScreenPoint(this.lastMousePoint.x, this.lastMousePoint.y);
            Position position2 = view.computePositionFromScreenPoint(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            if (position != null && position2 != null) {
                latLon = new LatLon(position.getLatitude().subtract(position2.getLatitude()), position.getLongitude().subtract(position2.getLongitude()));
            } else {
                Globe globe = this.worldWindow.getModel().getGlobe();
                if (globe != null) {
                    double d = view.getHeading().sin();
                    double d2 = view.getHeading().cos();
                    double d3 = d2 * (double)point.y + d * (double)point.x;
                    double d4 = d * (double)point.y - d2 * (double)point.x;
                    latLon = this.computeViewLatLonChange(view, globe, d3, d4, false);
                }
            }
            if (latLon != null) {
                this.setViewLatLon(view, this.computeNewViewLatLon(view, latLon.getLatitude(), latLon.getLongitude()));
            }
        } else if (AWTInputHandler.areModifiersExactly(mouseEvent, 4096) || AWTInputHandler.areModifiersExactly(mouseEvent, 1152)) {
            Component component;
            double d = 1.0;
            Object object = mouseEvent.getSource();
            if (object != null && object instanceof Component && mouseEvent.getPoint().y < (component = (Component)object).getHeight() / 2) {
                d = -1.0;
            }
            this.setViewAngle(view, this.computeNewViewHeading(view, this.computeViewAngleChange(d * (double)point.x, false)), this.computeNewViewPitch(view, this.computeViewAngleChange(point.y, false)));
        }
        this.lastMousePoint = mouseEvent.getPoint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.worldWindow == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.lastMousePoint = mouseEvent.getPoint();
        View view = this.worldWindow.getView();
        if (view == null) {
            return;
        }
        Model model = this.worldWindow.getModel();
        if (model == null) {
            return;
        }
        Globe globe = model.getGlobe();
        if (globe == null) {
            return;
        }
        this.lastPickedObjects = this.worldWindow.pick(mouseEvent.getPoint());
        PickedObject pickedObject = null;
        if (this.lastPickedObjects != null && this.lastPickedObjects.size() > 0) {
            pickedObject = this.lastPickedObjects.getTopObject();
        }
        PickedObjectList pickedObjectList = null;
        if (pickedObject != null && !pickedObject.isTerrain()) {
            pickedObjectList = this.lastPickedObjects;
        }
        this.callSelectListeners(new SelectEvent(this.worldWindow, "gov.nasa.worldwind.SelectEvent.Rollover", mouseEvent, pickedObjectList));
        this.doHover(true);
        Position position = null;
        if (null != pickedObject && pickedObject.hasPosition()) {
            position = pickedObject.getPosition();
        } else if (this.lastPickedObjects != null && this.lastPickedObjects.getTerrainObject() != null) {
            position = this.lastPickedObjects.getTerrainObject().getPosition();
        }
        this.callPositionListeners(new PositionEvent(this.worldWindow, mouseEvent, this.previousPickPosition, position));
        this.previousPickPosition = position;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.worldWindow == null) {
            return;
        }
        if (mouseWheelEvent == null) {
            return;
        }
        View view = this.worldWindow.getView();
        if (view == null) {
            return;
        }
        int n = mouseWheelEvent.getWheelRotation();
        double d = Math.signum(n);
        this.setViewZoom(view, this.computeNewViewZoom(view, this.computeZoomViewChange(d, false)));
    }

    private static boolean areModifiersExactly(InputEvent inputEvent, int n) {
        return AWTInputHandler.areModifiersExactly(inputEvent.getModifiersEx(), n);
    }

    private static boolean areModifiersExactly(int n, int n2) {
        return n == n2;
    }

    private boolean isPickListEmpty(PickedObjectList pickedObjectList) {
        return pickedObjectList == null || pickedObjectList.size() < 1;
    }

    private void doHover(boolean bl) {
        if (!this.isPickListEmpty(this.hoverObjects) && !this.isPickListEmpty(this.lastPickedObjects)) {
            PickedObject pickedObject = this.hoverObjects.getTopObject();
            PickedObject pickedObject2 = this.lastPickedObjects.getTopObject();
            if (pickedObject != null && pickedObject2 != null && pickedObject.getObject().equals(pickedObject2.getObject())) {
                return;
            }
        }
        this.cancelHover();
        if (!bl) {
            return;
        }
        if (null != this.lastPickedObjects && null != this.lastPickedObjects.getTopObject() && this.lastPickedObjects.getTopObject().isTerrain()) {
            return;
        }
        this.hoverObjects = this.lastPickedObjects;
        this.hoverTimer.restart();
    }

    private void cancelHover() {
        if (this.isHovering) {
            this.callSelectListeners(new SelectEvent(this.worldWindow, "gov.nasa.worldwind.SelectEvent.Hover", null, null));
        }
        this.isHovering = false;
        this.hoverObjects = null;
        this.hoverTimer.stop();
    }

    private boolean hoverMatches() {
        if (this.isPickListEmpty(this.lastPickedObjects) || this.isPickListEmpty(this.hoverObjects)) {
            return false;
        }
        PickedObject pickedObject = this.lastPickedObjects.getTopObject();
        if (null != pickedObject && pickedObject.isTerrain()) {
            return false;
        }
        PickedObject pickedObject2 = this.hoverObjects.getTopObject();
        if (pickedObject == null || pickedObject2 == null || pickedObject.getObject() == null || pickedObject2.getObject() == null) {
            return false;
        }
        return pickedObject.getObject().equals(pickedObject2.getObject());
    }

    public void addSelectListener(SelectListener selectListener) {
        this.eventListeners.add(SelectListener.class, selectListener);
    }

    public void removeSelectListener(SelectListener selectListener) {
        this.eventListeners.remove(SelectListener.class, selectListener);
    }

    public void addPositionListener(PositionListener positionListener) {
        this.eventListeners.add(PositionListener.class, positionListener);
    }

    public void removePositionListener(PositionListener positionListener) {
        this.eventListeners.remove(PositionListener.class, positionListener);
    }

    private void callSelectListeners(SelectEvent selectEvent) {
        for (SelectListener selectListener : (SelectListener[])this.eventListeners.getListeners(SelectListener.class)) {
            selectListener.selected(selectEvent);
        }
    }

    private void callPositionListeners(PositionEvent positionEvent) {
        for (PositionListener positionListener : (PositionListener[])this.eventListeners.getListeners(PositionListener.class)) {
            positionListener.moved(positionEvent);
        }
    }

    private void setViewProperties(final View view, InterpolatorTimer.ViewProperties viewProperties, double d, double d2, boolean bl) {
        if (view == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ViewIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (viewProperties == null) {
            String string = WorldWind.retrieveErrMsg("awt.InterpolatorTimer.ViewPropertiesIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (bl || this.smoothViewChange) {
            if (this.viewPropertyListener == null) {
                this.viewPropertyListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object = propertyChangeEvent.getNewValue();
                        if (object == null) {
                            AWTInputHandler.this.viewTarget = null;
                        } else if (object instanceof InterpolatorTimer.ViewProperties) {
                            InterpolatorTimer.ViewProperties viewProperties = (InterpolatorTimer.ViewProperties)object;
                            if (viewProperties.latLon != null) {
                                view.goToLatLon(viewProperties.latLon);
                            }
                            if (viewProperties.heading != null) {
                                view.setHeading(viewProperties.heading);
                            }
                            if (viewProperties.pitch != null) {
                                view.setPitch(viewProperties.pitch);
                            }
                            if (viewProperties.zoom != null) {
                                view.setZoom(viewProperties.zoom);
                            }
                            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
                        }
                    }
                };
            }
            InterpolatorTimer.ViewProperties viewProperties2 = new InterpolatorTimer.ViewProperties();
            if (viewProperties.latLon != null) {
                viewProperties2.latLon = new LatLon(view.getPosition().getLatitude(), view.getPosition().getLongitude());
            }
            if (viewProperties.heading != null) {
                viewProperties2.heading = view.getHeading();
            }
            if (viewProperties.pitch != null) {
                viewProperties2.pitch = view.getPitch();
            }
            if (viewProperties.zoom != null) {
                viewProperties2.zoom = view.getZoom();
            }
            this.viewTarget = viewProperties;
            this.interpolatorTimer.start(d, d2, viewProperties2, viewProperties, this.viewPropertyListener);
        } else {
            this.viewTarget = null;
            this.interpolatorTimer.stop();
            if (viewProperties.latLon != null) {
                view.goToLatLon(viewProperties.latLon);
            }
            if (viewProperties.heading != null) {
                view.setHeading(viewProperties.heading);
            }
            if (viewProperties.pitch != null) {
                view.setPitch(viewProperties.pitch);
            }
            if (viewProperties.zoom != null) {
                view.setZoom(viewProperties.zoom);
            }
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    private void setViewLatLon(View view, LatLon latLon) {
        if (latLon == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatLonIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.viewTarget = new InterpolatorTimer.ViewProperties();
        this.viewTarget.latLon = latLon;
        this.setViewProperties(view, this.viewTarget, this.viewLatLonStepCoefficient, this.viewLatLonErrorThresold, false);
    }

    private LatLon computeNewViewLatLon(View view, Angle angle, Angle angle2) {
        double d;
        double d2;
        if (this.viewTarget != null && this.viewTarget.latLon != null) {
            d2 = this.viewTarget.latLon.getLatitude().getDegrees();
            d = this.viewTarget.latLon.getLongitude().getDegrees();
        } else {
            d2 = view.getPosition().getLatitude().getDegrees();
            d = view.getPosition().getLongitude().getDegrees();
        }
        d2 += angle.getDegrees();
        d += angle2.getDegrees();
        if (d2 < -90.0) {
            d2 = -90.0;
        } else if (d2 > 90.0) {
            d2 = 90.0;
        }
        if (d < -180.0) {
            d += 360.0;
        } else if (d > 180.0) {
            d -= 360.0;
        }
        return LatLon.fromDegrees(d2, d);
    }

    private LatLon computeViewLatLonChange(View view, Globe globe, double d, double d2, boolean bl) {
        Point point = view.getEyePoint();
        if (point == null) {
            return null;
        }
        double d3 = AWTInputHandler.clamp(point.length() / globe.getMaximumRadius() - 1.0, 0.0, 1.0);
        double d4 = ((1.0 - d3) * this.viewLatLonMinChangeFactor + d3 * this.viewLatLonMaxChangeFactor) * (bl ? 0.25 : 1.0);
        return LatLon.fromDegrees(d * d4, d2 * d4);
    }

    private void setViewAngle(View view, Angle angle, Angle angle2) {
        if (angle == null && angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.viewTarget = new InterpolatorTimer.ViewProperties();
        this.viewTarget.heading = angle;
        this.viewTarget.pitch = angle2;
        this.setViewProperties(view, this.viewTarget, this.viewAngleStepCoefficient, this.viewAngleErrorThreshold, false);
    }

    private Angle computeNewViewHeading(View view, Angle angle) {
        double d = this.viewTarget != null && this.viewTarget.heading != null ? this.viewTarget.heading.getDegrees() : view.getHeading().getDegrees();
        if ((d += angle.getDegrees()) < 0.0) {
            d += 360.0;
        } else if (d > 360.0) {
            d -= 360.0;
        }
        return Angle.fromDegrees(d);
    }

    private Angle computeViewAngleChange(double d, boolean bl) {
        return Angle.fromDegrees(d * this.viewAngleChangeFactor * (bl ? 0.25 : 1.0));
    }

    private Angle computeNewViewPitch(View view, Angle angle) {
        double d = this.viewTarget != null && this.viewTarget.pitch != null ? this.viewTarget.pitch.getDegrees() : view.getPitch().getDegrees();
        Angle[] angleArray = view.getPitchConstraints();
        return Angle.fromDegrees(AWTInputHandler.clamp(d += angle.getDegrees(), angleArray[0].getDegrees(), angleArray[1].getDegrees()));
    }

    private void setViewZoom(View view, double d) {
        this.viewTarget = new InterpolatorTimer.ViewProperties();
        this.viewTarget.zoom = d;
        this.getClass();
        this.setViewProperties(view, this.viewTarget, 0.1, this.viewZoomErrorThreshold, false);
    }

    private double computeNewViewZoom(View view, double d) {
        double d2 = this.viewTarget != null && this.viewTarget.zoom != null ? Math.log(this.viewTarget.zoom) : Math.log(view.getZoom());
        double[] dArray = view.getZoomConstraints();
        return AWTInputHandler.clamp(Math.exp(d2 += d), dArray[0], dArray[1]);
    }

    private double computeZoomViewChange(double d, boolean bl) {
        return d * this.viewZoomChangeFactor * (bl ? 0.25 : 1.0);
    }

    private static double clamp(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }
}

