/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.InputHandler;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.PickedObjectList;
import gov.nasa.worldwind.PositionListener;
import gov.nasa.worldwind.RenderingListener;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.SelectListener;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWRuntimeException;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.WorldWindowGLAutoDrawable;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.util.logging.Level;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;

public class WorldWindowGLCanvas
extends GLCanvas
implements WorldWindow {
    private static final GLCapabilities caps = new GLCapabilities();
    private final WorldWindowGLAutoDrawable wwd;
    private InputHandler inputHandler;

    public WorldWindowGLCanvas() {
        super(caps);
        try {
            this.wwd = new WorldWindowGLAutoDrawable(this);
            this.createView();
            this.createDefaultInputHandler();
        }
        catch (Exception exception) {
            String string = WorldWind.retrieveErrMsg("awt.WorldWindowGLSurface.UnabletoCreateWindow");
            WorldWind.logger().log(Level.FINE, string);
            throw new WWRuntimeException(string, exception);
        }
    }

    public WorldWindowGLCanvas(WorldWindowGLCanvas worldWindowGLCanvas) {
        super(caps, null, worldWindowGLCanvas.getContext(), null);
        try {
            this.wwd = new WorldWindowGLAutoDrawable(this);
            this.createView();
            this.createDefaultInputHandler();
        }
        catch (Exception exception) {
            String string = WorldWind.retrieveErrMsg("awt.WorldWindowGLSurface.UnabletoCreateWindow");
            WorldWind.logger().log(Level.FINE, string);
            throw new WWRuntimeException(string, exception);
        }
    }

    public WorldWindowGLCanvas(WorldWindowGLCanvas worldWindowGLCanvas, GraphicsDevice graphicsDevice) {
        super(caps, null, worldWindowGLCanvas.getContext(), graphicsDevice);
        if (graphicsDevice == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DeviceIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        try {
            this.wwd = new WorldWindowGLAutoDrawable(this);
            this.createView();
            this.createDefaultInputHandler();
        }
        catch (Exception exception) {
            String string = WorldWind.retrieveErrMsg("awt.WorldWindowGLSurface.UnabletoCreateWindow");
            WorldWind.logger().log(Level.FINE, string);
            throw new WWRuntimeException(string, exception);
        }
    }

    private void createView() {
        this.setView((View)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ViewClassName"));
    }

    private void createDefaultInputHandler() {
        this.inputHandler = (InputHandler)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.InputHandlerClassName");
        this.inputHandler.setEventSource(this);
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        if (this.inputHandler != null) {
            this.inputHandler.setEventSource(null);
        }
        this.inputHandler = inputHandler;
        if (this.inputHandler != null) {
            this.inputHandler.setEventSource(this);
        }
    }

    public SceneController getSceneController() {
        return this.wwd.getSceneController();
    }

    public PickedObjectList pick(Point point) {
        return this.wwd.pick(point);
    }

    public void setModel(Model model) {
        this.wwd.setModel(model);
    }

    public Model getModel() {
        return this.wwd.getModel();
    }

    public void setView(View view) {
        if (view != null) {
            this.wwd.setView(view);
        }
    }

    public View getView() {
        return this.wwd.getView();
    }

    public void setModelAndView(Model model, View view) {
        this.setModel(model);
        this.setView(view);
    }

    public void addRenderingListener(RenderingListener renderingListener) {
        this.wwd.addRenderingListener(renderingListener);
    }

    public void removeRenderingListener(RenderingListener renderingListener) {
        this.wwd.removeRenderingListener(renderingListener);
    }

    public void addSelectListener(SelectListener selectListener) {
        this.inputHandler.addSelectListener(selectListener);
    }

    public void removeSelectListener(SelectListener selectListener) {
        this.inputHandler.removeSelectListener(selectListener);
    }

    public void addPositionListener(PositionListener positionListener) {
        this.inputHandler.addPositionListener(positionListener);
    }

    public void removePositionListener(PositionListener positionListener) {
        this.inputHandler.removePositionListener(positionListener);
    }

    static {
        caps.setAlphaBits(8);
        caps.setRedBits(8);
        caps.setGreenBits(8);
        caps.setBlueBits(8);
        caps.setDepthBits(24);
    }
}

