/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.gpx;

import gov.nasa.worldwind.WorldWind;
import java.util.logging.Level;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementParser {
    protected final String elementName;
    protected ElementParser currentElement = null;
    protected String currentCharacters = null;

    protected ElementParser(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.ElementNameIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        this.elementName = string;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string == null) {
            String string4 = WorldWind.retrieveErrMsg("nullValue.URIIsNull");
            WorldWind.logger().log(Level.FINE, string4);
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            String string5 = WorldWind.retrieveErrMsg("nullValue.LNameIsNull");
            WorldWind.logger().log(Level.FINE, string5);
            throw new IllegalArgumentException(string5);
        }
        if (string3 == null) {
            String string6 = WorldWind.retrieveErrMsg("nullValue.QNameIsNull");
            WorldWind.logger().log(Level.FINE, string6);
            throw new IllegalArgumentException(string6);
        }
        if (attributes == null) {
            String string7 = WorldWind.retrieveErrMsg("nullValue.org.xml.sax.AttributesIsNull");
            WorldWind.logger().log(Level.FINE, string7);
            throw new IllegalArgumentException(string7);
        }
        if (this.currentElement != null) {
            this.currentElement.startElement(string, string2, string3, attributes);
        } else {
            this.doStartElement(string, string2, string3, attributes);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string == null) {
            String string4 = WorldWind.retrieveErrMsg("nullValue.URIIsNull");
            WorldWind.logger().log(Level.FINE, string4);
            throw new IllegalArgumentException(string4);
        }
        if (string2 == null) {
            String string5 = WorldWind.retrieveErrMsg("nullValue.LNameIsNull");
            WorldWind.logger().log(Level.FINE, string5);
            throw new IllegalArgumentException(string5);
        }
        if (string3 == null) {
            String string6 = WorldWind.retrieveErrMsg("nullValue.QNameIsNull");
            WorldWind.logger().log(Level.FINE, string6);
            throw new IllegalArgumentException(string6);
        }
        if (this.currentElement != null) {
            this.currentElement.endElement(string, string2, string3);
            if (string2.equalsIgnoreCase(this.currentElement.elementName)) {
                this.currentElement = null;
            }
        }
        this.doEndElement(string, string2, string3);
        this.currentCharacters = null;
    }

    protected void doStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
    }

    protected void doEndElement(String string, String string2, String string3) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) {
        if (cArray == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ArrayIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (cArray.length < 1) {
            String string = WorldWind.retrieveErrMsg("generic.arrayInvalidLength") + WorldWind.retrieveErrMsg("punctuation.space") + cArray.length;
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n2 < 0) {
            String string = WorldWind.retrieveErrMsg("generic.indexOutOfRange");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (n + n2 > cArray.length) {
            String string = WorldWind.retrieveErrMsg("generic.indexOutOfRange") + WorldWind.retrieveErrMsg("punctuation.space") + String.valueOf(n + n2);
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (this.currentElement != null) {
            this.currentElement.characters(cArray, n, n2);
        } else {
            this.currentCharacters = this.currentCharacters != null ? this.currentCharacters + new String(cArray, n, n2) : new String(cArray, n, n2);
        }
    }
}

