/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.gpx;

import gov.nasa.worldwind.Track;
import gov.nasa.worldwind.TrackPoint;
import gov.nasa.worldwind.TrackSegment;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.formats.gpx.ElementParser;
import gov.nasa.worldwind.formats.gpx.GpxTrack;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpxReader {
    private SAXParser parser;
    private List<Track> tracks = new ArrayList<Track>();

    public GpxReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        this.parser = sAXParserFactory.newSAXParser();
    }

    public void readFile(String string) throws IOException, SAXException {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.PathIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = WorldWind.retrieveErrMsg("generic.fileNotFound");
            WorldWind.logger().log(Level.FINE, string3);
            throw new FileNotFoundException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.doRead(fileInputStream);
    }

    public void readStream(InputStream inputStream) throws IOException, SAXException {
        if (inputStream == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.InputStreamIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.doRead(inputStream);
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    private void doRead(InputStream inputStream) throws IOException, SAXException {
        this.parser.parse(inputStream, (DefaultHandler)new Handler());
    }

    public static void main(String[] stringArray) {
        try {
            GpxReader gpxReader = new GpxReader();
            gpxReader.readFile("src/worldwinddemo/track data/20061126.gpx");
            System.out.printf("%d tracks\n", gpxReader.getTracks().size());
            for (Track track : gpxReader.getTracks()) {
                System.out.printf("GpxTrack %d segments\n", track.getSegments().size());
                int n = 0;
                for (TrackSegment trackSegment : track.getSegments()) {
                    System.out.printf("\tSegment %d, %d points\n", n++, trackSegment.getPoints().size());
                    int n2 = 0;
                    for (TrackPoint trackPoint : trackSegment.getPoints()) {
                        System.out.printf("\t\t%4d: %s\n", n2++, trackPoint);
                    }
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private class Handler
    extends DefaultHandler {
        private ElementParser currentElement = null;

        private Handler() {
        }

        public void startDocument() throws SAXException {
            super.startDocument();
        }

        public void endDocument() throws SAXException {
            super.endDocument();
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            sAXParseException.printStackTrace();
            super.warning(sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            sAXParseException.printStackTrace();
            super.error(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            sAXParseException.printStackTrace();
            super.fatalError(sAXParseException);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.currentElement != null) {
                this.currentElement.startElement(string, string2, string3, attributes);
            } else if (string2.equalsIgnoreCase("trk")) {
                GpxTrack gpxTrack = new GpxTrack(string, string2, string3, attributes);
                this.currentElement = gpxTrack;
                GpxReader.this.tracks.add(gpxTrack);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.currentElement != null) {
                this.currentElement.endElement(string, string2, string3);
                if (string2.equalsIgnoreCase(this.currentElement.getElementName())) {
                    this.currentElement = null;
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.currentElement != null) {
                this.currentElement.characters(cArray, n, n2);
            }
        }
    }
}

