/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.gpx;

import gov.nasa.worldwind.TrackPoint;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.formats.gpx.ElementParser;
import java.util.logging.Level;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GpxTrackPoint
extends ElementParser
implements TrackPoint {
    private double latitude;
    private double longitude;
    private double elevation;
    private String time;

    public GpxTrackPoint(String string, String string2, String string3, Attributes attributes) {
        super("trkpt");
        if (attributes == null) {
            String string4 = WorldWind.retrieveErrMsg("nullValue.org.xml.sax.AttributesIsNull");
            WorldWind.logger().log(Level.FINE, string4);
            throw new IllegalArgumentException(string4);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string5 = attributes.getLocalName(i);
            String string6 = attributes.getValue(i);
            if (string5.equalsIgnoreCase("lat")) {
                this.latitude = Double.parseDouble(string6);
                continue;
            }
            if (!string5.equalsIgnoreCase("lon")) continue;
            this.longitude = Double.parseDouble(string6);
        }
    }

    public void doStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
    }

    public void doEndElement(String string, String string2, String string3) throws SAXException {
        if (string2 == null) {
            String string4 = WorldWind.retrieveErrMsg("nullValue.LNameIsNull");
            WorldWind.logger().log(Level.FINE, string4);
            throw new IllegalArgumentException(string4);
        }
        if (string2.equalsIgnoreCase("ele")) {
            this.elevation = Double.parseDouble(this.currentCharacters);
        } else if (string2.equalsIgnoreCase("time")) {
            this.time = this.currentCharacters.trim();
        }
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double d) {
        if (d > 90.0 || d < -90.0) {
            String string = WorldWind.retrieveErrMsg("generic.angleOutOfRange") + WorldWind.retrieveErrMsg("punctuation.space") + d;
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = d;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double d) {
        if (d > 180.0 || d < -180.0) {
            String string = WorldWind.retrieveErrMsg("generic.angleOutOfRange") + WorldWind.retrieveErrMsg("punctuation.space") + d;
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.longitude = d;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double d) {
        this.elevation = d;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.TimeIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        this.time = string;
    }

    public String toString() {
        return String.format("(%10.6f\u00b0, %11.6f\u00b0, %10.4g m, %s)", this.latitude, this.longitude, this.elevation, this.time);
    }
}

