/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.StringUtil;
import gov.nasa.worldwind.formats.nitfs.Cadrg2DdsCompress;
import gov.nasa.worldwind.formats.nitfs.Cib2DdsCompress;
import gov.nasa.worldwind.formats.nitfs.CompressionLookupRecord;
import gov.nasa.worldwind.formats.nitfs.NitfsImageBand;
import gov.nasa.worldwind.formats.nitfs.NitfsRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NitfsSegment;
import gov.nasa.worldwind.formats.nitfs.NitfsSegmentType;
import gov.nasa.worldwind.formats.nitfs.NitfsUtil;
import gov.nasa.worldwind.formats.nitfs.UserDefinedImageSubheader;
import gov.nasa.worldwind.formats.rpf.RpfFrameFileComponents;
import gov.nasa.worldwind.formats.rpf.RpfImageType;
import gov.nasa.worldwind.formats.rpf.RpfLocationSection;
import gov.nasa.worldwind.geom.LatLon;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class NitfsImageSegment
extends NitfsSegment {
    public static final String[] SupportedFormats = new String[]{"CIB", "CADRG", "ADRG"};
    public String partType;
    public String imageID;
    public String dateTime;
    public String targetID;
    public String imageTitle;
    public String securityClass;
    public String codewords;
    public String controlAndHandling;
    public String releaseInstructions;
    public String classAuthority;
    public String securityCtrlNum;
    public String ISDWNG;
    public String ISDEVT;
    public short encryption;
    public String imageSource;
    public int numSignificantRows;
    public int numSignificantCols;
    public String pixelValueType;
    public String imageRepresentation;
    public String imageCategory;
    public short bitsPerPixelPerBand;
    public String pixelJustification;
    public String imageCoordSystem;
    public LatLon[] imageCoords;
    public String[] imageCommentRecords;
    public String imageCompression;
    public String compressionRateCode;
    public short NBANDS;
    public NitfsImageBand[] imageBands;
    public short imageSyncCode;
    public String imageMode;
    public short numOfBlocksPerRow;
    public short numOfBlocksPerCol;
    public short numOfPixelsPerBlockH;
    public short numOfPixelsPerBlockV;
    public short numOfBitsPerPixelPerBand;
    public short displayLevel;
    public short attachmentLevel;
    public short imageRowOffset;
    public short imageColOffset;
    public String imageMagnification;
    public short userDefinedSubheaderLength;
    private UserDefinedImageSubheader userDefSubheader;
    private long numOfImageRows;
    private long numOfImageCodesPerRow;
    private short imageCodeBitLength;
    private int compressionAlgorithmID;
    private int numOfCompressionLookupOffsetRecords;
    private int numOfCompressionParameterOffsetRecords;
    private long compressionLookupOffsetTableOffset;
    private int compressionLookupTableOffsetRecordLength;
    private int subframeSequenceRecordLength;
    private int transparencySequenceRecordLength;
    private int transparentOutputPixelCodeLength;
    private byte[] transparentOutputPixelCode;
    private int[] subFrameOffsets = null;
    private boolean hasTransparentPixels = false;
    private boolean hasMaskedSubframes = false;
    private CompressionLookupRecord[] compressionLUTS;

    public static String[] getSupportedFormats() {
        return SupportedFormats;
    }

    public boolean hasTransparentPixels() {
        return this.hasTransparentPixels;
    }

    public boolean hasMaskedSubframes() {
        return this.hasMaskedSubframes;
    }

    public UserDefinedImageSubheader getUserDefinedImageSubheader() {
        return this.userDefSubheader;
    }

    public RpfFrameFileComponents getRpfFrameFileComponents() {
        return null != this.userDefSubheader ? this.userDefSubheader.getRpfFrameFileComponents() : null;
    }

    public NitfsImageSegment(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        super(NitfsSegmentType.ImageSegment, byteBuffer, n, n2, n3, n4);
        int n5 = byteBuffer.position();
        byteBuffer.position(n);
        this.parseIdentificationSecurityStructureFields(byteBuffer);
        this.parseImageGeographicLocation(byteBuffer);
        this.parseCommentRecords(byteBuffer);
        this.parseImageCompressionStructure(byteBuffer);
        this.parseImageBands(byteBuffer);
        this.parseImageTableStructure(byteBuffer);
        this.parseImageLocation(byteBuffer);
        this.parseImageSubheaders(byteBuffer);
        this.parseImageData(byteBuffer);
        this.validateImage();
        byteBuffer.position(n5);
    }

    private void decompressBlock4x4(byte[][] byArray, short s) {
        this.compressionLUTS[0].copyValues(byArray[0], 0, s, 4);
        this.compressionLUTS[1].copyValues(byArray[1], 0, s, 4);
        this.compressionLUTS[2].copyValues(byArray[2], 0, s, 4);
        this.compressionLUTS[3].copyValues(byArray[3], 0, s, 4);
    }

    private void decompressBlock16(byte[] byArray, short s) {
        this.compressionLUTS[0].copyValues(byArray, 0, s, 4);
        this.compressionLUTS[1].copyValues(byArray, 4, s, 4);
        this.compressionLUTS[2].copyValues(byArray, 8, s, 4);
        this.compressionLUTS[3].copyValues(byArray, 12, s, 4);
    }

    /*
     * Unable to fully structure code
     */
    public ByteBuffer getImageAsDdsTexture() throws NitfsRuntimeException {
        var1_1 = this.getRpfFrameFileComponents();
        var2_2 = var1_1.componentLocationTable;
        var3_3 = var2_2.getSpatialDataSubsectionLocation();
        this.buffer.position(var3_3);
        var7_4 = new short[(int)this.numOfImageCodesPerRow];
        var8_5 = new byte[16];
        var9_6 = (int)(this.numOfImageCodesPerRow * (long)this.imageCodeBitLength / 8L);
        var10_7 = new byte[var9_6];
        var12_8 = 0;
        var13_9 = 0;
        var14_10 = this.imageBands[var13_9];
        var15_11 = 1 == var14_10.getNumOfLookupTables() ? new Cib2DdsCompress() : new Cadrg2DdsCompress();
        v0 = var16_12 = this.hasTransparentPixels != false || this.hasMaskedSubframes != false;
        if (var16_12) {
            // empty if block
        }
        var17_13 = 128 + this.numSignificantCols * this.numSignificantRows / 2;
        var18_14 = ByteBuffer.allocateDirect(var17_13);
        var18_14.order(ByteOrder.LITTLE_ENDIAN);
        var15_11.writeDxt1Header(var18_14, this.numSignificantCols, this.numSignificantRows);
        var19_15 = var18_14.position();
        for (var20_16 = 0; var20_16 < this.numOfBlocksPerCol; ++var20_16) {
            var21_21 = 0;
            while (var21_21 < this.numOfBlocksPerRow) {
                var22_22 = (int)((long)var20_16 * var1_1.numOfOutputRowsPerSubframe);
                var23_23 = (int)((long)var21_21 * var1_1.numOfOutputColumnsPerSubframe);
                if (!this.hasMaskedSubframes) ** GOTO lbl48
                var11_20 = this.subFrameOffsets[var12_8];
                if (-1 == var11_20) {
                    var24_24 = var15_11.getDxt1TransparentBlock4x4();
                    var25_26 = 0;
                    while ((long)var25_26 < this.numOfImageRows) {
                        var26_27 = var22_22 + var25_26 * 4;
                        var27_28 = 0;
                        while ((long)var27_28 < this.numOfImageCodesPerRow) {
                            var28_29 = var23_23 + var27_28 * 4;
                            var18_14.position(var19_15 + var26_27 * this.numSignificantCols / 2 + 2 * var28_29);
                            var24_24.writeTo(var18_14);
                            ++var27_28;
                        }
                        ++var25_26;
                    }
                } else {
                    this.buffer.position(var3_3 + var11_20);
lbl48:
                    // 2 sources

                    var24_25 = 0;
                    while ((long)var24_25 < this.numOfImageRows) {
                        var25_26 = var22_22 + var24_25 * 4;
                        this.buffer.get(var10_7, 0, var9_6);
                        var27_28 = 0;
                        var28_30 = 0;
                        for (var26_27 = 0; var26_27 < (int)this.numOfImageCodesPerRow / 2; ++var26_27) {
                            var4_17 = (short)((255 & (short)var10_7[var28_30++]) << 4);
                            var5_18 = (short)(255 & (short)var10_7[var28_30++]);
                            var6_19 = (short)(255 & (short)var10_7[var28_30++]);
                            var7_4[var27_28++] = (short)(var4_17 | (240 & var5_18) >> 4);
                            var7_4[var27_28++] = (short)(var6_19 | (15 & var5_18) << 8);
                        }
                        var26_27 = 0;
                        while ((long)var26_27 < this.numOfImageCodesPerRow) {
                            var27_28 = var23_23 + var26_27 * 4;
                            this.decompressBlock16(var8_5, var7_4[var26_27]);
                            var28_31 = var15_11.compressDxt1Block4x4(var14_10, var8_5, false);
                            var18_14.position(var19_15 + var25_26 * this.numSignificantCols / 2 + 2 * var27_28);
                            var28_31.writeTo(var18_14);
                            ++var26_27;
                        }
                        ++var24_25;
                    }
                }
                ++var21_21;
                var12_8 = (short)(var12_8 + 1);
            }
        }
        return var18_14;
    }

    public IntBuffer getImagePixelsAsArray(IntBuffer intBuffer, RpfImageType rpfImageType) throws NitfsRuntimeException {
        RpfFrameFileComponents rpfFrameFileComponents = this.getRpfFrameFileComponents();
        RpfLocationSection rpfLocationSection = rpfFrameFileComponents.componentLocationTable;
        int n = rpfLocationSection.getSpatialDataSubsectionLocation();
        this.buffer.position(n);
        int n2 = 0;
        NitfsImageBand nitfsImageBand = this.imageBands[n2];
        short[] sArray = new short[(int)this.numOfImageCodesPerRow];
        byte[][] byArray = new byte[4][4];
        short s = (short)(this.numOfImageCodesPerRow * (long)this.imageCodeBitLength / 8L);
        byte[] byArray2 = new byte[s];
        int n3 = 0;
        for (int i = 0; i < this.numOfBlocksPerCol; ++i) {
            int n4 = 0;
            while (n4 < this.numOfBlocksPerRow) {
                block15: {
                    int n5;
                    int n6;
                    block14: {
                        n6 = (int)((long)i * rpfFrameFileComponents.numOfOutputRowsPerSubframe);
                        n5 = (int)((long)n4 * rpfFrameFileComponents.numOfOutputColumnsPerSubframe);
                        if (!this.hasMaskedSubframes) break block14;
                        int n7 = this.subFrameOffsets[n3];
                        if (-1 == n7) break block15;
                        this.buffer.position(n + n7);
                    }
                    int n8 = 0;
                    while ((long)n8 < this.numOfImageRows) {
                        int n9;
                        int n10 = n6 + n8 * 4;
                        this.buffer.get(byArray2, 0, s);
                        int n11 = 0;
                        int n12 = 0;
                        for (n9 = 0; n9 < (int)this.numOfImageCodesPerRow / 2; ++n9) {
                            short s2 = (short)((0xFF & (short)byArray2[n12++]) << 4);
                            short s3 = (short)(0xFF & (short)byArray2[n12++]);
                            short s4 = (short)(0xFF & (short)byArray2[n12++]);
                            sArray[n11++] = (short)(s2 | (0xF0 & s3) >> 4);
                            sArray[n11++] = (short)(s4 | (0xF & s3) << 8);
                        }
                        n9 = 0;
                        while ((long)n9 < this.numOfImageCodesPerRow) {
                            this.decompressBlock4x4(byArray, sArray[n9]);
                            n11 = n5 + n9 * 4;
                            for (n12 = 0; n12 < 4; ++n12) {
                                for (int j = 0; j < 4; ++j) {
                                    int n13 = 0xFF & byArray[n12][j];
                                    int n14 = nitfsImageBand.lookupRGB(n13);
                                    switch (rpfImageType) {
                                        case IMAGE_TYPE_ALPHA_RGB: {
                                            n14 = -16777216 + n14;
                                            break;
                                        }
                                        case IMAGE_TYPE_GRAY_ALPHA: {
                                            n14 = (n14 << 8) + 255;
                                            break;
                                        }
                                        case IMAGE_TYPE_RGB_ALPHA: {
                                            n14 = (n14 << 8) + 255;
                                        }
                                    }
                                    intBuffer.put((n10 + n12) * this.numSignificantCols + (n11 + j), n14);
                                }
                            }
                            ++n9;
                        }
                        ++n8;
                    }
                }
                ++n4;
                n3 = (short)(n3 + 1);
            }
        }
        return intBuffer;
    }

    private void validateImage() throws NitfsRuntimeException {
        RpfFrameFileComponents rpfFrameFileComponents = this.getRpfFrameFileComponents();
        if (1 != this.compressionAlgorithmID) {
            throw new NitfsRuntimeException("NitfsReader.UnsupportedCompressionAlgorithm");
        }
        if (!StringUtil.Equals(this.imageMode, "B")) {
            throw new NitfsRuntimeException("NitfsReader.UnsupportedImageMode");
        }
        if (1 != rpfFrameFileComponents.numOfSpectralGroups) {
            throw new NitfsRuntimeException("NitfsReader.UnsupportedNumberOfSpectralGroups.");
        }
        if (12 != this.imageCodeBitLength) {
            throw new NitfsRuntimeException("NitfsReader.UnsupportedImageCodeBitLength.");
        }
    }

    private void parseRpfMaskSubsection(ByteBuffer byteBuffer) throws NitfsRuntimeException {
        this.subframeSequenceRecordLength = NitfsUtil.getUShort(byteBuffer);
        this.transparencySequenceRecordLength = NitfsUtil.getUShort(byteBuffer);
        this.transparentOutputPixelCodeLength = NitfsUtil.getUShort(byteBuffer);
        if (0 != this.transparentOutputPixelCodeLength) {
            this.transparentOutputPixelCode = new byte[this.transparentOutputPixelCodeLength];
            byteBuffer.get(this.transparentOutputPixelCode, 0, this.transparentOutputPixelCodeLength);
        }
        if (0 < this.subframeSequenceRecordLength) {
            RpfFrameFileComponents rpfFrameFileComponents = this.getRpfFrameFileComponents();
            this.subFrameOffsets = new int[this.numOfBlocksPerCol * this.numOfBlocksPerRow];
            int n = 0;
            for (int i = 0; i < rpfFrameFileComponents.numOfSpectralGroups; ++i) {
                for (int j = 0; j < this.numOfBlocksPerCol; ++j) {
                    for (int k = 0; k < this.numOfBlocksPerRow; ++k) {
                        this.subFrameOffsets[n++] = (int)NitfsUtil.getUInt(byteBuffer);
                    }
                }
            }
            this.hasMaskedSubframes = null != this.subFrameOffsets && 0 < this.subFrameOffsets.length;
        } else {
            this.subFrameOffsets = null;
        }
        this.hasMaskedSubframes = null != this.subFrameOffsets && 0 < this.subFrameOffsets.length;
        this.hasTransparentPixels = 0 < this.transparencySequenceRecordLength;
    }

    private void parseImageData(ByteBuffer byteBuffer) throws NitfsRuntimeException {
        RpfLocationSection rpfLocationSection = this.getRpfFrameFileComponents().componentLocationTable;
        byteBuffer.position(this.dataStartOffset);
        long l = NitfsUtil.getUInt(byteBuffer);
        if (0 < rpfLocationSection.getMaskSubsectionLength()) {
            byteBuffer.position(rpfLocationSection.getMaskSubsectionLocation());
            this.parseRpfMaskSubsection(byteBuffer);
        }
        if (0 >= rpfLocationSection.getImageDisplayParametersSubheaderLength()) {
            throw new NitfsRuntimeException("NitfsReader.ImageDisplayParametersSubheaderNotFound");
        }
        byteBuffer.position(rpfLocationSection.getImageDisplayParametersSubheaderLocation());
        this.parseImageDisplayParametersSubheader(byteBuffer);
        if (0 >= rpfLocationSection.getCompressionSectionSubheaderLength()) {
            throw new NitfsRuntimeException("NitfsReader.RpfCompressionSectionSubheaderNotFound");
        }
        byteBuffer.position(rpfLocationSection.getCompressionSectionSubheaderLocation());
        this.parseRpfCompressionSectionSubheader(byteBuffer);
        if (0 >= rpfLocationSection.getCompressionLookupSubsectionLength()) {
            throw new NitfsRuntimeException("NitfsReader.RpfCompressionLookupSubsectionNotFound");
        }
        byteBuffer.position(rpfLocationSection.getCompressionLookupSubsectionLocation());
        this.parseRpfCompressionLookupSubsection(byteBuffer);
        if (0 < rpfLocationSection.getCompressionParameterSubsectionLength()) {
            throw new NitfsRuntimeException("NitfsReader.RpfCompressionParameterSubsectionNotImplemented");
        }
        if (0 >= rpfLocationSection.getSpatialDataSubsectionLength()) {
            throw new NitfsRuntimeException("NitfsReader.RpfSpatialDataSubsectionNotFound");
        }
        byteBuffer.position(rpfLocationSection.getSpatialDataSubsectionLocation());
        this.parseRpfSpatialDataSubsection(byteBuffer);
    }

    private void parseRpfSpatialDataSubsection(ByteBuffer byteBuffer) throws NitfsRuntimeException {
    }

    private void parseRpfCompressionLookupSubsection(ByteBuffer byteBuffer) throws NitfsRuntimeException {
        int n = byteBuffer.position();
        this.compressionLookupOffsetTableOffset = NitfsUtil.getUInt(byteBuffer);
        this.compressionLookupTableOffsetRecordLength = NitfsUtil.getUShort(byteBuffer);
        this.compressionLUTS = new CompressionLookupRecord[this.numOfCompressionLookupOffsetRecords];
        for (int i = 0; i < this.numOfCompressionLookupOffsetRecords; ++i) {
            this.compressionLUTS[i] = new CompressionLookupRecord(byteBuffer, n, this.getRpfFrameFileComponents().rpfColorMaps);
        }
    }

    private void parseRpfCompressionSectionSubheader(ByteBuffer byteBuffer) throws NitfsRuntimeException {
        this.compressionAlgorithmID = NitfsUtil.getUShort(byteBuffer);
        this.numOfCompressionLookupOffsetRecords = NitfsUtil.getUShort(byteBuffer);
        this.numOfCompressionParameterOffsetRecords = NitfsUtil.getUShort(byteBuffer);
    }

    private void parseImageDisplayParametersSubheader(ByteBuffer byteBuffer) throws NitfsRuntimeException {
        this.numOfImageRows = NitfsUtil.getUInt(byteBuffer);
        this.numOfImageCodesPerRow = NitfsUtil.getUInt(byteBuffer);
        this.imageCodeBitLength = NitfsUtil.getByteAsShort(byteBuffer);
    }

    private void parseImageSubheaders(ByteBuffer byteBuffer) throws NitfsRuntimeException {
        this.userDefinedSubheaderLength = NitfsUtil.getShortNumeric(byteBuffer, 5);
        if (0 == this.userDefinedSubheaderLength) {
            this.userDefSubheader = null;
            return;
        }
        this.userDefSubheader = new UserDefinedImageSubheader(byteBuffer);
    }

    private void parseImageLocation(ByteBuffer byteBuffer) throws NitfsRuntimeException {
        this.imageRowOffset = NitfsUtil.getShortNumeric(byteBuffer, 5);
        this.imageColOffset = NitfsUtil.getShortNumeric(byteBuffer, 5);
        this.imageMagnification = NitfsUtil.getString(byteBuffer, 4);
    }

    private void parseImageTableStructure(ByteBuffer byteBuffer) throws NitfsRuntimeException {
        this.imageSyncCode = NitfsUtil.getShortNumeric(byteBuffer, 1);
        this.imageMode = NitfsUtil.getString(byteBuffer, 1);
        this.numOfBlocksPerRow = NitfsUtil.getShortNumeric(byteBuffer, 4);
        this.numOfBlocksPerCol = NitfsUtil.getShortNumeric(byteBuffer, 4);
        this.numOfPixelsPerBlockH = NitfsUtil.getShortNumeric(byteBuffer, 4);
        this.numOfPixelsPerBlockV = NitfsUtil.getShortNumeric(byteBuffer, 4);
        this.numOfBitsPerPixelPerBand = NitfsUtil.getShortNumeric(byteBuffer, 2);
        this.displayLevel = NitfsUtil.getShortNumeric(byteBuffer, 3);
        this.attachmentLevel = NitfsUtil.getShortNumeric(byteBuffer, 3);
    }

    private void parseImageBands(ByteBuffer byteBuffer) throws NitfsRuntimeException {
        if (0 == this.NBANDS) {
            throw new NitfsRuntimeException("NitfsReader.InvalidNumberOfImageBands");
        }
        this.imageBands = new NitfsImageBand[this.NBANDS];
        for (int i = 0; i < this.NBANDS; ++i) {
            this.imageBands[i] = new NitfsImageBand(byteBuffer);
        }
    }

    private void parseImageCompressionStructure(ByteBuffer byteBuffer) {
        this.imageCompression = NitfsUtil.getString(byteBuffer, 2);
        this.compressionRateCode = NitfsUtil.getString(byteBuffer, 4);
        this.NBANDS = NitfsUtil.getShortNumeric(byteBuffer, 1);
    }

    private void parseCommentRecords(ByteBuffer byteBuffer) {
        int n = NitfsUtil.getShortNumeric(byteBuffer, 1);
        if (0 < n) {
            this.imageCommentRecords = new String[n];
            for (int i = 0; i < n; ++i) {
                this.imageCommentRecords[i] = NitfsUtil.getString(byteBuffer, 80);
            }
        } else {
            this.imageCommentRecords = null;
        }
    }

    private void parseImageGeographicLocation(ByteBuffer byteBuffer) {
        double d = 60.0;
        this.imageCoords = new LatLon[4];
        for (int i = 0; i < 4; ++i) {
            double d2 = NitfsUtil.getShortNumeric(byteBuffer, 2);
            double d3 = NitfsUtil.getShortNumeric(byteBuffer, 2);
            double d4 = NitfsUtil.getShortNumeric(byteBuffer, 2);
            String string = NitfsUtil.getString(byteBuffer, 1);
            double d5 = d2 + (d3 + d4 / d) / d;
            if (StringUtil.Equals(string, "N")) {
                d5 *= -1.0;
            }
            d2 = NitfsUtil.getShortNumeric(byteBuffer, 3);
            d3 = NitfsUtil.getShortNumeric(byteBuffer, 2);
            d4 = NitfsUtil.getShortNumeric(byteBuffer, 2);
            string = NitfsUtil.getString(byteBuffer, 1);
            double d6 = d2 + (d3 + d4 / d) / d;
            if (StringUtil.Equals(string, "W")) {
                d6 *= -1.0;
            }
            this.imageCoords[i] = LatLon.fromDegrees(d5, d6);
        }
    }

    private void parseIdentificationSecurityStructureFields(ByteBuffer byteBuffer) throws NitfsRuntimeException {
        this.partType = NitfsUtil.getString(byteBuffer, 2);
        if (!StringUtil.Equals("IM", this.partType)) {
            throw new NitfsRuntimeException("NitfsReader.UnexpectedSegmentType", this.partType);
        }
        this.imageID = NitfsUtil.getString(byteBuffer, 10);
        boolean bl = false;
        for (String string : SupportedFormats) {
            if (0 != string.compareTo(this.imageID)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new NitfsRuntimeException("NitfsReader.UnsupportedImageFormat", this.imageID);
        }
        this.dateTime = NitfsUtil.getString(byteBuffer, 14);
        this.targetID = NitfsUtil.getString(byteBuffer, 17);
        this.imageTitle = NitfsUtil.getString(byteBuffer, 80);
        this.securityClass = NitfsUtil.getString(byteBuffer, 1);
        this.codewords = NitfsUtil.getString(byteBuffer, 40);
        this.controlAndHandling = NitfsUtil.getString(byteBuffer, 40);
        this.releaseInstructions = NitfsUtil.getString(byteBuffer, 40);
        this.classAuthority = NitfsUtil.getString(byteBuffer, 20);
        this.securityCtrlNum = NitfsUtil.getString(byteBuffer, 20);
        this.ISDWNG = NitfsUtil.getString(byteBuffer, 6);
        this.ISDEVT = StringUtil.Equals(this.ISDWNG, "999998") ? NitfsUtil.getString(byteBuffer, 40) : "";
        this.encryption = NitfsUtil.getShortNumeric(byteBuffer, 1);
        this.imageSource = NitfsUtil.getString(byteBuffer, 42);
        this.numSignificantRows = NitfsUtil.getNumeric(byteBuffer, 8);
        this.numSignificantCols = NitfsUtil.getNumeric(byteBuffer, 8);
        this.pixelValueType = NitfsUtil.getString(byteBuffer, 3);
        this.imageRepresentation = NitfsUtil.getString(byteBuffer, 8);
        this.imageCategory = NitfsUtil.getString(byteBuffer, 8);
        this.bitsPerPixelPerBand = NitfsUtil.getShortNumeric(byteBuffer, 2);
        this.pixelJustification = NitfsUtil.getString(byteBuffer, 1);
        this.imageCoordSystem = NitfsUtil.getString(byteBuffer, 1);
    }
}

