/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.formats.nitfs.NitfsDataExtensionSegment;
import gov.nasa.worldwind.formats.nitfs.NitfsExtendedHeaderSegment;
import gov.nasa.worldwind.formats.nitfs.NitfsFileHeader;
import gov.nasa.worldwind.formats.nitfs.NitfsImageSegment;
import gov.nasa.worldwind.formats.nitfs.NitfsLabelSegment;
import gov.nasa.worldwind.formats.nitfs.NitfsReservedExtensionSegment;
import gov.nasa.worldwind.formats.nitfs.NitfsRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NitfsSegment;
import gov.nasa.worldwind.formats.nitfs.NitfsSegmentType;
import gov.nasa.worldwind.formats.nitfs.NitfsSymbolSegment;
import gov.nasa.worldwind.formats.nitfs.NitfsTextSegment;
import gov.nasa.worldwind.formats.nitfs.NitfsUtil;
import gov.nasa.worldwind.formats.rpf.RpfUserDefinedHeaderSegment;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;

public class NitfsMessage {
    private ByteBuffer buffer;
    private NitfsFileHeader fileHeader;
    private ArrayList<NitfsSegment> segments = new ArrayList();

    public NitfsSegment getSegment(NitfsSegmentType nitfsSegmentType) {
        for (NitfsSegment nitfsSegment : this.segments) {
            if (null == nitfsSegment || !nitfsSegment.segmentType.equals((Object)nitfsSegmentType)) continue;
            return nitfsSegment;
        }
        return null;
    }

    public NitfsFileHeader getNitfsFileHeader() {
        return this.fileHeader;
    }

    private NitfsMessage(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.fileHeader = new NitfsFileHeader(byteBuffer);
        this.readSegments();
    }

    private void readSegments() {
        int n = this.buffer.position();
        int n2 = this.fileHeader.getHeaderLength();
        n2 = this.parseSegment(NitfsSegmentType.ImageSegment, n2);
        n2 = this.parseSegment(NitfsSegmentType.SymbolSegment, n2);
        n2 = this.parseSegment(NitfsSegmentType.LabelSegment, n2);
        n2 = this.parseSegment(NitfsSegmentType.TextSegment, n2);
        n2 = this.parseSegment(NitfsSegmentType.DataExtensionSegment, n2);
        n2 = this.parseSegment(NitfsSegmentType.ReservedExtensionSegment, n2);
        RpfUserDefinedHeaderSegment rpfUserDefinedHeaderSegment = new RpfUserDefinedHeaderSegment(this.buffer);
        this.segments.add(rpfUserDefinedHeaderSegment);
        n2 += rpfUserDefinedHeaderSegment.headerLength + rpfUserDefinedHeaderSegment.dataLength;
        n2 = this.parseSegment(NitfsSegmentType.ExtendedHeaderSegment, n2);
        for (NitfsSegment nitfsSegment : this.segments) {
        }
    }

    private int parseSegment(NitfsSegmentType nitfsSegmentType, int n) {
        int n2 = nitfsSegmentType.getHeaderLengthSize();
        int n3 = nitfsSegmentType.getDataLengthSize();
        int n4 = Integer.parseInt(NitfsUtil.getString(this.buffer, 3));
        for (int i = 0; i < n4; ++i) {
            NitfsSegment nitfsSegment;
            int n5 = Integer.parseInt(NitfsUtil.getString(this.buffer, n2));
            int n6 = Integer.parseInt(NitfsUtil.getString(this.buffer, n3));
            int n7 = this.buffer.position();
            switch (nitfsSegmentType) {
                case ImageSegment: {
                    nitfsSegment = new NitfsImageSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case SymbolSegment: {
                    nitfsSegment = new NitfsSymbolSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case LabelSegment: {
                    nitfsSegment = new NitfsLabelSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case TextSegment: {
                    nitfsSegment = new NitfsTextSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case DataExtensionSegment: {
                    nitfsSegment = new NitfsDataExtensionSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case ReservedExtensionSegment: {
                    nitfsSegment = new NitfsReservedExtensionSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case UserDefinedHeaderSegment: {
                    nitfsSegment = new RpfUserDefinedHeaderSegment(this.buffer);
                    break;
                }
                case ExtendedHeaderSegment: {
                    nitfsSegment = new NitfsExtendedHeaderSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                default: {
                    throw new NitfsRuntimeException("NitfsReader.UnknownOrUnsupportedSegment", nitfsSegmentType.toString());
                }
            }
            this.segments.add(nitfsSegment);
            n += n5 + n6;
            this.buffer.position(n7);
        }
        return n;
    }

    public static NitfsMessage load(File file) throws IOException {
        NitfsMessage.validateImageFile(file);
        ByteBuffer byteBuffer = NitfsUtil.readEntireFile(file).asReadOnlyBuffer();
        String string = NitfsUtil.getString(byteBuffer, 0, 4);
        if (0 != "NITF".compareTo(string) && 0 != "NSIF".compareTo(string)) {
            byteBuffer = null;
            throw new NitfsRuntimeException("NitfsReader.UnknownOrUnsupportedNitfsFormat", file.getCanonicalPath());
        }
        return new NitfsMessage(byteBuffer);
    }

    private static void validateImageFile(File file) throws IOException, IllegalArgumentException, NitfsRuntimeException {
        if (null == file) {
            String string = WorldWind.retrieveErrMsg("nullValue.FileIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists() || !file.canRead()) {
            throw new NitfsRuntimeException("NitfsReader.NoFileOrNoPermission", file.getCanonicalPath());
        }
    }

    public static void main(String[] stringArray) {
        String string = "/depot/WorldWindJ/utils/gdal/020g222a.i42";
        if (Configuration.isWindowsOS()) {
            string = "C:\\depot\\WorldWindJ\\utils\\gdal\\020g222a.i42";
        }
        try {
            long l = System.currentTimeMillis();
            NitfsMessage nitfsMessage = NitfsMessage.load(new File(string));
            System.out.println(MessageFormat.format("Image loaded in {0} mSec", System.currentTimeMillis() - l));
            System.out.println(nitfsMessage.fileHeader.getHeaderLength());
            System.out.println(nitfsMessage.fileHeader.getVersion());
            System.out.println(nitfsMessage.fileHeader.getComplexityLevel());
            System.out.println(nitfsMessage.fileHeader.getSpecialType());
            System.out.println(nitfsMessage.fileHeader.getOriginationStationId());
            System.out.println(nitfsMessage.fileHeader.getDateTime());
            System.out.println(nitfsMessage.fileHeader.getTitle());
            System.out.println(nitfsMessage.fileHeader.getFSCLAS());
            System.out.println("HeaderLength=" + nitfsMessage.fileHeader.getHeaderLength());
            System.out.println("Total FileLength=" + nitfsMessage.fileHeader.getFileLength());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

