/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.WorldWind;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RpfDataSeries {
    DataSeriesGN("GN", "GNC", "1:5,000,000", "Global Navigation Chart", "CADRG", 5000000.0),
    DataSeriesJN("JN", "JNC", "1:2,000,000", "Jet Navigation Chart", "CADRG", 2000000.0),
    DataSeriesOH("OH", "VHRC", "1:1,000,000", "VFR Helicopter Route Chart", "CADRG", 1000000.0),
    DataSeriesON("ON", "ONC", "1:1,000,000", "Operational Navigation Chart", "CADRG", 1000000.0),
    DataSeriesOW("OW", "WAC", "1:1,000,000", "High Flying Chart - Host Nation", "CADRG", 1000000.0),
    DataSeriesTP("TP", "TPC", "1:500,000", "Tactical Pilotage Chart", "CADRG", 500000.0),
    DataSeriesLF("LF", "LFC-FR (Day)", "1:500,000", "Low Flying Chart (Day)- Host Nation", "CADRG", 500000.0),
    DataSeriesL1("L1", "LFC-1", "1:500,000", "Low Flying Chart (TBD #1)", "CADRG", 500000.0),
    DataSeriesL2("L2", "LFC-2", "1:500,000", "Low Flying Chart (TBD #2)", "CADRG", 500000.0),
    DataSeriesL3("L3", "LFC-3", "1:500,000", "Low Flying Chart (TBD #3)", "CADRG", 500000.0),
    DataSeriesL4("L4", "LFC-4", "1:500,000", "Low Flying Chart (TBD #4)", "CADRG", 500000.0),
    DataSeriesL5("L5", "LFC-5", "1:500,000", "Low Flying Chart (TBD #5)", "CADRG", 500000.0),
    DataSeriesLN("LN", "LFC (Night)", "1:500,000", "Low Flying Chart (Night) - Host Nation", "CADRG", 500000.0),
    DataSeriesJG("JG", "JOG", "1:250,000", "Joint Operations Graphic", "CADRG", 250000.0),
    DataSeriesJA("JA", "JOG-A", "1:250,000", "Joint Operations Graphic - Air", "CADRG", 250000.0),
    DataSeriesJR("JR", "JOG-R", "1:250,000", "Joint Operations Graphic - Radar", "CADRG", 250000.0),
    DataSeriesJO("JO", "OPG", "1:250,000", "Operational Planning Graphic", "CADRG", 250000.0),
    DataSeriesVT("VT", "VTAC", "1:250,000", "VFR Terminal Area Chart", "CADRG", 250000.0),
    DataSeriesF1("F1", "TFC-1", "1:250,000", "Transit Flying Chart (TBD #1)", "CADRG", 250000.0),
    DataSeriesF2("F2", "TFC-2", "1:250,000", "Transit Flying Chart (TBD #2)", "CADRG", 250000.0),
    DataSeriesF3("F3", "TFC-3", "1:250,000", "Transit Flying Chart (TBD #3)", "CADRG", 250000.0),
    DataSeriesF4("F4", "TFC-4", "1:250,000", "Transit Flying Chart (TBD #4)", "CADRG", 250000.0),
    DataSeriesF5("F5", "TFC-5", "1:250,000", "Transit Flying Chart (TBD #5)", "CADRG", 250000.0),
    DataSeriesAT("AT", "ATC", "1:200,000", "Series 200 Air Target Chart", "CADRG", 200000.0),
    DataSeriesVH("VH", "HRC", "1:125,000", "Helicopter Route Chart", "CADRG", 125000.0),
    DataSeriesTN("TN", "TFC (Night)", "1:250,000", "Transit Flying Chart(Night)- Host nation", "CADRG", 250000.0),
    DataSeriesTR("TR", "TLM200", "1:200,000", "Topographic Line Map 1:200,000 scale", "CADRG", 200000.0),
    DataSeriesTC("TC", "TLM 100", "1:100,000", "Topographic Line Map 1:100,0000 scale", "CADRG", 100000.0),
    DataSeriesRV("RV", "Riverine", "1:50,000", "Riverine Map 1:50,000 scale", "CADRG", 50000.0),
    DataSeriesTL("TL", "TLM 50", "1:50,000", "Topographic Line Map", "CADRG", 50000.0),
    DataSeriesUL("UL", "TLM50-Other", "1:50,000", "Topographic Line Map (other 1:50,000 scale)", "CADRG", 50000.0),
    DataSeriesTT("TT", "TLM25", "1:25,000", "Topographic Line Map 1:25,000 scale", "CADRG", 25000.0),
    DataSeriesTQ("TQ", "TLM24", "1:24,000", "Topographic Line Map 1:24,000 scale", "CADRG", 24000.0),
    DataSeriesC1("C1", "CG", "1:10,000", "City Graphics", "CADRG", 10000.0),
    DataSeriesC2("C2", "CG", "1:10,560", "City Graphics", "CADRG", 10560.0),
    DataSeriesC3("C3", "CG", "1:11,000", "City Graphics", "CADRG", 11000.0),
    DataSeriesC4("C4", "CG", "1:11,800", "City Graphics", "CADRG", 11800.0),
    DataSeriesC5("C5", "CG", "1:12,000", "City Graphics", "CADRG", 12000.0),
    DataSeriesC6("C6", "CG", "1:12,500", "City Graphics", "CADRG", 12500.0),
    DataSeriesC7("C7", "CG", "1:12,800", "City Graphics", "CADRG", 12800.0),
    DataSeriesC8("C8", "CG", "1:14,000", "City Graphics", "CADRG", 14000.0),
    DataSeriesC9("C9", "CG", "1:14,700", "City Graphics", "CADRG", 14700.0),
    DataSeriesCA("CA", "CG", "1:15,000", "City Graphics", "CADRG", 15000.0),
    DataSeriesCB("CB", "CG", "1:15,500", "City Graphics", "CADRG", 15500.0),
    DataSeriesCC("CC", "CG", "1:16,000", "City Graphics", "CADRG", 16000.0),
    DataSeriesCD("CD", "CG", "1:16,666", "City Graphics", "CADRG", 16666.0),
    DataSeriesCE("CE", "CG", "1:17,000", "City Graphics", "CADRG", 17000.0),
    DataSeriesCF("CF", "CG", "1:17,500", "City Graphics", "CADRG", 17500.0),
    DataSeriesCH("CH", "CG", "1:18,000", "City Graphics", "CADRG", 18000.0),
    DataSeriesCJ("CJ", "CG", "1:20,000", "City Graphics", "CADRG", 20000.0),
    DataSeriesCK("CK", "CG", "1:21,000", "City Graphics", "CADRG", 21000.0),
    DataSeriesCL("CL", "CG", "1:21,120", "City Graphics", "CADRG", 21120.0),
    DataSeriesCN("CN", "CG", "1:22,000", "City Graphics", "CADRG", 22000.0),
    DataSeriesCP("CP", "CG", "1:23,000", "City Graphics", "CADRG", 23000.0),
    DataSeriesCQ("CQ", "CG", "1:25,000", "City Graphics", "CADRG", 25000.0),
    DataSeriesCR("CR", "CG", "1:26,000", "City Graphics", "CADRG", 26000.0),
    DataSeriesCS("CS", "CG", "1:35,000", "City Graphics", "CADRG", 35000.0),
    DataSeriesCT("CT", "CG", "1:36,000", "City Graphics", "CADRG", 36000.0),
    DataSeriesA1("A1", "CM", "1:10,000", "Combat Charts, 1:10,000 scale", "CADRG", 10000.0),
    DataSeriesA2("A2", "CM", "1:25,000", "Combat Charts, 1:25,000 scale", "CADRG", 25000.0),
    DataSeriesA3("A3", "CM", "1:50,000", "Combat Charts, 1:50,000 scale", "CADRG", 50000.0),
    DataSeriesA4("A4", "CM", "1:100,000", "Combat Charts, 1:100,000 scale", "CADRG", 100000.0),
    DataSeriesMI("MI", "MIM", "1:50,000", "Military Installation Maps", "CADRG", 50000.0),
    DataSeriesVN("VN", "VNC", "1:500,000", "Visual Navigation Charts", "CADRG", 500000.0),
    DataSeriesMM("MM", "---", "Various", "(Miscellaneous Maps & Charts)", "CADRG", 12500.0),
    DataSeriesI1("I1", "---", "10m", "Imagery, 10 meter resolution", "CIB", 10.0),
    DataSeriesI2("I2", "---", "5m", "Imagery, 5 meter resolution", "CIB", 5.0),
    DataSeriesI3("I3", "---", "2m", "Imagery, 2 meter resolution", "CIB", 2.0),
    DataSeriesI4("I4", "---", "1m", "Imagery, 1 meter resolution", "CIB", 1.0),
    DataSeriesI5("I5", "---", ".5m", "Imagery, .5 (half) meter resolution", "CIB", 0.5),
    DataSeriesTF("TF", "---", "1:250000", "Transit Fly (UK)", "CADRG", 250000.0);

    public final String seriesCode;
    public final String seriesAbbreviation;
    public final String scaleOrResolution;
    public final String dataSeries;
    public final String rpfDataType;
    public final double scaleOrGSD;
    private static Map<String, RpfDataSeries> enumConstantDirectory;
    public static String[] validDataTypes;

    private RpfDataSeries(String string2, String string3, String string4, String string5, String string6, double d) {
        RpfDataSeries.validateScaleOrGSD(d);
        this.rpfDataType = RpfDataSeries.validateRpfDataType(string6);
        this.seriesCode = string2;
        this.seriesAbbreviation = string3;
        this.scaleOrResolution = string4;
        this.dataSeries = string5;
        this.scaleOrGSD = d;
    }

    private static Map<String, RpfDataSeries> enumConstantDirectory() {
        if (enumConstantDirectory == null) {
            RpfDataSeries[] rpfDataSeriesArray = (RpfDataSeries[])RpfDataSeries.class.getEnumConstants();
            enumConstantDirectory = new HashMap<String, RpfDataSeries>(2 * rpfDataSeriesArray.length);
            for (RpfDataSeries rpfDataSeries : rpfDataSeriesArray) {
                enumConstantDirectory.put(rpfDataSeries.seriesCode, rpfDataSeries);
            }
        }
        return enumConstantDirectory;
    }

    public static RpfDataSeries dataSeriesFor(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.StringIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        RpfDataSeries rpfDataSeries = RpfDataSeries.enumConstantDirectory().get(string);
        if (rpfDataSeries == null) {
            String string3 = WorldWind.retrieveErrMsg("generic.EnumNotFound") + string;
            WorldWind.logger().log(Level.FINE, string3);
            throw new EnumConstantNotPresentException(RpfDataSeries.class, string3);
        }
        return rpfDataSeries;
    }

    public static String[] validDataTypes() {
        if (validDataTypes == null) {
            validDataTypes = new String[]{"CADRG", "CIB"};
        }
        return validDataTypes;
    }

    private static String validateRpfDataType(String string) {
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("RpfDataSeries.InavlidRpfDataType") + string;
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        for (String string2 : RpfDataSeries.validDataTypes()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return string2;
        }
        String string3 = WorldWind.retrieveErrMsg("RpfDataSeries.InavlidRpfDataType") + string;
        WorldWind.logger().log(Level.FINE, string3);
        throw new IllegalArgumentException(string3);
    }

    private static void validateScaleOrGSD(double d) {
        if (d <= 0.0) {
            String string = WorldWind.retrieveErrMsg("RpfDataSeries.InvalidScaleOrGSD") + d;
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
    }

    static {
        enumConstantDirectory = null;
        validDataTypes = null;
    }
}

