/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RpfFrameFileIndexSection;
import gov.nasa.worldwind.formats.rpf.RpfHeaderSection;
import gov.nasa.worldwind.formats.rpf.RpfLocationSection;
import java.nio.ByteBuffer;

public class RpfFileComponents {
    private ByteBuffer buffer;
    private RpfHeaderSection headerSection;
    private RpfLocationSection locationSection;

    public RpfFileComponents(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.headerSection = new RpfHeaderSection(byteBuffer);
        byteBuffer.position(this.headerSection.locationSectionLocation);
        this.locationSection = new RpfLocationSection(byteBuffer);
    }

    public RpfHeaderSection getRpfHeaderSection() {
        return this.headerSection;
    }

    public RpfFrameFileIndexSection getRpfFrameFileIndexSection() {
        if (0 < this.locationSection.getFrameFileIndexSectionSubheaderLength()) {
            this.buffer.position(this.locationSection.getFrameFileIndexSectionSubheaderLocation());
            return new RpfFrameFileIndexSection(this.buffer);
        }
        return null;
    }
}

