/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.formats.rpf.RpfDataSeries;
import gov.nasa.worldwind.formats.rpf.RpfFrameFilenameFormatException;
import gov.nasa.worldwind.formats.rpf.RpfFrameProperties;
import gov.nasa.worldwind.formats.rpf.RpfProducer;
import gov.nasa.worldwind.formats.rpf.RpfZone;
import java.util.logging.Level;

public class RpfFrameFilenameUtil {
    public static final char[] BASE34_ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static char[] charArray;

    public static char[] base34ValueOf(int n, char[] cArray, int n2, int n3) {
        if (cArray == null || cArray.length < n3) {
            cArray = new char[n3];
        }
        for (int i = n3 + n2 - 1; i >= n2; --i) {
            cArray[i] = BASE34_ALPHABET[n % 34];
            n /= 34;
        }
        return cArray;
    }

    private static void ensureCharArray(int n) {
        if (charArray == null || charArray.length < n) {
            charArray = new char[n];
        }
    }

    public static String filenameFor(RpfFrameProperties rpfFrameProperties, String string) {
        RpfFrameFilenameUtil.validateFrameProperties(rpfFrameProperties);
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.StringIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        RpfFrameFilenameUtil.ensureCharArray(12);
        if (string.compareToIgnoreCase("CADRG") == 0) {
            RpfFrameFilenameUtil.filenameForCadrgOrCib(rpfFrameProperties, 5, 2, charArray);
        } else if (string.compareToIgnoreCase("CIB") == 0) {
            RpfFrameFilenameUtil.filenameForCadrgOrCib(rpfFrameProperties, 6, 1, charArray);
        } else {
            String string3 = WorldWind.retrieveErrMsg("RpfFrameFilenameUtil.UnknownRpfDataType") + string;
            WorldWind.logger().log(Level.FINE, string3);
            throw new IllegalArgumentException(string3);
        }
        return new String(charArray, 0, 12);
    }

    public static String filenameFor(RpfFrameProperties rpfFrameProperties) {
        RpfFrameFilenameUtil.validateFrameProperties(rpfFrameProperties);
        return RpfFrameFilenameUtil.filenameFor(rpfFrameProperties, rpfFrameProperties.dataSeries.rpfDataType);
    }

    private static void filenameForCadrgOrCib(RpfFrameProperties rpfFrameProperties, int n, int n2, char[] cArray) {
        int n3 = 0;
        RpfFrameFilenameUtil.base34ValueOf(rpfFrameProperties.frameNumber, cArray, n3, n);
        RpfFrameFilenameUtil.base34ValueOf(rpfFrameProperties.version, cArray, n3 += n, n2);
        n3 += n2;
        cArray[n3++] = rpfFrameProperties.producer.id.charValue();
        cArray[n3++] = 46;
        rpfFrameProperties.dataSeries.seriesCode.getChars(0, 2, cArray, n3);
        cArray[n3 += 2] = rpfFrameProperties.zone.zoneCode.charValue();
    }

    public static int parseBase34(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            int n4;
            char c = Character.toUpperCase(cArray[i]);
            if (c >= '0' && c <= '9') {
                n4 = c - 48;
            } else if (c >= 'A' && c <= 'H') {
                n4 = 10 + c - 65;
            } else if (c >= 'J' && c <= 'N') {
                n4 = 18 + c - 74;
            } else if (c >= 'P' && c <= 'Z') {
                n4 = 23 + c - 80;
            } else {
                String string = WorldWind.retrieveErrMsg("RpfFrameFilenameUtil.Base34Error");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            n3 = n3 * 34 + n4;
        }
        return n3;
    }

    public static RpfFrameProperties parseFilename(String string, String string2) {
        RpfFrameProperties rpfFrameProperties;
        if (string == null || string2 == null) {
            String string3 = WorldWind.retrieveErrMsg("nullValue.StringIsNull");
            WorldWind.logger().log(Level.FINE, string3);
            throw new IllegalArgumentException(string3);
        }
        if (string.length() != 12) {
            String string4 = WorldWind.retrieveErrMsg("RpfFrameFilenameUtil.BadFilenameLength") + string;
            WorldWind.logger().log(Level.FINE, string4);
            throw new RpfFrameFilenameFormatException(string4);
        }
        RpfFrameFilenameUtil.ensureCharArray(12);
        string.getChars(0, 12, charArray, 0);
        if (string2.compareToIgnoreCase("CADRG") == 0) {
            rpfFrameProperties = RpfFrameFilenameUtil.parseFilenameCadrgOrCib(charArray, 5, 2);
        } else if (string2.compareToIgnoreCase("CIB") == 0) {
            rpfFrameProperties = RpfFrameFilenameUtil.parseFilenameCadrgOrCib(charArray, 6, 1);
        } else {
            String string5 = WorldWind.retrieveErrMsg("RpfFrameFilenameUtil.UnknownRpfDataType") + string2;
            WorldWind.logger().log(Level.FINE, string5);
            throw new IllegalArgumentException(string5);
        }
        return rpfFrameProperties;
    }

    public static RpfFrameProperties parseFilename(String string) {
        RpfDataSeries rpfDataSeries;
        if (string == null) {
            String string2 = WorldWind.retrieveErrMsg("nullValue.StringIsNull");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.length() != 12) {
            String string3 = WorldWind.retrieveErrMsg("RpfFrameFilenameUtil.BadFilenameLength") + string;
            WorldWind.logger().log(Level.FINE, string3);
            throw new RpfFrameFilenameFormatException(string3);
        }
        try {
            rpfDataSeries = RpfDataSeries.dataSeriesFor(string.substring(9, 11));
        }
        catch (EnumConstantNotPresentException enumConstantNotPresentException) {
            String string4 = WorldWind.retrieveErrMsg("RpfFrameFilenameUtil.EnumNotFound");
            WorldWind.logger().log(Level.FINE, string4);
            throw new RpfFrameFilenameFormatException(string4, enumConstantNotPresentException);
        }
        return RpfFrameFilenameUtil.parseFilename(string, rpfDataSeries.rpfDataType);
    }

    private static RpfFrameProperties parseFilenameCadrgOrCib(char[] cArray, int n, int n2) {
        RpfZone rpfZone;
        RpfDataSeries rpfDataSeries;
        RpfProducer rpfProducer;
        int n3;
        int n4;
        int n5 = 0;
        try {
            n4 = RpfFrameFilenameUtil.parseBase34(cArray, n5, n);
            n3 = RpfFrameFilenameUtil.parseBase34(cArray, n5 += n, n2);
            n5 += n2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = WorldWind.retrieveErrMsg("RpfFrameFilenameUtil.IntegerNotParsed");
            WorldWind.logger().log(Level.FINE, string);
            throw new RpfFrameFilenameFormatException(string, illegalArgumentException);
        }
        try {
            rpfProducer = RpfProducer.producerFor(Character.valueOf(cArray[n5]));
            rpfDataSeries = RpfDataSeries.dataSeriesFor(new String(cArray, n5 += 2, 2));
            rpfZone = RpfZone.zoneFor(Character.valueOf(cArray[n5 += 2]));
        }
        catch (EnumConstantNotPresentException enumConstantNotPresentException) {
            String string = WorldWind.retrieveErrMsg("RpfFrameFilenameUtil.EnumNotFound");
            WorldWind.logger().log(Level.FINE, string);
            throw new RpfFrameFilenameFormatException(string, enumConstantNotPresentException);
        }
        return new RpfFrameProperties(rpfZone, n4, rpfDataSeries, rpfProducer, n3);
    }

    private static void validateFrameProperties(RpfFrameProperties rpfFrameProperties) {
        if (rpfFrameProperties == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RpfFramePropertiesIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (rpfFrameProperties.zone == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RpfZoneIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (rpfFrameProperties.frameNumber < 0) {
            String string = WorldWind.retrieveErrMsg("RpfFrameProperties.BadFrameNumber") + rpfFrameProperties.frameNumber;
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (rpfFrameProperties.dataSeries == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RpfDataSeriesIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (rpfFrameProperties.producer == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.RpfProducerIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (rpfFrameProperties.version < 0) {
            String string = WorldWind.retrieveErrMsg("RpfFrameProperties.BadVersion") + rpfFrameProperties.version;
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
    }
}

