/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NitfsUtil;
import java.nio.ByteBuffer;

class RpfHeaderSection {
    public static final String DATA_TAG = "RPFHDR";
    public boolean endianIndicator;
    public short headerLength;
    public String filename;
    public short updateIndicator;
    public String govSpecNumber;
    public String govSpecDate;
    public String securityClass;
    public String securityCountryCode;
    public String securityReleaseMark;
    public int locationSectionLocation;

    public RpfHeaderSection(ByteBuffer byteBuffer) {
        this.endianIndicator = 0 != byteBuffer.get();
        this.headerLength = byteBuffer.getShort();
        this.filename = NitfsUtil.getString(byteBuffer, 12);
        this.updateIndicator = NitfsUtil.getByteAsShort(byteBuffer);
        this.govSpecNumber = NitfsUtil.getString(byteBuffer, 15);
        this.govSpecDate = NitfsUtil.getString(byteBuffer, 8);
        this.securityClass = NitfsUtil.getString(byteBuffer, 1);
        this.securityCountryCode = NitfsUtil.getString(byteBuffer, 2);
        this.securityReleaseMark = NitfsUtil.getString(byteBuffer, 2);
        this.locationSectionLocation = byteBuffer.getInt();
    }
}

