/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWIO;
import gov.nasa.worldwind.formats.nitfs.NitfsImageSegment;
import gov.nasa.worldwind.formats.nitfs.NitfsRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NitfsSegmentType;
import gov.nasa.worldwind.formats.nitfs.UserDefinedImageSubheader;
import gov.nasa.worldwind.formats.rpf.RpfFile;
import gov.nasa.worldwind.formats.rpf.RpfFrameFileComponents;
import gov.nasa.worldwind.formats.rpf.RpfImageType;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.MessageFormat;

public class RpfImageFile
extends RpfFile {
    private NitfsImageSegment imageSegment = (NitfsImageSegment)this.getNitfsSegment(NitfsSegmentType.ImageSegment);
    private UserDefinedImageSubheader imageSubheader = null;
    private RpfFrameFileComponents rpfFrameFileComponents = null;

    public RpfFrameFileComponents getRpfFrameFileComponents() {
        return this.rpfFrameFileComponents;
    }

    public UserDefinedImageSubheader getImageSubheader() {
        return this.imageSubheader;
    }

    public NitfsImageSegment getImageSegment() {
        return this.imageSegment;
    }

    private RpfImageFile(File file) throws IOException, NitfsRuntimeException {
        super(file);
        this.validateRpfImage();
        this.imageSubheader = this.imageSegment.getUserDefinedImageSubheader();
        this.rpfFrameFileComponents = this.imageSubheader.getRpfFrameFileComponents();
    }

    private void validateRpfImage() throws NitfsRuntimeException {
        if (null == this.imageSegment) {
            throw new NitfsRuntimeException("NitfsReader.ImageSegmentWasNotFound");
        }
        if (null == this.imageSegment.getUserDefinedImageSubheader()) {
            throw new NitfsRuntimeException("NitfsReader.UserDefinedImageSubheaderWasNotFound");
        }
        if (null == this.imageSegment.getUserDefinedImageSubheader().getRpfFrameFileComponents()) {
            throw new NitfsRuntimeException("NitfsReader.RpfFrameFileComponentsWereNotFoundInUserDefinedImageSubheader");
        }
    }

    public int[] getImagePixelsAsArray(int[] nArray, RpfImageType rpfImageType) {
        IntBuffer intBuffer = IntBuffer.wrap(nArray);
        this.getImagePixelsAsBuffer(intBuffer, rpfImageType);
        return nArray;
    }

    public ByteBuffer getImageAsDdsTexture() {
        if (null != this.imageSegment) {
            return this.imageSegment.getImageAsDdsTexture();
        }
        return null;
    }

    public IntBuffer getImagePixelsAsBuffer(IntBuffer intBuffer, RpfImageType rpfImageType) {
        if (null != this.imageSegment) {
            this.imageSegment.getImagePixelsAsArray(intBuffer, rpfImageType);
        }
        return intBuffer;
    }

    public BufferedImage getBufferedImage() {
        if (null == this.imageSegment) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(this.getImageSegment().numSignificantCols, this.getImageSegment().numSignificantRows, 2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        IntBuffer intBuffer = IntBuffer.wrap(dataBufferInt.getData());
        this.getImageSegment().getImagePixelsAsArray(intBuffer, RpfImageType.IMAGE_TYPE_ALPHA_RGB);
        return bufferedImage;
    }

    public boolean hasTransparentAreas() {
        if (null != this.imageSegment) {
            return this.imageSegment.hasTransparentPixels() || this.imageSegment.hasMaskedSubframes();
        }
        return false;
    }

    public static RpfImageFile load(File file) throws IOException, NitfsRuntimeException {
        return new RpfImageFile(file);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = Configuration.isWindowsOS() ? "C:\\depot\\WorldWindJ\\utils\\gdal\\020g222a.i42" : "/depot/WorldWindJ/utils/gdal/020g222a.i42";
        String string2 = Configuration.isWindowsOS() ? "C:\\depot\\nitfs\\CADRG\\CTLM50\\CT50Z02\\02F7W053.TL2" : "/depot/nitfs/CADRG/CTLM50/CT50Z02/02F7W053.TL2";
        String string3 = Configuration.isWindowsOS() ? "C:\\depot\\nitfs\\CADRG\\CTLM50\\CT50Z02\\0D6MM013.TL1" : "/depot/nitfs/CADRG/CTLM50/CT50Z02/0D6MM013.TL1";
        String string4 = string;
        try {
            long l = System.currentTimeMillis();
            RpfImageFile rpfImageFile = RpfImageFile.load(new File(string4));
            ByteBuffer byteBuffer = rpfImageFile.getImageAsDdsTexture();
            System.out.println(MessageFormat.format("RPF file loaded in {0} mSec", System.currentTimeMillis() - l));
            WWIO.saveBuffer(byteBuffer, new File(Configuration.isWindowsOS() ? "c:\\depot\\nitfs\\DDS\\test.dds" : "/depot/nitfs/DDS/test.dds"));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

