/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.formats.rpf.RpfZone;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RpfProducer {
    Producer1(Character.valueOf('1'), "AFACC", "Air Force Air Combat Command"),
    Producer2(Character.valueOf('2'), "AFESC", "Air Force Electronic Systems Center"),
    Producer3(Character.valueOf('3'), "NIMA", "National Imagery and Mapping Agency, Primary"),
    Producer4(Character.valueOf('4'), "NIMA1", "NIMA, Alternate Site 1"),
    Producer5(Character.valueOf('5'), "NIMA2", "NIMA, Alternate Site 2"),
    Producer6(Character.valueOf('6'), "NIMA3", "NIMA, Alternate Site 3"),
    Producer7(Character.valueOf('7'), "SOCAF", "Air Force Special Operations Command"),
    Producer8(Character.valueOf('8'), "SOCOM", "United States Special Operations Command"),
    Producer9(Character.valueOf('9'), "PACAF", "Pacific Air Forces"),
    ProducerA(Character.valueOf('A'), "USAFE", "United States Air Force, Europe"),
    ProducerB(Character.valueOf('B'), "Non-DoD (NonDD)", "US producer outside the Department of Defense"),
    ProducerC(Character.valueOf('C'), "Non-US (NonUS)", "Non-US producer"),
    ProducerD(Character.valueOf('D'), "NIMA", "DCHUM (DCHUM) NIMA produced Digital CHUM file"),
    ProducerE(Character.valueOf('E'), "Non-NIMA DCHUM (DCHMD)", "DoD producer of Digital CHUM file otherthan NIMA "),
    ProducerF(Character.valueOf('F'), "Non-US DCHUM (DCHMF)", "Non-US (foreign)producer of Digital CHUMfiles"),
    ProducerG(Character.valueOf('G'), "Non-DoD DCHUM (DCHMG)", "US producer of Digital CHUM files outsideDoD"),
    ProducerH(Character.valueOf('H'), "IMG2RPF", "Non-specified, Imagery formatted to RPF");

    public final Character id;
    public final String producerCode;
    public final String producer;
    private static RpfProducer[] enumConstantAlphabet;

    private RpfProducer(Character c, String string2, String string3) {
        this.id = c;
        this.producer = string3;
        this.producerCode = string2;
    }

    private static RpfProducer[] enumConstantAlphabet() {
        if (enumConstantAlphabet == null) {
            RpfProducer[] rpfProducerArray = (RpfProducer[])RpfProducer.class.getEnumConstants();
            enumConstantAlphabet = new RpfProducer[36];
            RpfProducer[] rpfProducerArray2 = rpfProducerArray;
            int n = rpfProducerArray2.length;
            for (int i = 0; i < n; ++i) {
                RpfProducer rpfProducer;
                RpfProducer.enumConstantAlphabet[RpfProducer.indexFor((Character)rpfProducer.id)] = rpfProducer = rpfProducerArray2[i];
            }
        }
        return enumConstantAlphabet;
    }

    private static int indexFor(Character c) {
        if (c.charValue() >= '0' && c.charValue() <= '9') {
            return c.charValue() - 48;
        }
        if (c.charValue() >= 'A' && c.charValue() <= 'Z') {
            return 10 + c.charValue() - 65;
        }
        return -1;
    }

    public static RpfProducer producerFor(Character c) {
        RpfProducer rpfProducer;
        if (c == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.CharacterIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        RpfProducer[] rpfProducerArray = RpfProducer.enumConstantAlphabet();
        int n = RpfProducer.indexFor(Character.valueOf(Character.toUpperCase(c.charValue())));
        if (n < 0 || n >= rpfProducerArray.length || (rpfProducer = rpfProducerArray[n]) == null) {
            String string = WorldWind.retrieveErrMsg("generic.EnumNotFound") + c;
            WorldWind.logger().log(Level.FINE, string);
            throw new EnumConstantNotPresentException(RpfZone.class, string);
        }
        return rpfProducer;
    }

    static {
        enumConstantAlphabet = null;
    }
}

