/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.formats.rpf.RpfFrameFileIndexSection;
import gov.nasa.worldwind.formats.rpf.RpfFrameFilenameUtil;
import gov.nasa.worldwind.formats.rpf.RpfFrameProperties;
import gov.nasa.worldwind.formats.rpf.RpfFramePropertyType;
import gov.nasa.worldwind.formats.rpf.RpfTocFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class RpfTocCrawler {
    public static final String RPF_DIRECTORY = "RPF";
    public static final String RPF_OVERVIEW_EXTENSION = ".OVR";
    public static final String RPF_TOC_EXTENSION = ".TOC";
    private final Thread deadThread = new Thread();
    private final Lock threadLock = new ReentrantLock();
    private volatile Thread thread = null;

    public static String findFirstRpfFrameFilename(RpfTocFile rpfTocFile) {
        if (rpfTocFile != null && rpfTocFile.getFrameFileIndexSection() != null && rpfTocFile.getFrameFileIndexSection().getFrameFileIndexTable() != null && rpfTocFile.getFrameFileIndexSection().getFrameFileIndexTable().size() > 0) {
            for (RpfFrameFileIndexSection.RpfFrameFileIndexRecord rpfFrameFileIndexRecord : rpfTocFile.getFrameFileIndexSection().getFrameFileIndexTable()) {
                if (rpfFrameFileIndexRecord == null || rpfFrameFileIndexRecord.getFrameFileName() == null || rpfFrameFileIndexRecord.getFrameFileName().toUpperCase().endsWith(RPF_OVERVIEW_EXTENSION)) continue;
                return rpfFrameFileIndexRecord.getFrameFileName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(File file, RpfTocCrawlerListener rpfTocCrawlerListener, boolean bl) {
        this.threadLock.lock();
        try {
            if (bl && this.thread == this.deadThread) {
                return;
            }
        }
        finally {
            this.threadLock.unlock();
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        if (RPF_DIRECTORY.compareToIgnoreCase(file.getName()) == 0) {
            this.processRpfDirectory(fileArray, rpfTocCrawlerListener, bl);
        } else {
            this.processUnknownDirectory(fileArray, rpfTocCrawlerListener, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRpfDirectory(File[] fileArray, RpfTocCrawlerListener rpfTocCrawlerListener, boolean bl) {
        for (File file : fileArray) {
            this.threadLock.lock();
            try {
                if (bl && this.thread == this.deadThread) {
                    return;
                }
            }
            finally {
                this.threadLock.unlock();
            }
            if (!file.getName().toUpperCase().endsWith(RPF_TOC_EXTENSION)) continue;
            rpfTocCrawlerListener.fileFound(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnknownDirectory(File[] fileArray, RpfTocCrawlerListener rpfTocCrawlerListener, boolean bl) {
        for (File file : fileArray) {
            this.threadLock.lock();
            try {
                if (bl && this.thread == this.deadThread) {
                    return;
                }
            }
            finally {
                this.threadLock.unlock();
            }
            if (!file.isDirectory()) continue;
            this.process(file, rpfTocCrawlerListener, bl);
        }
    }

    public File[] invoke(File file) {
        File file2 = this.validateDirectory(file);
        final ArrayList arrayList = new ArrayList();
        this.process(file2, new RpfTocCrawlerListener(){

            public void fileFound(File file) {
                if (file.exists()) {
                    arrayList.add(file);
                }
            }

            public void finished() {
            }
        }, false);
        File[] fileArray = new File[arrayList.size()];
        arrayList.toArray(fileArray);
        return fileArray;
    }

    public void invoke(File file, RpfTocCrawlerListener rpfTocCrawlerListener) {
        File file2 = this.validateDirectory(file);
        this.process(file2, rpfTocCrawlerListener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(File file, RpfTocCrawlerListener rpfTocCrawlerListener) {
        this.threadLock.lock();
        try {
            if (this.thread != null || this.thread == this.deadThread) {
                String string = WorldWind.retrieveErrMsg("RpfTocCrawler.BadStart");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalStateException(string);
            }
            File file2 = this.validateDirectory(file);
            this.thread = new Thread(new RpfTocRunner(this, file2, rpfTocCrawlerListener));
            this.thread.start();
        }
        finally {
            this.threadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.threadLock.lock();
        try {
            this.thread = this.deadThread;
        }
        finally {
            this.threadLock.unlock();
        }
    }

    private File validateDirectory(File file) {
        if (file == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.FileIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        String string = file.getAbsolutePath();
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separatorChar;
            file = new File(string);
        }
        if (!file.exists()) {
            String string2 = WorldWind.retrieveErrMsg("generic.fileNotFound");
            WorldWind.logger().log(Level.FINE, string2);
            throw new IllegalArgumentException(string2);
        }
        return file;
    }

    private static class RpfTocRunner
    implements Runnable {
        private final RpfTocCrawler context;
        private final File directory;
        private final RpfTocCrawlerListener listener;

        public RpfTocRunner(RpfTocCrawler rpfTocCrawler, File file, RpfTocCrawlerListener rpfTocCrawlerListener) {
            this.context = rpfTocCrawler;
            this.directory = file;
            this.listener = rpfTocCrawlerListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.context.process(this.directory, this.listener, true);
            this.context.threadLock.lock();
            try {
                if (this.context.thread != this.context.deadThread) {
                    this.listener.finished();
                    this.context.thread = this.context.deadThread;
                }
            }
            finally {
                this.context.threadLock.unlock();
            }
        }
    }

    public static abstract class RpfTocGrouper
    implements RpfTocCrawlerListener {
        private final RpfFramePropertyType groupType;

        public RpfTocGrouper(RpfFramePropertyType rpfFramePropertyType) {
            if (rpfFramePropertyType == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RpfFramePropertyTypeIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            this.groupType = rpfFramePropertyType;
        }

        public void fileFound(File file) {
            RpfTocFile rpfTocFile = null;
            try {
                rpfTocFile = RpfTocFile.load(file);
            }
            catch (IOException iOException) {
                WorldWind.logger().log(Level.FINE, iOException.getMessage());
            }
            if (rpfTocFile == null) {
                return;
            }
            String string = RpfTocCrawler.findFirstRpfFrameFilename(rpfTocFile);
            if (string == null) {
                return;
            }
            RpfFrameProperties rpfFrameProperties = null;
            try {
                rpfFrameProperties = RpfFrameFilenameUtil.parseFilename(string);
            }
            catch (Exception exception) {
                String string2 = WorldWind.retrieveErrMsg("RpfTocCrawler.ExceptionParsingFilename");
                WorldWind.logger().log(Level.FINE, string2, exception);
            }
            if (rpfFrameProperties != null) {
                this.addToGroup(this.groupType.getInstance(rpfFrameProperties), rpfTocFile);
            }
        }

        public void finished() {
        }

        public abstract void addToGroup(Object var1, RpfTocFile var2);
    }

    public static interface RpfTocCrawlerListener {
        public void fileFound(File var1);

        public void finished();
    }
}

