/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.formats.nitfs.NitfsRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NitfsSegmentType;
import gov.nasa.worldwind.formats.rpf.RpfFile;
import gov.nasa.worldwind.formats.rpf.RpfFileComponents;
import gov.nasa.worldwind.formats.rpf.RpfFrameFileIndexSection;
import gov.nasa.worldwind.formats.rpf.RpfHeaderSection;
import gov.nasa.worldwind.formats.rpf.RpfUserDefinedHeaderSegment;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class RpfTocFile
extends RpfFile {
    private RpfFileComponents rpfFileComponents;

    public RpfHeaderSection getHeaderSection() {
        return null != this.rpfFileComponents ? this.rpfFileComponents.getRpfHeaderSection() : null;
    }

    public RpfFrameFileIndexSection getFrameFileIndexSection() {
        return null != this.rpfFileComponents ? this.rpfFileComponents.getRpfFrameFileIndexSection() : null;
    }

    public RpfFileComponents getRpfFileComponents() {
        return this.rpfFileComponents;
    }

    protected RpfTocFile(File file) throws IOException, NitfsRuntimeException {
        super(file);
        RpfUserDefinedHeaderSegment rpfUserDefinedHeaderSegment = (RpfUserDefinedHeaderSegment)this.getNitfsSegment(NitfsSegmentType.UserDefinedHeaderSegment);
        if (null == rpfUserDefinedHeaderSegment) {
            throw new NitfsRuntimeException("NitfsReader.UserDefinedHeaderSegmentWasNotFound");
        }
        this.rpfFileComponents = rpfUserDefinedHeaderSegment.getRpfFileComponents();
        if (null == this.rpfFileComponents) {
            throw new NitfsRuntimeException("NitfsReader.RpfFileComponents.Were.Not.Found.In.UserDefinedHeaderSegment");
        }
    }

    public static RpfTocFile load(File file) throws IOException {
        return new RpfTocFile(file);
    }

    public static void main(String[] stringArray) {
        String string = Configuration.isWindowsOS() ? "C:\\RPF\\A.TOC" : "/depot/WorldWindJ/utils/rpf/A.TOC";
        try {
            long l = System.currentTimeMillis();
            RpfTocFile rpfTocFile = RpfTocFile.load(new File(string));
            System.out.println(MessageFormat.format("TOC file loaded in {0} mSec", System.currentTimeMillis() - l));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

