/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.StringUtil;
import gov.nasa.worldwind.formats.nitfs.NitfsRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NitfsUserDefinedHeaderSegment;
import gov.nasa.worldwind.formats.rpf.RpfFileComponents;
import java.nio.ByteBuffer;

public class RpfUserDefinedHeaderSegment
extends NitfsUserDefinedHeaderSegment {
    private RpfFileComponents components;

    public RpfUserDefinedHeaderSegment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        if (!StringUtil.Equals("RPFHDR", this.dataTag)) {
            throw new NitfsRuntimeException("NitfsReader.RpfHeaderNotFoundInUserDefinedSegment", this.dataTag);
        }
        this.components = new RpfFileComponents(byteBuffer);
        this.restoreBufferPosition();
    }

    public RpfFileComponents getRpfFileComponents() {
        return this.components;
    }
}

