/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.formats.rpf.RpfDataSeries;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RpfZone {
    Zone1(Character.valueOf('1'), 369664, 400384, 0, 32),
    Zone2(Character.valueOf('2'), 302592, 400384, 32, 48),
    Zone3(Character.valueOf('3'), 245760, 400384, 48, 56),
    Zone4(Character.valueOf('4'), 199168, 400384, 56, 64),
    Zone5(Character.valueOf('5'), 163328, 400384, 64, 68),
    Zone6(Character.valueOf('6'), 137216, 400384, 68, 72),
    Zone7(Character.valueOf('7'), 110080, 400384, 72, 76),
    Zone8(Character.valueOf('8'), 82432, 400384, 76, 80),
    ZoneA(Character.valueOf('A'), 369664, 400384, 0, -32),
    ZoneB(Character.valueOf('B'), 302592, 400384, -32, -48),
    ZoneC(Character.valueOf('C'), 245760, 400384, -48, -56),
    ZoneD(Character.valueOf('D'), 199168, 400384, -56, -64),
    ZoneE(Character.valueOf('E'), 163328, 400384, -64, -68),
    ZoneF(Character.valueOf('F'), 137216, 400384, -68, -72),
    ZoneG(Character.valueOf('G'), 110080, 400384, -72, -76),
    ZoneH(Character.valueOf('H'), 82432, 400384, -76, -80);

    public static final int PixelRowsPerFrame = 1536;
    public static final int SubframeRowsPerFrame = 6;
    public final int eastWestPixelSpacingConstant;
    public final int equatorwardNominalBoundary;
    public final int northSouthPixelSpacingConstant;
    public final int polewardNominalBoundary;
    public final Character zoneCode;
    private static RpfZone[] enumConstantAlphabet;
    private static RpfZone[] northernHemisphereZones;
    private static RpfZone[] southernHemisphereZones;
    private static Map<ZoneKey, ZoneValues> zoneValuesDirectory;

    private RpfZone(Character c, int n2, int n3, int n4, int n5) {
        this.zoneCode = c;
        this.eastWestPixelSpacingConstant = n2;
        this.northSouthPixelSpacingConstant = n3;
        this.equatorwardNominalBoundary = n4;
        this.polewardNominalBoundary = n5;
    }

    private static RpfZone[] enumConstantAlphabet() {
        if (enumConstantAlphabet == null) {
            RpfZone[] rpfZoneArray = (RpfZone[])RpfZone.class.getEnumConstants();
            enumConstantAlphabet = new RpfZone[36];
            RpfZone[] rpfZoneArray2 = rpfZoneArray;
            int n = rpfZoneArray2.length;
            for (int i = 0; i < n; ++i) {
                RpfZone rpfZone;
                RpfZone.enumConstantAlphabet[RpfZone.indexFor((Character)rpfZone.zoneCode)] = rpfZone = rpfZoneArray2[i];
            }
        }
        return enumConstantAlphabet;
    }

    private static int indexFor(Character c) {
        if (c.charValue() >= '0' && c.charValue() <= '9') {
            return c.charValue() - 48;
        }
        if (c.charValue() >= 'A' && c.charValue() <= 'Z') {
            return 10 + c.charValue() - 65;
        }
        return -1;
    }

    private static RpfZone[] northernHemisphereZones() {
        if (northernHemisphereZones == null) {
            RpfZone[] rpfZoneArray = (RpfZone[])RpfZone.class.getEnumConstants();
            northernHemisphereZones = new RpfZone[rpfZoneArray.length / 2];
            int n = 0;
            for (RpfZone rpfZone : rpfZoneArray) {
                if (rpfZone.polewardNominalBoundary < 0) continue;
                RpfZone.northernHemisphereZones[n++] = rpfZone;
            }
        }
        return northernHemisphereZones;
    }

    private static RpfZone[] southernHemisphereZones() {
        if (southernHemisphereZones == null) {
            RpfZone[] rpfZoneArray = (RpfZone[])RpfZone.class.getEnumConstants();
            southernHemisphereZones = new RpfZone[rpfZoneArray.length / 2];
            int n = 0;
            for (RpfZone rpfZone : rpfZoneArray) {
                if (rpfZone.polewardNominalBoundary >= 0) continue;
                RpfZone.southernHemisphereZones[n++] = rpfZone;
            }
        }
        return southernHemisphereZones;
    }

    public static RpfZone zoneFor(Character c) {
        RpfZone rpfZone;
        if (c == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.CharacterIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        RpfZone[] rpfZoneArray = RpfZone.enumConstantAlphabet();
        int n = RpfZone.indexFor(Character.valueOf(Character.toUpperCase(c.charValue())));
        if (n < 0 || n >= rpfZoneArray.length || (rpfZone = rpfZoneArray[n]) == null) {
            String string = WorldWind.retrieveErrMsg("generic.EnumNotFound") + c;
            WorldWind.logger().log(Level.FINE, string);
            throw new EnumConstantNotPresentException(RpfZone.class, string);
        }
        return rpfZone;
    }

    public static RpfZone zoneFor(RpfDataSeries rpfDataSeries, Angle angle) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.degrees;
        if (d < 0.0) {
            return RpfZone.zoneForSouthernHemisphere(rpfDataSeries, d);
        }
        return RpfZone.zoneForNorthernHemisphere(rpfDataSeries, d);
    }

    private static RpfZone zoneForNorthernHemisphere(RpfDataSeries rpfDataSeries, double d) {
        for (RpfZone rpfZone : RpfZone.northernHemisphereZones()) {
            ZoneValues zoneValues = rpfZone.zoneValues(rpfDataSeries);
            if (!(d >= zoneValues.equatorwardExtent.degrees) || !(d <= zoneValues.polewardExtent.degrees)) continue;
            return rpfZone;
        }
        return null;
    }

    private static RpfZone zoneForSouthernHemisphere(RpfDataSeries rpfDataSeries, double d) {
        for (RpfZone rpfZone : RpfZone.southernHemisphereZones()) {
            ZoneValues zoneValues = rpfZone.zoneValues(rpfDataSeries);
            if (!(d <= zoneValues.equatorwardExtent.degrees) || !(d >= zoneValues.polewardExtent.degrees)) continue;
            return rpfZone;
        }
        return null;
    }

    public ZoneValues zoneValues(RpfDataSeries rpfDataSeries) {
        ZoneKey zoneKey = new ZoneKey(this, rpfDataSeries);
        ZoneValues zoneValues = RpfZone.zoneValuesDirectory().get(zoneKey);
        if (zoneValues == null) {
            zoneValues = new ZoneValues(this, rpfDataSeries);
            RpfZone.zoneValuesDirectory().put(zoneKey, zoneValues);
        }
        return zoneValues;
    }

    private static Map<ZoneKey, ZoneValues> zoneValuesDirectory() {
        if (zoneValuesDirectory == null) {
            zoneValuesDirectory = new HashMap<ZoneKey, ZoneValues>();
        }
        return zoneValuesDirectory;
    }

    static {
        enumConstantAlphabet = null;
        northernHemisphereZones = null;
        southernHemisphereZones = null;
        zoneValuesDirectory = null;
    }

    public static class ZoneValues {
        public final RpfZone zone;
        public final RpfDataSeries dataSeries;
        public final int eastWestPixelConstant;
        public final int northSouthPixelConstant;
        public final Angle equatorwardExtent;
        public final Angle polewardExtent;
        public final Sector extent;
        public final int latitudinalFrames;
        public final int longitudinalFrames;
        public final Angle latitudinalFrameExtent;
        public final Angle longitudinalFrameExtent;
        public final int maximumFrameNumber;

        private ZoneValues(RpfZone rpfZone, RpfDataSeries rpfDataSeries) {
            if (rpfZone == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RpfZoneIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            if (rpfDataSeries == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.RpfDataSeriesIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            this.zone = rpfZone;
            this.dataSeries = rpfDataSeries;
            this.northSouthPixelConstant = ZoneValues.computeNorthSouthPixelConstant(rpfZone.northSouthPixelSpacingConstant, rpfDataSeries);
            this.eastWestPixelConstant = ZoneValues.computeEastWestPixelConstant(rpfZone.eastWestPixelSpacingConstant, rpfDataSeries);
            this.equatorwardExtent = ZoneValues.computeEquatorwardExtent(rpfZone.equatorwardNominalBoundary, this.northSouthPixelConstant, 1536.0);
            this.polewardExtent = ZoneValues.computePolewardExtent(rpfZone.polewardNominalBoundary, this.northSouthPixelConstant, 1536.0);
            this.extent = ZoneValues.computeZoneExtent(this.equatorwardExtent.degrees, this.polewardExtent.degrees);
            this.latitudinalFrames = ZoneValues.computeLatitudinalFrames(this.polewardExtent.degrees, this.equatorwardExtent.degrees, this.northSouthPixelConstant, 1536.0);
            this.longitudinalFrames = ZoneValues.computeLongitudinalFrames(this.eastWestPixelConstant, 1536.0);
            this.latitudinalFrameExtent = ZoneValues.computeLatitudinalFrameExtent(this.polewardExtent.degrees, this.equatorwardExtent.degrees, this.latitudinalFrames);
            this.longitudinalFrameExtent = ZoneValues.computeLongitudinalFrameExtent(this.longitudinalFrames);
            this.maximumFrameNumber = ZoneValues.computeMaximumFrameNumber(this.latitudinalFrames, this.longitudinalFrames);
        }

        private static double clamp(double d, double d2, double d3) {
            return d < d2 ? d2 : (d > d3 ? d3 : d);
        }

        private static int computeEastWestPixelConstant(double d, RpfDataSeries rpfDataSeries) {
            if (rpfDataSeries.rpfDataType.equalsIgnoreCase("CADRG")) {
                return ZoneValues.computeEastWestPixelConstantCADRG(d, rpfDataSeries.scaleOrGSD);
            }
            if (rpfDataSeries.rpfDataType.equalsIgnoreCase("CIB")) {
                return ZoneValues.computeEastWestPixelConstantCIB(d, rpfDataSeries.scaleOrGSD);
            }
            String string = WorldWind.retrieveErrMsg("RpfZone.UnknownRpfDataType") + rpfDataSeries.rpfDataType;
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }

        private static int computeEastWestPixelConstantCADRG(double d, double d2) {
            double d3 = 1000000.0 / d2;
            double d4 = d * d3;
            d4 = 512.0 * (double)((int)Math.ceil(d4 / 512.0));
            return 256 * (int)Math.round((d4 /= 1.5) / 256.0);
        }

        private static int computeEastWestPixelConstantCIB(double d, double d2) {
            double d3 = 100.0 / d2;
            double d4 = d * d3;
            return 512 * (int)Math.ceil(d4 / 512.0);
        }

        private static Angle computeEquatorwardExtent(double d, double d2, double d3) {
            double d4 = d2 / 90.0;
            double d5 = Math.signum(d) * ZoneValues.clamp((double)((int)(d4 * Math.abs(d) / d3)) * d3 / d4, 0.0, 90.0);
            return Angle.fromDegrees(d5);
        }

        private static Angle computeLatitudinalFrameExtent(double d, double d2, double d3) {
            double d4 = Math.abs(d - d2) / d3;
            return Angle.fromDegrees(d4);
        }

        private static int computeLatitudinalFrames(double d, double d2, double d3, double d4) {
            double d5 = d3 / 90.0;
            double d6 = Math.abs(d - d2);
            return (int)Math.rint(d6 * d5 / d4);
        }

        public static Angle computeLongitudinalFrameExtent(double d) {
            double d2 = 360.0 / d;
            return Angle.fromDegrees(d2);
        }

        private static int computeLongitudinalFrames(double d, double d2) {
            return (int)Math.ceil(d / d2);
        }

        private static int computeMaximumFrameNumber(int n, int n2) {
            return n * n2 - 1;
        }

        private static int computeNorthSouthPixelConstant(double d, RpfDataSeries rpfDataSeries) {
            if (rpfDataSeries.rpfDataType.equalsIgnoreCase("CADRG")) {
                return ZoneValues.computeNorthSouthPixelConstantCADRG(d, rpfDataSeries.scaleOrGSD);
            }
            if (rpfDataSeries.rpfDataType.equalsIgnoreCase("CIB")) {
                return ZoneValues.computeNorthSouthPixelConstantCIB(d, rpfDataSeries.scaleOrGSD);
            }
            String string = WorldWind.retrieveErrMsg("RpfZone.UnknownRpfDataType") + rpfDataSeries.rpfDataType;
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }

        private static int computeNorthSouthPixelConstantCADRG(double d, double d2) {
            double d3 = 1000000.0 / d2;
            double d4 = d * d3;
            d4 = 512.0 * (double)((int)Math.ceil(d4 / 512.0));
            d4 /= 4.0;
            return 256 * (int)Math.round((d4 /= 1.5) / 256.0);
        }

        private static int computeNorthSouthPixelConstantCIB(double d, double d2) {
            double d3 = 100.0 / d2;
            double d4 = d * d3;
            d4 = 512.0 * (double)((int)Math.ceil(d4 / 512.0));
            return 256 * (int)Math.round((d4 /= 4.0) / 256.0);
        }

        private static Angle computePolewardExtent(double d, double d2, double d3) {
            double d4 = d2 / 90.0;
            double d5 = Math.signum(d) * ZoneValues.clamp(Math.ceil(d4 * Math.abs(d) / d3) * d3 / d4, 0.0, 90.0);
            return Angle.fromDegrees(d5);
        }

        private static Sector computeZoneExtent(double d, double d2) {
            double d3;
            double d4;
            if (d < d2) {
                d4 = d;
                d3 = d2;
            } else {
                d4 = d2;
                d3 = d;
            }
            return Sector.fromDegrees(d4, d3, -180.0, 180.0);
        }

        public int frameColumnFromFrameNumber(int n) {
            int n2 = this.frameRowFromFrameNumber(n);
            return n - n2 * this.longitudinalFrames;
        }

        public int frameColumnFromLongitude(Angle angle) {
            if (angle == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            return (int)((angle.degrees + 180.0) / 360.0 * ((double)this.eastWestPixelConstant / 1536.0));
        }

        public Sector frameExtent(int n) {
            Angle angle = this.latitudinalFrameOrigin(this.frameRowFromFrameNumber(n));
            Angle angle2 = this.longitudinalFrameOrigin(this.frameColumnFromFrameNumber(n));
            return new Sector(angle.subtract(this.latitudinalFrameExtent), angle, angle2, angle2.add(this.longitudinalFrameExtent));
        }

        public int frameNumber(int n, int n2) {
            return n2 + n * this.longitudinalFrames;
        }

        public int frameRowFromFrameNumber(int n) {
            return (int)((double)n / (double)this.longitudinalFrames);
        }

        public int frameRowFromLatitude(Angle angle) {
            if (angle == null) {
                String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
                WorldWind.logger().log(Level.FINE, string);
                throw new IllegalArgumentException(string);
            }
            return (int)((angle.degrees - this.equatorwardExtent.degrees) / 90.0 * ((double)this.northSouthPixelConstant / 1536.0));
        }

        public Angle latitudinalFrameOrigin(int n) {
            double d = 90.0 / (double)this.northSouthPixelConstant * 1536.0 * (double)(n + 1) + this.equatorwardExtent.degrees;
            return Angle.fromDegrees(d);
        }

        public Angle longitudinalFrameOrigin(int n) {
            double d = 360.0 / (double)this.eastWestPixelConstant * 1536.0 * (double)n - 180.0;
            return Angle.fromDegrees(d);
        }
    }

    private static class ZoneKey {
        public final RpfZone zone;
        public final RpfDataSeries dataSeries;
        private int hashCode;

        public ZoneKey(RpfZone rpfZone, RpfDataSeries rpfDataSeries) {
            this.zone = rpfZone;
            this.dataSeries = rpfDataSeries;
            this.hashCode = this.computeHash();
        }

        private int computeHash() {
            int n = 0;
            if (this.zone != null) {
                n = 29 * n + this.zone.ordinal();
            }
            if (this.dataSeries != null) {
                n = 29 * n + this.dataSeries.ordinal();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            ZoneKey zoneKey = (ZoneKey)object;
            return this.zone == zoneKey.zone && this.dataSeries == zoneKey.dataSeries;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

