/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Quaternion;
import java.util.logging.Level;

public class LatLon {
    private final Angle latitude;
    private final Angle longitude;

    public static LatLon fromRadians(double d, double d2) {
        return new LatLon(Math.toDegrees(d), Math.toDegrees(d2));
    }

    public static LatLon fromDegrees(double d, double d2) {
        return new LatLon(d, d2);
    }

    private LatLon(double d, double d2) {
        this.latitude = Angle.fromDegrees(d);
        this.longitude = Angle.fromDegrees(d2);
    }

    public LatLon(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatitudeOrLongitudeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = angle;
        this.longitude = angle2;
    }

    public final Angle getLatitude() {
        return this.latitude;
    }

    public final Angle getLongitude() {
        return this.longitude;
    }

    public static LatLon interpolate(double d, LatLon latLon, LatLon latLon2) {
        Quaternion quaternion;
        if (latLon == null || latLon2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.LatitudeOrLongitudeIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            return latLon;
        }
        if (d > 1.0) {
            return latLon2;
        }
        Quaternion quaternion2 = Quaternion.EulerToQuaternion(latLon.getLongitude().getRadians(), latLon.getLatitude().getRadians(), 0.0);
        Quaternion quaternion3 = Quaternion.Slerp(quaternion2, quaternion = Quaternion.EulerToQuaternion(latLon2.getLongitude().getRadians(), latLon2.getLatitude().getRadians(), 0.0), d);
        Point point = Quaternion.QuaternionToEuler(quaternion3);
        if (Double.isNaN(point.x()) || Double.isNaN(point.y())) {
            return null;
        }
        return LatLon.fromRadians(point.y(), point.x());
    }

    public String toString() {
        return "(" + this.latitude.toString() + ", " + this.longitude.toString() + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LatLon latLon = (LatLon)object;
        if (!this.latitude.equals(latLon.latitude)) {
            return false;
        }
        return this.longitude.equals(latLon.longitude);
    }

    public int hashCode() {
        int n = this.latitude.hashCode();
        n = 29 * n + this.longitude.hashCode();
        return n;
    }
}

