/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Point;
import java.util.logging.Level;

public final class Plane {
    private final Point n;

    public Plane(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.VectorIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (point.selfDot() == 0.0) {
            String string = WorldWind.retrieveErrMsg("geom.Plane.VectorIsZero");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.n = point;
    }

    public Plane(double d, double d2, double d3, double d4) {
        if (d == 0.0 && d2 == 0.0 && d3 == 0.0) {
            String string = WorldWind.retrieveErrMsg("geom.Plane.VectorIsZero");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.n = new Point(d, d2, d3, d4);
    }

    public final Point getNormal() {
        return new Point(this.n.x(), this.n.y(), this.n.z());
    }

    public final double getDistance() {
        return this.n.w();
    }

    public final Point getVector() {
        return this.n;
    }

    public final double dot(Point point) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PointIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return this.n.x() * point.x() + this.n.y() * point.y() + this.n.z() * point.z() + this.n.w() * point.w();
    }

    public final String toString() {
        return this.n.toString();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Plane plane = (Plane)object;
        return this.n.normalize().equals(plane.n.normalize());
    }

    public final int hashCode() {
        return this.n.hashCode();
    }
}

