/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.DrawContext;
import gov.nasa.worldwind.Renderable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Point;
import gov.nasa.worldwind.geom.Position;
import java.awt.Color;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polyline
implements Renderable {
    private ArrayList<Position> positions;
    private Point referenceCenter;
    private DoubleBuffer vertices;
    private int antiAliasHint = 4353;
    private Color color = Color.WHITE;
    private boolean filled = false;
    private boolean followGreatCircles = true;
    private int numEdgeIntervals = 10;

    public Polyline(Iterable<Position> iterable) {
        if (iterable == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PositionsListIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.setPositions(iterable);
    }

    public Polyline(Iterable<LatLon> iterable, double d) {
        if (iterable == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PositionsListIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.setPositions(iterable, d);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.ColorIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    public int getAntiAliasHint() {
        return this.antiAliasHint;
    }

    public void setAntiAliasHint(int n) {
        if (n != 4352 && n != 4353 && n != 4354) {
            String string = WorldWind.retrieveErrMsg("generic.InvalidHint");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.antiAliasHint = n;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    public boolean isFollowGreatCircles() {
        return this.followGreatCircles;
    }

    public void setFollowGreatCircles(boolean bl) {
        this.followGreatCircles = bl;
    }

    public int getNumEdgeIntervals() {
        return this.numEdgeIntervals;
    }

    public void setNumEdgeIntervals(int n) {
        this.numEdgeIntervals = n;
    }

    public void setPositions(Iterable<Position> iterable) {
        if (iterable == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PositionsListIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.positions = new ArrayList();
        for (Position position : iterable) {
            this.positions.add(position);
        }
        if (this.filled && this.positions.size() < 3 || !this.filled && this.positions.size() < 2) {
            String string = WorldWind.retrieveErrMsg("generic.InsufficientPositions");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.vertices = null;
    }

    public void setPositions(Iterable<LatLon> iterable, double d) {
        if (iterable == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.PositionsListIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.positions = new ArrayList();
        for (LatLon latLon : iterable) {
            this.positions.add(new Position(latLon.getLatitude(), latLon.getLongitude(), d));
        }
        if (this.positions.size() < 2 || this.filled && this.positions.size() < 3) {
            String string = WorldWind.retrieveErrMsg("generic.InsufficientPositions");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.vertices = null;
    }

    public Iterable<Position> getPositions() {
        return this.positions;
    }

    private void intializeGeometry(DrawContext drawContext) {
        if (this.positions.size() < 2) {
            return;
        }
        double[] dArray = new double[3];
        this.vertices = this.followGreatCircles ? this.makeGreatCircleVertices(drawContext, this.positions, dArray) : this.makeVertices(drawContext, this.positions, dArray);
        this.referenceCenter = new Point(dArray[0], dArray[1], dArray[2]);
        double d = this.referenceCenter.getX();
        double d2 = this.referenceCenter.getY();
        double d3 = this.referenceCenter.getZ();
        this.vertices.rewind();
        for (int i = 0; i < this.vertices.limit(); i += 3) {
            this.vertices.put(i, this.vertices.get(i) - d);
            this.vertices.put(i + 1, this.vertices.get(i + 1) - d2);
            this.vertices.put(i + 2, this.vertices.get(i + 2) - d3);
        }
    }

    protected DoubleBuffer makeVertices(DrawContext drawContext, List<Position> list, double[] dArray) {
        DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(list.size() * 3);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        for (Position position : list) {
            Point point = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), position.getElevation());
            doubleBuffer.put(point.x()).put(point.y()).put(point.z());
            d += point.x();
            d2 += point.y();
            d3 += point.z();
            ++n;
        }
        dArray[0] = d / (double)n;
        dArray[1] = d2 / (double)n;
        dArray[2] = d3 / (double)n;
        return doubleBuffer;
    }

    protected DoubleBuffer makeGreatCircleVertices(DrawContext drawContext, List<Position> list, double[] dArray) {
        if (list.size() < 1) {
            return null;
        }
        int n = list.size() + (this.numEdgeIntervals - 1) * (list.size() - 1);
        DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(n * 3);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        Iterator<Position> iterator = list.iterator();
        Position position = iterator.next();
        Point point = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), position.getElevation());
        doubleBuffer.put(point.x());
        doubleBuffer.put(point.y());
        doubleBuffer.put(point.z());
        d += point.x();
        d2 += point.y();
        d3 += point.z();
        ++n2;
        double d4 = 1.0 / (double)this.numEdgeIntervals;
        while (iterator.hasNext()) {
            Position position2 = iterator.next();
            for (int i = 1; i < this.numEdgeIntervals; ++i) {
                LatLon latLon = LatLon.interpolate((double)i * d4, new LatLon(position.getLatitude(), position.getLongitude()), new LatLon(position2.getLatitude(), position2.getLongitude()));
                double d5 = (double)i * d4 * position.getElevation() + (1.0 - (double)i * d4) * position2.getElevation();
                point = drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d5);
                doubleBuffer.put(point.x()).put(point.y()).put(point.z());
                d += point.x();
                d2 += point.y();
                d3 += point.z();
                ++n2;
            }
            point = drawContext.getGlobe().computePointFromPosition(position2.getLatitude(), position2.getLongitude(), position.getElevation());
            doubleBuffer.put(point.x()).put(point.y()).put(point.z());
            d += point.x();
            d2 += point.y();
            d3 += point.z();
            ++n2;
            position = position2;
        }
        dArray[0] = d / (double)n2;
        dArray[1] = d2 / (double)n2;
        dArray[2] = d3 / (double)n2;
        return doubleBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.DrawContextIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalStateException(string);
        }
        if (this.vertices == null) {
            this.intializeGeometry(drawContext);
            if (this.vertices == null) {
                return;
            }
        }
        GL gL = drawContext.getGL();
        int n = 32769;
        if (!drawContext.isPickingMode()) {
            ++n;
            if (this.color.getAlpha() != 255) {
                n += 16384;
            }
        }
        gL.glPushAttrib(n);
        gL.glPushClientAttrib(2);
        drawContext.getView().pushReferenceCenter(drawContext, this.referenceCenter);
        try {
            if (!drawContext.isPickingMode()) {
                if (this.color.getAlpha() != 255) {
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                }
                drawContext.getGL().glColor4ub((byte)this.color.getRed(), (byte)this.color.getGreen(), (byte)this.color.getBlue(), (byte)this.color.getAlpha());
            }
            int n2 = 3154;
            if (this.filled) {
                n2 = 3155;
            }
            gL.glHint(n2, this.antiAliasHint);
            gL.glEnableClientState(32884);
            gL.glVertexPointer(3, 5130, 0, this.vertices.rewind());
            int n3 = 3;
            if (this.filled) {
                n3 = 9;
            }
            gL.glDrawArrays(n3, 0, this.vertices.capacity() / 3);
        }
        finally {
            gL.glPopClientAttrib();
            gL.glPopAttrib();
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }
}

