/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Point;
import java.util.logging.Level;

public class Quaternion {
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    private static final double epsilon = 1.0E-4;

    public Quaternion(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Quaternion quaternion = (Quaternion)object;
        if (Double.compare(quaternion.w, this.w) != 0) {
            return false;
        }
        if (Double.compare(quaternion.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(quaternion.y, this.y) != 0) {
            return false;
        }
        return Double.compare(quaternion.z, this.z) == 0;
    }

    public int hashCode() {
        long l = this.x != 0.0 ? Double.doubleToLongBits(this.x) : 0L;
        int n = (int)(l ^ l >>> 32);
        l = this.y != 0.0 ? Double.doubleToLongBits(this.y) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.z != 0.0 ? Double.doubleToLongBits(this.z) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.w != 0.0 ? Double.doubleToLongBits(this.w) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public final String toString() {
        return "(" + Double.toString(this.x) + ", " + Double.toString(this.y) + ", " + Double.toString(this.z) + ", " + Double.toString(this.w) + ")";
    }

    public static Quaternion EulerToQuaternion(double d, double d2, double d3) {
        double d4 = Math.cos(d * 0.5);
        double d5 = Math.cos(d2 * 0.5);
        double d6 = Math.cos(d3 * 0.5);
        double d7 = Math.sin(d * 0.5);
        double d8 = Math.sin(d2 * 0.5);
        double d9 = Math.sin(d3 * 0.5);
        double d10 = d4 * d5 * d6 + d7 * d8 * d9;
        double d11 = d7 * d5 * d6 - d4 * d8 * d9;
        double d12 = d4 * d8 * d6 + d7 * d5 * d9;
        double d13 = d4 * d5 * d9 - d7 * d8 * d6;
        return new Quaternion(d11, d12, d13, d10);
    }

    public static Point QuaternionToEuler(Quaternion quaternion) {
        if (quaternion == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = quaternion.w;
        double d2 = quaternion.x;
        double d3 = quaternion.y;
        double d4 = quaternion.z;
        double d5 = Math.atan2(2.0 * (d3 * d4 + d * d2), d * d - d2 * d2 - d3 * d3 + d4 * d4);
        double d6 = Math.asin(-2.0 * (d2 * d4 - d * d3));
        double d7 = Math.atan2(2.0 * (d2 * d3 + d * d4), d * d + d2 * d2 - d3 * d3 - d4 * d4);
        return new Point(d5, d6, d7);
    }

    public static Quaternion AxisAngleToQuaternion(Angle angle, double d, double d2, double d3) {
        if (angle == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.AngleIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d4 > 0.0 && d4 != 1.0) {
            d /= d4;
            d2 /= d4;
            d3 /= d4;
        }
        double d5 = angle.sinHalfAngle();
        double d6 = angle.cosHalfAngle();
        return new Quaternion(d * d5, d2 * d5, d3 * d5, d6);
    }

    public static Point QuaternionToAxisAngle(Quaternion quaternion) {
        double d;
        double d2;
        double d3;
        if (quaternion == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        quaternion = quaternion.Normalize();
        double d4 = Math.sqrt(quaternion.x * quaternion.x + quaternion.y * quaternion.y + quaternion.x * quaternion.z);
        if (d4 > 0.0) {
            d3 = quaternion.x / d4;
            d2 = quaternion.y / d4;
            d = quaternion.z / d4;
        } else {
            d3 = quaternion.x;
            d2 = quaternion.y;
            d = quaternion.z;
        }
        double d5 = 2.0 * Math.acos(quaternion.w);
        return new Point(d3, d2, d, d5);
    }

    public static Quaternion Add(Quaternion quaternion, Quaternion quaternion2) {
        if (quaternion == null || quaternion2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(quaternion.x + quaternion2.x, quaternion.y + quaternion2.y, quaternion.z + quaternion2.z, quaternion.w + quaternion2.w);
    }

    public static Quaternion Subtract(Quaternion quaternion, Quaternion quaternion2) {
        if (quaternion == null || quaternion2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(quaternion.x - quaternion2.x, quaternion.y - quaternion2.y, quaternion.z - quaternion2.z, quaternion.w - quaternion2.w);
    }

    public static Quaternion Multiply(Quaternion quaternion, Quaternion quaternion2) {
        if (quaternion == null || quaternion2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(quaternion.w * quaternion2.x + quaternion.x * quaternion2.w + quaternion.y * quaternion2.z - quaternion.z * quaternion2.y, quaternion.w * quaternion2.y + quaternion.y * quaternion2.w + quaternion.z * quaternion2.x - quaternion.x * quaternion2.z, quaternion.w * quaternion2.z + quaternion.z * quaternion2.w + quaternion.x * quaternion2.y - quaternion.y * quaternion2.x, quaternion.w * quaternion2.w - quaternion.x * quaternion2.x - quaternion.y * quaternion2.y - quaternion.z * quaternion2.z);
    }

    public static Quaternion Multiply(double d, Quaternion quaternion) {
        if (quaternion == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(d * quaternion.x, d * quaternion.y, d * quaternion.z, d * quaternion.w);
    }

    public static Quaternion Multiply(Quaternion quaternion, double d) {
        if (quaternion == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(d * quaternion.x, d * quaternion.y, d * quaternion.z, d * quaternion.w);
    }

    public static Quaternion Multiply(Point point, Quaternion quaternion) {
        if (point == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.VectorIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (quaternion == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return new Quaternion(point.x() * quaternion.w + point.y() * quaternion.z - point.z() * quaternion.y, point.y() * quaternion.w + point.z() * quaternion.x - point.x() * quaternion.z, point.z() * quaternion.w + point.x() * quaternion.y - point.y() * quaternion.x, -point.x() * quaternion.x - point.y() * quaternion.y - point.z() * quaternion.z);
    }

    public static Quaternion Divide(Quaternion quaternion, double d) {
        if (quaternion == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return Quaternion.Multiply(quaternion, 1.0 / d);
    }

    public Quaternion Conjugate() {
        return new Quaternion(-this.x, -this.y, -this.z, this.w);
    }

    public static double Norm2(Quaternion quaternion) {
        if (quaternion == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return quaternion.x * quaternion.x + quaternion.y * quaternion.y + quaternion.z * quaternion.z + quaternion.w * quaternion.w;
    }

    public static double Abs(Quaternion quaternion) {
        if (quaternion == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return Math.sqrt(Quaternion.Norm2(quaternion));
    }

    public static Quaternion Divide(Quaternion quaternion, Quaternion quaternion2) {
        if (quaternion == null || quaternion2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return Quaternion.Multiply(quaternion, Quaternion.Divide(quaternion2.Conjugate(), Quaternion.Abs(quaternion2)));
    }

    public static double Dot(Quaternion quaternion, Quaternion quaternion2) {
        if (quaternion == null || quaternion2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z + quaternion.w * quaternion2.w;
    }

    public Quaternion Normalize() {
        double d = this.Length();
        return new Quaternion(this.x / d, this.y / d, this.z / d, this.w / d);
    }

    public double Length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public static Quaternion Slerp(Quaternion quaternion, Quaternion quaternion2, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        if (quaternion == null || quaternion2 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d8 = quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z + quaternion.w * quaternion2.w;
        if (d8 < 0.0) {
            d8 = -d8;
            d7 = -quaternion2.x;
            d6 = -quaternion2.y;
            d5 = -quaternion2.z;
            d4 = -quaternion2.w;
        } else {
            d7 = quaternion2.x;
            d6 = quaternion2.y;
            d5 = quaternion2.z;
            d4 = quaternion2.w;
        }
        if (1.0 - d8 > 1.0E-4) {
            double d9 = Math.acos(d8);
            double d10 = Math.sin(d9);
            d3 = Math.sin((1.0 - d) * d9) / d10;
            d2 = Math.sin(d * d9) / d10;
        } else {
            d3 = 1.0 - d;
            d2 = d;
        }
        return new Quaternion(d3 * quaternion.x + d2 * d7, d3 * quaternion.y + d2 * d6, d3 * quaternion.z + d2 * d5, d3 * quaternion.w + d2 * d4);
    }

    public Quaternion Ln() {
        return Quaternion.Ln(this);
    }

    public static Quaternion Ln(Quaternion quaternion) {
        if (quaternion == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = Math.sqrt(quaternion.x * quaternion.x + quaternion.y * quaternion.y + quaternion.z * quaternion.z);
        double d2 = Math.atan2(d, quaternion.w);
        double d3 = Math.abs(d) < 1.0E-4 ? 0.0 : d2 / d;
        return new Quaternion(quaternion.x * d3, quaternion.y * d3, quaternion.z * d3, 0.0);
    }

    public static Quaternion Exp(Quaternion quaternion) {
        if (quaternion == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        double d = Math.sqrt(quaternion.x * quaternion.x + quaternion.y * quaternion.y + quaternion.z * quaternion.z);
        double d2 = Math.abs(d) < 1.0E-4 ? 1.0 : Math.sin(d) / d;
        return new Quaternion(quaternion.x * d2, quaternion.y * d2, quaternion.z * d2, Math.cos(d));
    }

    public Quaternion Exp() {
        return Quaternion.Ln(this);
    }

    public static Quaternion Squad(Quaternion quaternion, Quaternion quaternion2, Quaternion quaternion3, Quaternion quaternion4, double d) {
        if (quaternion == null || quaternion2 == null || quaternion3 == null || quaternion4 == null) {
            String string = WorldWind.retrieveErrMsg("nullValue.QuaternionIsNull");
            WorldWind.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        return Quaternion.Slerp(Quaternion.Slerp(quaternion, quaternion4, d), Quaternion.Slerp(quaternion2, quaternion3, d), 2.0 * d * (1.0 - d));
    }
}

